%option nodefault
%option 8bit
%option never-interactive
%option prefix="__sd_domnode_xml_"
%option nounput
%option noyywrap
%option reentrant
%option bison-bridge
%option read
%option fast
%option header-file="domnode-xml-scanner.h"
%option outfile="domnode-xml-scanner.c"

%{
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include "error.h"
#include "malloc.h"
#include "domnode-xml.h"

/* Generated by bison(1) */
#include "domnode-xml-parser.h"

#ifdef strdup
#	undef strdup
#endif
#define strdup sd_strdup
#ifdef malloc
#	undef malloc
#endif
#define malloc sd_malloc
#ifdef calloc
#	undef calloc
#endif
#define calloc sd_calloc
#ifdef realloc
#	undef realloc
#endif
#define realloc sd_realloc
#ifdef yyerror
#	undef yyerror
#endif
#define yyerror sd_error

/******************************************************************************/
/* Extract a single word */
static char* word(const char *s)
{
    char *buf;
    int i, k;
    
    for (k = 0; isspace(s[k]) || s[k] == '<'; k++);
    for (i = k; s[i] && ! isspace(s[i]); i++);
    
    buf = malloc((i - k + 1) * sizeof(char));
    strncpy(buf, &s[k], i - k);
    buf[i - k] = 0;
    
    return buf;
}

/******************************************************************************/
/* Extract text between " " */
static char* string(const char* s)
{
    char* buf;
    int i;
    
    buf = strdup(s + 1);
    for (i = 0; buf[i] != '"'; i++);
    buf[i] = 0;
    
    return buf;
}

/******************************************************************************/
/* Extract text between <!-- --> */
static char* comment(const char* s)
{
    char* buf;
    int i, k;
    
    for (k = 4; isspace(s[k]); k++);
    for (i = k; strncmp(&s[i], "-->", 3); i++);
    
    buf = malloc((i - k + 1) * sizeof(char));
    strncpy(buf, &s[k], i - k);
    buf[i - k] = 0;
    
    return buf;
}

%}

nl		(\r\n|\r|\n)
ws		[ \t\r\n]+
open		{ws}*"<"
close		">"{ws}*
namestart	[A-Za-z\200-\377_]
namechar	[A-Za-z\200-\377_0-9.-]
name		{namestart}{namechar}*
data		([^<\n&])+
comment         {open}"!--"([^-]|"-"[^-])+"--"{close}
ignored		{open}[!?][^-][^>]*{close}
string		\"([^"&])*\"|\'([^'&])*\'

%s CONTENT

%%

<INITIAL>{ws}		{/* skip */}
<INITIAL>"/"		{ return SLASH; }
<INITIAL>"="		{ return EQ; }
<INITIAL>{close}	{ BEGIN(CONTENT); return CLOSE; }
<INITIAL>{name}		{ yylvalp->s = strdup(yytext); return NAME; }
<INITIAL>{string}	{ yylvalp->s = string(yytext); return VALUE; }
<INITIAL>"?"{close}	{ return ENDDEF; }

{open}{ws}?{name}	{
                          BEGIN(INITIAL);
                          yylvalp->s = word(yytext);
                          return START;
                        }
{open}{ws}?"/"		{BEGIN(INITIAL); return END;}
{comment}               {yylvalp->s = comment(yytext); return COMMENT;}
{ignored}		{/* skip */}

<CONTENT>{data}		{yylvalp->s = strdup(yytext); return DATA;}

.			{ yyerror("wrong XML input '%c'", *yytext); }
{nl}			{/* skip, must be an extra one at EOF */}
