/* map.c generated by valac 0.36.11, the Vala compiler
 * generated from map.vala, do not modify */

/* map.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_MAP_TYPE_ENTRY (gee_map_entry_get_type ())
#define GEE_MAP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntry))
#define GEE_MAP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))
#define GEE_MAP_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))

typedef struct _GeeMapEntry GeeMapEntry;
typedef struct _GeeMapEntryClass GeeMapEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_MAP (gee_abstract_map_get_type ())
#define GEE_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap))
#define GEE_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))
#define GEE_IS_ABSTRACT_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_MAP))
#define GEE_IS_ABSTRACT_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_MAP))
#define GEE_ABSTRACT_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_MAP, GeeAbstractMapClass))

typedef struct _GeeAbstractMap GeeAbstractMap;
typedef struct _GeeAbstractMapClass GeeAbstractMapClass;

#define GEE_TYPE_HASH_MAP (gee_hash_map_get_type ())
#define GEE_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_MAP, GeeHashMap))
#define GEE_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_MAP, GeeHashMapClass))
#define GEE_IS_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_MAP))
#define GEE_IS_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_MAP))
#define GEE_HASH_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_MAP, GeeHashMapClass))

typedef struct _GeeHashMap GeeHashMap;
typedef struct _GeeHashMapClass GeeHashMapClass;
typedef struct _GeeMapEntryPrivate GeeMapEntryPrivate;

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy* * lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
	gpointer (*first_match) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*any_match) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*all_match) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	gpointer (*max) (GeeTraversable* self, GCompareDataFunc compare, void* compare_target, GDestroyNotify compare_target_destroy_notify);
	gpointer (*min) (GeeTraversable* self, GCompareDataFunc compare, void* compare_target, GDestroyNotify compare_target_destroy_notify);
	GeeIterator* (*order_by) (GeeTraversable* self, GCompareDataFunc compare, void* compare_target, GDestroyNotify compare_target_destroy_notify);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

typedef gpointer (*GeeFoldMapFunc) (gconstpointer k, gconstpointer v, gpointer a, void* user_data);
typedef gboolean (*GeeForallMapFunc) (gconstpointer k, gconstpointer v, void* user_data);
struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_k_type) (GeeMapIterator* self);
	GBoxedCopyFunc (*get_k_dup_func) (GeeMapIterator* self);
	GDestroyNotify (*get_k_destroy_func) (GeeMapIterator* self);
	GType (*get_v_type) (GeeMapIterator* self);
	GBoxedCopyFunc (*get_v_dup_func) (GeeMapIterator* self);
	GDestroyNotify (*get_v_destroy_func) (GeeMapIterator* self);
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
	gpointer (*fold) (GeeMapIterator* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldMapFunc f, void* f_target, gpointer seed);
	gboolean (*foreach) (GeeMapIterator* self, GeeForallMapFunc f, void* f_target);
	gboolean (*get_valid) (GeeMapIterator* self);
	gboolean (*get_mutable) (GeeMapIterator* self);
	gboolean (*get_read_only) (GeeMapIterator* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeSet* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeSet* self);
	GDestroyNotify (*get_g_destroy_func) (GeeSet* self);
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	GType (*get_k_type) (GeeMap* self);
	GBoxedCopyFunc (*get_k_dup_func) (GeeMap* self);
	GDestroyNotify (*get_k_destroy_func) (GeeMap* self);
	GType (*get_v_type) (GeeMap* self);
	GBoxedCopyFunc (*get_v_dup_func) (GeeMap* self);
	GDestroyNotify (*get_v_destroy_func) (GeeMap* self);
	gboolean (*has_key) (GeeMap* self, gconstpointer key);
	gboolean (*has) (GeeMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	GeeMapIterator* (*map_iterator) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeMap* self, GeeMap* map);
	gboolean (*has_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
	gboolean (*get_read_only) (GeeMap* self);
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	GeeSet* (*get_entries) (GeeMap* self);
	GeeMap* (*get_read_only_view) (GeeMap* self);
};

typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeMapEntry {
	GObject parent_instance;
	GeeMapEntryPrivate * priv;
};

struct _GeeMapEntryClass {
	GObjectClass parent_class;
	gconstpointer (*get_key) (GeeMapEntry* self);
	gconstpointer (*get_value) (GeeMapEntry* self);
	void (*set_value) (GeeMapEntry* self, gconstpointer value);
	gboolean (*get_read_only) (GeeMapEntry* self);
};

struct _GeeMapEntryPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};


static gpointer gee_map_entry_parent_class = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_map_iterator_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_map_entry_get_type (void) G_GNUC_CONST;
GType gee_map_get_type (void) G_GNUC_CONST;
gboolean gee_map_has_key (GeeMap* self, gconstpointer key);
gboolean gee_map_contains (GeeMap* self, gconstpointer key) G_GNUC_DEPRECATED;
gboolean gee_map_has (GeeMap* self, gconstpointer key, gconstpointer value);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
void gee_map_set (GeeMap* self, gconstpointer key, gconstpointer value);
gboolean gee_map_unset (GeeMap* self, gconstpointer key, gpointer* value);
gboolean gee_map_remove (GeeMap* self, gconstpointer key, gpointer* value) G_GNUC_DEPRECATED;
void gee_map_clear (GeeMap* self);
GeeMapIterator* gee_map_map_iterator (GeeMap* self);
void gee_map_set_all (GeeMap* self, GeeMap* map);
static void gee_map_real_set_all (GeeMap* self, GeeMap* map);
GeeSet* gee_map_get_entries (GeeMap* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gconstpointer gee_map_entry_get_key (GeeMapEntry* self);
gconstpointer gee_map_entry_get_value (GeeMapEntry* self);
gboolean gee_map_unset_all (GeeMap* self, GeeMap* map);
static gboolean gee_map_real_unset_all (GeeMap* self, GeeMap* map);
GeeSet* gee_map_get_keys (GeeMap* self);
gboolean gee_map_remove_all (GeeMap* self, GeeMap* map) G_GNUC_DEPRECATED;
gboolean gee_map_has_all (GeeMap* self, GeeMap* map);
static gboolean gee_map_real_has_all (GeeMap* self, GeeMap* map);
gboolean gee_map_contains_all (GeeMap* self, GeeMap* map) G_GNUC_DEPRECATED;
GeeMap* gee_map_empty (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
GeeHashMap* gee_hash_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeHashDataFunc key_hash_func, void* key_hash_func_target, GDestroyNotify key_hash_func_target_destroy_notify, GeeEqualDataFunc key_equal_func, void* key_equal_func_target, GDestroyNotify key_equal_func_target_destroy_notify, GeeEqualDataFunc value_equal_func, void* value_equal_func_target, GDestroyNotify value_equal_func_target_destroy_notify);
GeeHashMap* gee_hash_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeHashDataFunc key_hash_func, void* key_hash_func_target, GDestroyNotify key_hash_func_target_destroy_notify, GeeEqualDataFunc key_equal_func, void* key_equal_func_target, GDestroyNotify key_equal_func_target_destroy_notify, GeeEqualDataFunc value_equal_func, void* value_equal_func_target, GDestroyNotify value_equal_func_target_destroy_notify);
GType gee_abstract_map_get_type (void) G_GNUC_CONST;
GType gee_hash_map_get_type (void) G_GNUC_CONST;
GeeMap* gee_abstract_map_get_read_only_view (GeeAbstractMap* self);
gint gee_map_get_size (GeeMap* self);
gboolean gee_map_get_is_empty (GeeMap* self);
gboolean gee_map_get_read_only (GeeMap* self);
GeeCollection* gee_map_get_values (GeeMap* self);
GeeMap* gee_map_get_read_only_view (GeeMap* self);
GType gee_map_get_key_type (GeeMap* self);
GType gee_map_get_value_type (GeeMap* self);
#define GEE_MAP_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_MAP_TYPE_ENTRY, GeeMapEntryPrivate))
enum  {
	GEE_MAP_ENTRY_0_PROPERTY,
	GEE_MAP_ENTRY_K_TYPE,
	GEE_MAP_ENTRY_K_DUP_FUNC,
	GEE_MAP_ENTRY_K_DESTROY_FUNC,
	GEE_MAP_ENTRY_V_TYPE,
	GEE_MAP_ENTRY_V_DUP_FUNC,
	GEE_MAP_ENTRY_V_DESTROY_FUNC,
	GEE_MAP_ENTRY_KEY_PROPERTY,
	GEE_MAP_ENTRY_VALUE_PROPERTY,
	GEE_MAP_ENTRY_READ_ONLY_PROPERTY
};
GeeMapEntry* gee_map_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
void gee_map_entry_set_value (GeeMapEntry* self, gconstpointer value);
gboolean gee_map_entry_get_read_only (GeeMapEntry* self);
static void _vala_gee_map_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_map_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Determines whether this map has the specified key.
 *
 * @param key the key to locate in the map
 *
 * @return    ``true`` if key is found, ``false`` otherwise
 */
gboolean gee_map_has_key (GeeMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->has_key (self, key);
}


/**
 * Determines whether this map contains the specified key.
 *
 * @param key the key to locate in the map
 *
 * @return    ``true`` if key is found, ``false`` otherwise
 */
gboolean gee_map_contains (GeeMap* self, gconstpointer key) {
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = key;
	_tmp1_ = gee_map_has_key (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Determines whether this map has the specified key/value entry.
 *
 * @param key the key to locate in the map
 * @param value the corresponding value
 *
 * @return    ``true`` if key is found, ``false`` otherwise
 */
gboolean gee_map_has (GeeMap* self, gconstpointer key, gconstpointer value) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->has (self, key, value);
}


/**
 * Returns the value of the specified key in this map.
 *
 * @param key the key whose value is to be retrieved
 *
 * @return    the value associated with the key, or ``null`` if the key
 *            couldn't be found
 */
gpointer gee_map_get (GeeMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->get (self, key);
}


/**
 * Inserts a new key and value into this map.
 *
 * @param key   the key to insert
 * @param value the value to associate with the key
 */
void gee_map_set (GeeMap* self, gconstpointer key, gconstpointer value) {
	g_return_if_fail (self != NULL);
	GEE_MAP_GET_INTERFACE (self)->set (self, key, value);
}


/**
 * Removes the specified key from this map.
 *
 * @param key   the key to remove from the map
 * @param value the receiver variable for the removed value
 *
 * @return    ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean gee_map_unset (GeeMap* self, gconstpointer key, gpointer* value) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->unset (self, key, value);
}


/**
 * Removes the specified key from this map.
 *
 * @param key   the key to remove from the map
 * @param value the receiver variable for the removed value
 *
 * @return    ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean gee_map_remove (GeeMap* self, gconstpointer key, gpointer* value) {
	gpointer _vala_value = NULL;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	_tmp0_ = key;
	_tmp2_ = gee_map_unset (self, _tmp0_, &_tmp1_);
	((_vala_value == NULL) || (GEE_MAP_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_vala_value = (GEE_MAP_GET_INTERFACE (self)->get_v_destroy_func (self) (_vala_value), NULL));
	_vala_value = _tmp1_;
	result = _tmp2_;
	if (value) {
		*value = _vala_value;
	} else {
		((_vala_value == NULL) || (GEE_MAP_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_vala_value = (GEE_MAP_GET_INTERFACE (self)->get_v_destroy_func (self) (_vala_value), NULL));
	}
	return result;
}


/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
void gee_map_clear (GeeMap* self) {
	g_return_if_fail (self != NULL);
	GEE_MAP_GET_INTERFACE (self)->clear (self);
}


/**
 * Returns an iterator for this map.
 *
 * @return a map iterator
 */
GeeMapIterator* gee_map_map_iterator (GeeMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->map_iterator (self);
}


/**
 * Inserts all items that are contained in the input map to this map.
 *
 * @param map the map which items are inserted to this map
 */
static void gee_map_real_set_all (GeeMap* self, GeeMap* map) {
	g_return_if_fail (map != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = map;
		_tmp1_ = gee_map_get_entries (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			gconstpointer _tmp12_;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = entry;
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
			_tmp15_ = _tmp14_;
			gee_map_set (self, _tmp12_, _tmp15_);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


void gee_map_set_all (GeeMap* self, GeeMap* map) {
	g_return_if_fail (self != NULL);
	GEE_MAP_GET_INTERFACE (self)->set_all (self, map);
}


/**
 * Removes all items from this map that are common to the input map
 * and this map.
 *
 * @param map the map which common items are deleted from this map
 */
static gboolean gee_map_real_unset_all (GeeMap* self, GeeMap* map) {
	gboolean result = FALSE;
	gboolean changed = FALSE;
	g_return_val_if_fail (map != NULL, FALSE);
	changed = FALSE;
	{
		GeeIterator* _key_it = NULL;
		GeeMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = map;
		_tmp1_ = gee_map_get_keys (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_key_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			gpointer key = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_;
			gconstpointer _tmp11_;
			gboolean _tmp12_;
			_tmp6_ = _key_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _key_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			key = _tmp9_;
			_tmp10_ = changed;
			_tmp11_ = key;
			_tmp12_ = gee_map_unset (self, _tmp11_, NULL);
			changed = _tmp10_ | _tmp12_;
			((key == NULL) || (GEE_MAP_GET_INTERFACE (self)->get_k_destroy_func (self) == NULL)) ? NULL : (key = (GEE_MAP_GET_INTERFACE (self)->get_k_destroy_func (self) (key), NULL));
		}
		_g_object_unref0 (_key_it);
	}
	result = changed;
	return result;
}


gboolean gee_map_unset_all (GeeMap* self, GeeMap* map) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->unset_all (self, map);
}


/**
 * Removes all items from this map that are common to the input map
 * and this map.
 *
 * @param map the map which common items are deleted from this map
 */
gboolean gee_map_remove_all (GeeMap* self, GeeMap* map) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (map != NULL, FALSE);
	_tmp0_ = map;
	_tmp1_ = gee_map_unset_all (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns ``true`` it this map contains all items as the input map.
 *
 * @param map the map which items will be compared with this map
 */
static gboolean gee_map_real_has_all (GeeMap* self, GeeMap* map) {
	gboolean result = FALSE;
	g_return_val_if_fail (map != NULL, FALSE);
	{
		GeeIterator* _entry_it = NULL;
		GeeMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = map;
		_tmp1_ = gee_map_get_entries (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			gconstpointer _tmp12_;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			gboolean _tmp16_;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = entry;
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_map_has (self, _tmp12_, _tmp15_);
			if (!_tmp16_) {
				result = FALSE;
				_g_object_unref0 (entry);
				_g_object_unref0 (_entry_it);
				return result;
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	result = TRUE;
	return result;
}


gboolean gee_map_has_all (GeeMap* self, GeeMap* map) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->has_all (self, map);
}


/**
 * Returns ``true`` it this map contains all items as the input map.
 *
 * @param map the map which items will be compared with this map
 */
gboolean gee_map_contains_all (GeeMap* self, GeeMap* map) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (map != NULL, FALSE);
	_tmp0_ = map;
	_tmp1_ = gee_map_has_all (self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns an immutable empty map.
 *
 * @return an immutable empty map
 */
GeeMap* gee_map_empty (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	_tmp0_ = gee_hash_map_new (k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gint gee_map_get_size (GeeMap* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GEE_MAP_GET_INTERFACE (self)->get_size (self);
}


gboolean gee_map_get_is_empty (GeeMap* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->get_is_empty (self);
}


static gboolean gee_map_real_get_is_empty (GeeMap* base) {
	gboolean result;
	GeeMap* self;
	gint _tmp0_;
	gint _tmp1_;
	self = base;
	_tmp0_ = gee_map_get_size (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == 0;
	return result;
}


gboolean gee_map_get_read_only (GeeMap* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_GET_INTERFACE (self)->get_read_only (self);
}


GeeSet* gee_map_get_keys (GeeMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->get_keys (self);
}


GeeCollection* gee_map_get_values (GeeMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->get_values (self);
}


GeeSet* gee_map_get_entries (GeeMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->get_entries (self);
}


GeeMap* gee_map_get_read_only_view (GeeMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_GET_INTERFACE (self)->get_read_only_view (self);
}


GType gee_map_get_key_type (GeeMap* self) {
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = GEE_MAP_GET_INTERFACE (self)->get_k_type (self);
	return result;
}


GType gee_map_get_value_type (GeeMap* self) {
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = GEE_MAP_GET_INTERFACE (self)->get_v_type (self);
	return result;
}


GeeMapEntry* gee_map_entry_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	GeeMapEntry * self = NULL;
	self = (GeeMapEntry*) g_object_new (object_type, NULL);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	return self;
}


gconstpointer gee_map_entry_get_key (GeeMapEntry* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_ENTRY_GET_CLASS (self)->get_key (self);
}


gconstpointer gee_map_entry_get_value (GeeMapEntry* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MAP_ENTRY_GET_CLASS (self)->get_value (self);
}


void gee_map_entry_set_value (GeeMapEntry* self, gconstpointer value) {
	g_return_if_fail (self != NULL);
	GEE_MAP_ENTRY_GET_CLASS (self)->set_value (self, value);
}


gboolean gee_map_entry_get_read_only (GeeMapEntry* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MAP_ENTRY_GET_CLASS (self)->get_read_only (self);
}


static void gee_map_entry_class_init (GeeMapEntryClass * klass) {
	gee_map_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeMapEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_map_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_map_entry_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The key of this entry.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_KEY_PROPERTY, g_param_spec_pointer ("key", "key", "key", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The value of this entry.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_VALUE_PROPERTY, g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * ``true`` if the setting value is permitted.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_MAP_ENTRY_READ_ONLY_PROPERTY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_map_entry_instance_init (GeeMapEntry * self) {
	self->priv = GEE_MAP_ENTRY_GET_PRIVATE (self);
}


/**
 * An entry of a map.
 */
GType gee_map_entry_get_type (void) {
	static volatile gsize gee_map_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gee_map_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeMapEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_map_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeMapEntry), 0, (GInstanceInitFunc) gee_map_entry_instance_init, NULL };
		GType gee_map_entry_type_id;
		gee_map_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeMapEntry", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gee_map_entry_type_id__volatile, gee_map_entry_type_id);
	}
	return gee_map_entry_type_id__volatile;
}


static void _vala_gee_map_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeMapEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_map_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeMapEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	switch (property_id) {
		case GEE_MAP_ENTRY_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_MAP_ENTRY_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_MAP_ENTRY_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_MAP_ENTRY_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_MAP_ENTRY_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_MAP_ENTRY_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_map_base_init (GeeMapIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * The number of items in this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * Specifies whether this collection can change - i.e. wheather {@link set},
		 * {@link remove} etc. are legal operations.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * The read-only view of the keys of this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_object ("keys", "keys", "keys", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * The read-only view of the values of this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_object ("values", "values", "values", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * The read-only view of the entries of this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_object ("entries", "entries", "entries", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * The read-only view this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->set_all = gee_map_real_set_all;
		iface->unset_all = gee_map_real_unset_all;
		iface->has_all = gee_map_real_has_all;
		iface->get_is_empty = gee_map_real_get_is_empty;
	}
}


/**
 * An object that maps keys to values.
 */
GType gee_map_get_type (void) {
	static volatile gsize gee_map_type_id__volatile = 0;
	if (g_once_init_enter (&gee_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeMapIface), (GBaseInitFunc) gee_map_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_map_type_id;
		gee_map_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMap", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_map_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gee_map_type_id, GEE_TYPE_ITERABLE);
		g_once_init_leave (&gee_map_type_id__volatile, gee_map_type_id);
	}
	return gee_map_type_id__volatile;
}



