"""
    CSS syntax names.

    Copyright (c)
    See LICENSE for details.
    <jtm@robot.is>
"""
css2 = [
    'azimuth',
    'background-attachment',
    'background-color',
    'background-image',
    'background-position',
    'background-repeat',
    'background',
    'border-collapse',
    'border-color',
    'border-spacing',
    'border-style',
    'border-top',
    'border-right',
    'border-bottom',
    'border-left',
    'border-top-color',
    'border-right-color',
    'border-bottom-color',
    'border-left-color',
    'border-top-style',
    'border-right-style',
    'border-bottom-style',
    'border-left-style',
    'border-top-width',
    'border-right-width',
    'border-bottom-width',
    'border-left-width',
    'border-width',
    'border',
    'bottom',
    'caption-side',
    'clear',
    'clip',
    'color',
    'content',
    'counter-increment',
    'counter-reset',
    'cue-after',
    'cue-before',
    'cue',
    'cursor',
    'direction',
    'display',
    'elevation',
    'empty-cells',
    'float',
    'font-family',
    'font-size',
    'font-style',
    'font-variant',
    'font-weight',
    'font',
    'height',
    'left',
    'letter-spacing',
    'line-height',
    'list-style-image',
    'list-style-position',
    'list-style-type',
    'list-style',
    'margin-right',
    'margin-left',
    'margin-top',
    'margin-bottom',
    'margin',
    'max-height',
    'max-width',
    'min-height',
    'min-width',
    'orphans',
    'outline-color',
    'outline-style',
    'outline-width',
    'outline',
    'overflow',
    'padding-top',
    'padding-right',
    'padding-bottom',
    'padding-left',
    'padding',
    'page-break-after',
    'page-break-before',
    'page-break-inside',
    'pause-after',
    'pause-before',
    'pause',
    'pitch-range',
    'pitch',
    'play-during',
    'position',
    'quotes',
    'richness',
    'right',
    'speak-header',
    'speak-numeral',
    'speak-punctuation',
    'speak',
    'speech-rate',
    'stress',
    'table-layout',
    'text-align',
    'text-decoration',
    'text-indent',
    'text-transform',
    'top',
    'unicode-bidi',
    'vertical-align',
    'visibility',
    'voice-family',
    'volume',
    'white-space',
    'widows',
    'width',
    'word-spacing',
    'z-index',
]
css3 = [
    'alignment-adjust',
    'alignment-baseline',
    'animation',
    'animation-delay',
    'animation-direction',
    'animation-duration',
    'animation-iteration-count',
    'animation-name',
    'animation-play-state',
    'animation-timing-function',
    'appearance',
    'backface-visibility',
    'background-clip',
    'background-origin',
    'background-size',
    'baseline-shift',
    'bookmark-label',
    'bookmark-level',
    'bookmark-target',
    'border-bottom-left-radius',
    'border-bottom-right-radius',
    'border-image',
    'border-image-outset',
    'border-image-repeat',
    'border-image-slice',
    'border-image-source',
    'border-image-width',
    'border-radius',
    'border-top-left-radius',
    'border-top-right-radius',
    'box-align',
    'box-decoration-break',
    'box-direction',
    'box-flex',
    'box-flex-group',
    'box-lines',
    'box-ordinal-group',
    'box-orient',
    'box-pack',
    'box-shadow',
    'box-sizing',
    'color-profile',
    'column-count',
    'column-fill',
    'column-gap',
    'column-rule',
    'column-rule-color',
    'column-rule-style',
    'column-rule-width',
    'column-span',
    'column-width',
    'columns',
    'crop',
    'dominant-baseline',
    'drop-initial-after-adjust',
    'drop-initial-after-align',
    'drop-initial-before-adjust',
    'drop-initial-before-align',
    'drop-initial-size',
    'drop-initial-value',
    'fit',
    'fit-position',
    'float-offset',
    'font-size-adjust',
    'font-stretch',
    'grid-columns',
    'grid-rows',
    'hanging-punctuation',
    'hyphenate-after',
    'hyphenate-before',
    'hyphenate-character',
    'hyphenate-lines',
    'hyphenate-resource',
    'hyphens',
    'icon',
    'image-orientation',
    'image-resolution',
    'inline-box-align',
    'line-stacking',
    'line-stacking-ruby',
    'line-stacking-shift',
    'line-stacking-strategy',
    #    'mark',
    'mark-after',
    'mark-before',
    'marks',
    'marquee-direction',
    'marquee-play-count',
    'marquee-speed',
    'marquee-style',
    'move-to',
    'nav-down',
    'nav-index',
    'nav-left',
    'nav-right',
    'nav-up',
    'opacity',
    'outline-offset',
    'overflow-style',
    'overflow-x',
    'overflow-y',
    'page',
    'page-policy',
    'perspective',
    'perspective-origin',
    'phonemes',
    'punctuation-trim',
    'rendering-intent',
    'resize',
    'rest',
    'rest-after',
    'rest-before',
    'rotation',
    'rotation-point',
    'ruby-align',
    'ruby-overhang',
    'ruby-position',
    'ruby-span',
    'size',
    'string-set',
    'target',
    'target-name',
    'target-new',
    'target-position',
    'text-align-last',
    'text-height',
    'text-justify',
    'text-outline',
    'text-overflow',
    'text-shadow',
    'text-wrap',
    'transform',
    'transform-origin',
    'transform-style',
    'transition',
    'transition-delay',
    'transition-duration',
    'transition-property',
    'transition-timing-function',
    'voice-balance',
    'voice-duration',
    'voice-pitch',
    'voice-pitch-range',
    'voice-rate',
    'voice-stress',
    'voice-volume',
    'word-break',
    'word-wrap'
]
# SVG only includes style not present in either css2 or css3:
svg = [
    # clipping / masking / compositing:
    'clip-path',
    'clip-rule',
    'mask',
    # filter effects:
    'enable-background',
    'filter',
    'flood-color',
    'flood-opacity',
    'lightning-color',
    # gradient:
    'stop-color',
    'stop-opacity',
    # interactivity:
    'pointer-events',
    # color / painting:
    'color-interpolation',
    'color-interpolation-filters',
    'color-rendering',
    'fill',
    'fill-opacity',
    'fill-rule',
    'image-rendering',
    'marker',
    'marker-end',
    'marker-mid',
    'marker-start',
    'shape-rendering',
    'stroke',
    'stroke-dasharray',
    'stroke-dashoffset',
    'stroke-linecap',
    'stroke-linejoin',
    'stroke-miterlimit',
    'stroke-opacity',
    'stroke-width',
    'text-rendering',
    # text:
    'glyph-orientation-horizontal',
    'glyph-orientation-vertical',
    'kerning',
    'text-anchor',
    'writing-mode',
]
vendor_prefix = [
    '-ms-',
    '-moz-',
    '-o-',
    '-atsc-',
    '-wap-',
    '-webkit-',
    '-khtml-'
    '-xv-',
    'mso-',
]
vendor_ugly = [
    'accelerator',
    'behavior',
    'zoom',
]
propertys = css2 + css3 + svg + vendor_ugly

# CSS-2(.1) media types: http://www.w3.org/TR/CSS2/media.html#media-types
# Include media types as defined in HTML4: http://www.w3.org/TR/1999/REC-html401-19991224/types.html#h-6.13
# Also explained in http://www.w3.org/TR/css3-mediaqueries/#background
html4_media_types = [
    'all',
    'aural',  # deprecated by CSS 2.1, which reserves "speech"
    'braille',
    'handheld',
    'print',
    'projection',
    'screen',
    'tty',
    'tv',
]
css2_media_types = [
    'embossed',  # CSS2, not HTML4
    'speech',  # CSS2. not HTML4
]
media_types = html4_media_types + css2_media_types

css3_media_features = [
    'width',
    'min-width',
    'max-width',
    'height',
    'min-height',
    'max-height',
    'device-width',
    'min-device-width',
    'max-device-width',
    'device-height',
    'min-device-height',
    'max-device-height',
    'orientation',
    'aspect-ratio',
    'min-aspect-ratio',
    'max-aspect-ratio',
    'device-aspect-ratio',

    'min-device-aspect-ratio',
    'max-device-aspect-ratio',
    'color',
    'min-color',
    'max-color',
    'color-index',
    'min-color-index',
    'max-color-index',
    'monochrome',
    'min-monochrome',
    'max-monochrome',
    'resolution',
    'min-resolution',
    'max-resolution',
    'scan',
    'grid',
]
vendor_media_features = [
    '-webkit-min-device-pixel-ratio',
    'min--moz-device-pixel-ratio',
    '-o-min-device-pixel-ratio',
    'min-device-pixel-ratio',
]
media_features = css3_media_features + vendor_media_features
