// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Buildable;
use Widget;
use ffi;
use gdk;
use glib;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct Invisible(Object<ffi::GtkInvisible, ffi::GtkInvisibleClass>): Widget, Buildable;

    match fn {
        get_type => || ffi::gtk_invisible_get_type(),
    }
}

impl Invisible {
    pub fn new() -> Invisible {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_invisible_new()).downcast_unchecked()
        }
    }

    pub fn new_for_screen(screen: &gdk::Screen) -> Invisible {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_invisible_new_for_screen(screen.to_glib_none().0)).downcast_unchecked()
        }
    }
}

impl Default for Invisible {
    fn default() -> Self {
        Self::new()
    }
}

pub trait InvisibleExt {
    fn set_screen(&self, screen: &gdk::Screen);

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Invisible> + IsA<glib::object::Object>> InvisibleExt for O {
    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            ffi::gtk_invisible_set_screen(self.to_glib_none().0, screen.to_glib_none().0);
        }
    }

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::screen",
                transmute(notify_screen_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn notify_screen_trampoline<P>(this: *mut ffi::GtkInvisible, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Invisible> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Invisible::from_glib_borrow(this).downcast_unchecked())
}
