/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCDRAGOBJECT_H
#define _SC_SCDRAGOBJECT_H

// sc
#include "BaseModel.h"

// qt
#include <qdragobject.h>


class ScDragObject : public QStoredDrag
{
public:
  ScDragObject( const char* mimeType, BaseModel* model, QWidget* dragSource = 0, const char* name = 0 )
    : QStoredDrag(mimeType,dragSource,name), _model(model)
  {
    if( ! _model )
      return;

    _model->setDrag(true);
  }

  virtual ~ScDragObject()
  {
    if( ! _model )
      return;

    _model->setDrag(false);
  }

private:
  BaseModel* _model;
};


#endif // _SC_SCDRAGOBJECT_H
