/* This file is automatically generated by Lemon from input grammar
** source file "../../groonga/lib/grn_ecmascript.lemon". */
/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
/************ Begin %include sections from the grammar ************************/
#line 4 "../../groonga/lib/grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT

  static void
  array_literal_end(efs_info *efsi, int n_elements)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_expr *e = (grn_expr *)(efsi->e);
    grn_obj *array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
    if (!array_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][array-literal] couldn't create vector: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }
    grn_expr_take_obj(ctx, efsi->e, array_literal);

    int i;
    for (i = n_elements; i > 0; i--) {
      grn_expr_code *code = &(e->codes[e->codes_curr - i]);
      if (code->op != GRN_OP_PUSH) {
        ERR(GRN_FUNCTION_NOT_IMPLEMENTED,
            "[expr][array-literal] "
            "complex expression in array literal isn't supported yet: <%.*s>",
            (int)(efsi->str_end - efsi->str),
            efsi->str);
        return;
      }
      grn_obj *element = code->value;
      grn_vector_add_element_float(ctx,
                                   array_literal,
                                   GRN_TEXT_VALUE(element),
                                   GRN_TEXT_LEN(element),
                                   0,
                                   element->header.domain);
      if (ctx->rc != GRN_SUCCESS) {
        char message[GRN_CTX_MSGSIZE];
        grn_strncpy(message, sizeof(message), ctx->errbuf, sizeof(ctx->errbuf));
        ERR(ctx->rc,
            "[expr][array-literal] failed to add an element: %s",
            message);
        return;
      }
    }
    for (i = 0; i < n_elements; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 1;
    }

    grn_expr_append_obj(ctx, efsi->e, array_literal, GRN_OP_PUSH, 1);
  }

  static void
  object_literal_end(efs_info *efsi, int n_properties)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_hash *object_literal =
      grn_hash_create(ctx,
                      NULL,
                      GRN_TABLE_MAX_KEY_SIZE,
                      sizeof(grn_obj),
                      GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
    if (!object_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][object-literal] couldn't create hash table: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }

    grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(object_literal));
    DB_OBJ(object_literal)->header.domain = GRN_DB_SHORT_TEXT;

    grn_expr *e = (grn_expr *)(efsi->e);
    int i;
    for (i = n_properties; i > 0; i--) {
      int base = e->codes_curr - (i * 3);
      grn_obj *name = e->codes[base].value;
      grn_obj *value = e->codes[base + 2].value;

      grn_obj *buf;
      int added;
      grn_id id = grn_hash_add(ctx,
                               object_literal,
                               GRN_TEXT_VALUE(name),
                               GRN_TEXT_LEN(name),
                               (void **)(&buf),
                               &added);
      if (id == GRN_ID_NIL) {
        grn_rc rc = ctx->rc;
        if (rc == GRN_SUCCESS) {
          rc = GRN_NO_MEMORY_AVAILABLE;
        }
        ERR(rc,
            "[expr][object-literal] failed to add a property: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      if (!added) {
        ERR(GRN_INVALID_ARGUMENT,
            "[expr][object-literal] duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      switch (value->header.type) {
      case GRN_TABLE_HASH_KEY :
      case GRN_COLUMN_FIX_SIZE :
      case GRN_COLUMN_VAR_SIZE :
      case GRN_COLUMN_INDEX :
        GRN_OBJ_INIT(buf, GRN_PTR, 0, GRN_ID_NIL);
        GRN_PTR_SET(ctx, buf, value);
        break;
      case GRN_VECTOR :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        grn_vector_copy(ctx, value, buf);
        break;
      default :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        break;
      }
    }
    for (i = 0; i < n_properties; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 3;
    }
    grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(object_literal),
                        GRN_OP_PUSH, 1);
  }
#line 167 "../../groonga/lib/grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS
#define GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS            1
#define GRN_EXPR_TOKEN_START_ADJUSTER                  2
#define GRN_EXPR_TOKEN_START_SORT_KEYS                 3
#define GRN_EXPR_TOKEN_START_OPTIONS                   4
#define GRN_EXPR_TOKEN_LOGICAL_AND                     5
#define GRN_EXPR_TOKEN_LOGICAL_AND_NOT                 6
#define GRN_EXPR_TOKEN_LOGICAL_OR                      7
#define GRN_EXPR_TOKEN_NEGATIVE                        8
#define GRN_EXPR_TOKEN_QSTRING                         9
#define GRN_EXPR_TOKEN_PARENL                         10
#define GRN_EXPR_TOKEN_PARENR                         11
#define GRN_EXPR_TOKEN_ADJUST                         12
#define GRN_EXPR_TOKEN_RELATIVE_OP                    13
#define GRN_EXPR_TOKEN_IDENTIFIER                     14
#define GRN_EXPR_TOKEN_BRACEL                         15
#define GRN_EXPR_TOKEN_BRACER                         16
#define GRN_EXPR_TOKEN_EVAL                           17
#define GRN_EXPR_TOKEN_COMMA                          18
#define GRN_EXPR_TOKEN_ASSIGN                         19
#define GRN_EXPR_TOKEN_STAR_ASSIGN                    20
#define GRN_EXPR_TOKEN_SLASH_ASSIGN                   21
#define GRN_EXPR_TOKEN_MOD_ASSIGN                     22
#define GRN_EXPR_TOKEN_PLUS_ASSIGN                    23
#define GRN_EXPR_TOKEN_MINUS_ASSIGN                   24
#define GRN_EXPR_TOKEN_SHIFTL_ASSIGN                  25
#define GRN_EXPR_TOKEN_SHIFTR_ASSIGN                  26
#define GRN_EXPR_TOKEN_SHIFTRR_ASSIGN                 27
#define GRN_EXPR_TOKEN_AND_ASSIGN                     28
#define GRN_EXPR_TOKEN_XOR_ASSIGN                     29
#define GRN_EXPR_TOKEN_OR_ASSIGN                      30
#define GRN_EXPR_TOKEN_QUESTION                       31
#define GRN_EXPR_TOKEN_COLON                          32
#define GRN_EXPR_TOKEN_BITWISE_OR                     33
#define GRN_EXPR_TOKEN_BITWISE_XOR                    34
#define GRN_EXPR_TOKEN_BITWISE_AND                    35
#define GRN_EXPR_TOKEN_EQUAL                          36
#define GRN_EXPR_TOKEN_NOT_EQUAL                      37
#define GRN_EXPR_TOKEN_LESS                           38
#define GRN_EXPR_TOKEN_GREATER                        39
#define GRN_EXPR_TOKEN_LESS_EQUAL                     40
#define GRN_EXPR_TOKEN_GREATER_EQUAL                  41
#define GRN_EXPR_TOKEN_IN                             42
#define GRN_EXPR_TOKEN_MATCH                          43
#define GRN_EXPR_TOKEN_NEAR                           44
#define GRN_EXPR_TOKEN_NEAR_NO_OFFSET                 45
#define GRN_EXPR_TOKEN_NEAR_PHRASE                    46
#define GRN_EXPR_TOKEN_ORDERED_NEAR_PHRASE            47
#define GRN_EXPR_TOKEN_NEAR_PHRASE_PRODUCT            48
#define GRN_EXPR_TOKEN_ORDERED_NEAR_PHRASE_PRODUCT    49
#define GRN_EXPR_TOKEN_SIMILAR                        50
#define GRN_EXPR_TOKEN_TERM_EXTRACT                   51
#define GRN_EXPR_TOKEN_QUORUM                         52
#define GRN_EXPR_TOKEN_LCP                            53
#define GRN_EXPR_TOKEN_PREFIX                         54
#define GRN_EXPR_TOKEN_SUFFIX                         55
#define GRN_EXPR_TOKEN_REGEXP                         56
#define GRN_EXPR_TOKEN_SHIFTL                         57
#define GRN_EXPR_TOKEN_SHIFTR                         58
#define GRN_EXPR_TOKEN_SHIFTRR                        59
#define GRN_EXPR_TOKEN_PLUS                           60
#define GRN_EXPR_TOKEN_MINUS                          61
#define GRN_EXPR_TOKEN_STAR                           62
#define GRN_EXPR_TOKEN_SLASH                          63
#define GRN_EXPR_TOKEN_MOD                            64
#define GRN_EXPR_TOKEN_DELETE                         65
#define GRN_EXPR_TOKEN_INCR                           66
#define GRN_EXPR_TOKEN_DECR                           67
#define GRN_EXPR_TOKEN_NOT                            68
#define GRN_EXPR_TOKEN_BITWISE_NOT                    69
#define GRN_EXPR_TOKEN_EXACT                          70
#define GRN_EXPR_TOKEN_PARTIAL                        71
#define GRN_EXPR_TOKEN_UNSPLIT                        72
#define GRN_EXPR_TOKEN_DECIMAL                        73
#define GRN_EXPR_TOKEN_HEX_INTEGER                    74
#define GRN_EXPR_TOKEN_STRING                         75
#define GRN_EXPR_TOKEN_BOOLEAN                        76
#define GRN_EXPR_TOKEN_NULL                           77
#define GRN_EXPR_TOKEN_BRACKETL                       78
#define GRN_EXPR_TOKEN_BRACKETR                       79
#define GRN_EXPR_TOKEN_DOT                            80
#define GRN_EXPR_TOKEN_NONEXISTENT_COLUMN             81
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 121
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy45;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             164
#define YYNRULE              147
#define YYNRULE_WITH_ACTION  104
#define YYNTOKEN             82
#define YY_MAX_SHIFT         163
#define YY_MIN_SHIFTREDUCE   251
#define YY_MAX_SHIFTREDUCE   397
#define YY_ERROR_ACTION      398
#define YY_ACCEPT_ACTION     399
#define YY_NO_ACTION         400
#define YY_MIN_REDUCE        401
#define YY_MAX_REDUCE        547
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1994)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   401,    3,   81,    4,   96,  131,  482,  155,  405,  362,
 /*    10 */     2,  404,   62,   92,  145,    1,   87,   80,  399,   88,
 /*    20 */   129,  330,   87,   86,   84,   88,   84,  129,  129,  100,
 /*    30 */   142,  102,  158,  157,  156,  137,   97,  119,  133,  120,
 /*    40 */   120,  120,  100,   84,  496,  150,   84,   95,   94,   90,
 /*    50 */    89,  362,   83,  363,   93,   92,  163,   11,  148,   80,
 /*    60 */    75,   74,  410,   82,  410,   78,   77,   76,   73,   72,
 /*    70 */    70,   69,   68,  387,  388,  389,  390,  391,    8,  143,
 /*    80 */    79,   67,   66,   84,  410,   84,  143,  143,  100,  142,
 /*    90 */   102,  158,  157,  156,  137,   97,  119,  133,  120,  120,
 /*   100 */   120,  100,   84,  483,  155,   84,  393,  131,  482,  155,
 /*   110 */   362,    2,  408,   62,   92,  145,    1,  407,   80,   87,
 /*   120 */   135,    7,  475,  532,   84,   87,   84,  135,  135,  100,
 /*   130 */   142,  102,  158,  157,  156,  137,   97,  119,  133,  120,
 /*   140 */   120,  120,  100,   84,  406,    9,   84,   71,  403,  385,
 /*   150 */    82,  362,   83,  127,   93,   92,  163,   11,  508,   80,
 /*   160 */   402,   75,   74,   61,   60,   59,   78,   77,   76,   73,
 /*   170 */    72,   70,   69,   68,  387,  388,  389,  390,  391,    8,
 /*   180 */    34,   33,  146,   31,  127,  150,   25,   32,  259,   10,
 /*   190 */    29,  154,  335,   64,   63,   75,   74,  343,  543,   23,
 /*   200 */    78,   77,   76,   73,   72,   70,   69,   68,  387,  388,
 /*   210 */   389,  390,  391,    8,  128,   29,  344,   84,   85,   84,
 /*   220 */   495,  495,  100,  142,  102,  158,  157,  156,  137,   97,
 /*   230 */   119,  133,  120,  120,  120,  100,   84,  384,    9,   84,
 /*   240 */    71,  510,  385,   82,   29,  490,   91,  326,   39,   38,
 /*   250 */   126,   84,  348,   84,  504,  504,  100,  142,  102,  158,
 /*   260 */   157,  156,  137,   97,  119,  133,  120,  120,  120,  100,
 /*   270 */    84,  323,  324,   84,  509,  147,  334,  347,  149,   35,
 /*   280 */   394,   24,  500,   37,   36,   26,  400,  400,   75,   65,
 /*   290 */   507,  400,    6,   78,   77,   76,   73,   72,   70,   69,
 /*   300 */    68,  387,  388,  389,  390,  391,    8,   30,    5,  352,
 /*   310 */    84,  400,   84,  495,  495,  100,  142,  102,  158,  157,
 /*   320 */   156,  137,   97,  119,  133,  120,  120,  120,  100,   84,
 /*   330 */   400,   27,   84,  400,  400,  400,  400,  400,  492,  400,
 /*   340 */    84,  400,   84,  504,  504,  100,  142,  102,  158,  157,
 /*   350 */   156,  137,   97,  119,  133,  120,  120,  120,  100,   84,
 /*   360 */   400,  400,   84,  400,  400,  400,  400,  400,  400,  400,
 /*   370 */   400,  501,   84,  400,   84,  487,  487,  100,  142,  102,
 /*   380 */   158,  157,  156,  137,   97,  119,  133,  120,  120,  120,
 /*   390 */   100,   84,  400,  400,   84,  400,  400,  400,  400,  130,
 /*   400 */    84,  400,   84,  478,  478,  100,  142,  102,  158,  157,
 /*   410 */   156,  137,   97,  119,  133,  120,  120,  120,  100,   84,
 /*   420 */   400,  400,   84,  132,  135,  400,  400,  400,   84,  400,
 /*   430 */    84,  135,  135,  100,  142,  102,  158,  157,  156,  137,
 /*   440 */    97,  119,  133,  120,  120,  120,  100,   84,  138,  400,
 /*   450 */    84,  400,   84,  400,   84,  138,  138,  100,  142,  102,
 /*   460 */   158,  157,  156,  137,   97,  119,  133,  120,  120,  120,
 /*   470 */   100,   84,  143,  400,   84,  400,   84,  400,   84,  143,
 /*   480 */   143,  100,  142,  102,  158,  157,  156,  137,   97,  119,
 /*   490 */   133,  120,  120,  120,  100,   84,  400,    9,   84,   71,
 /*   500 */   400,  385,   82,   84,  400,   84,  423,  423,  100,  142,
 /*   510 */   102,  158,  157,  156,  137,   97,  119,  133,  120,  120,
 /*   520 */   120,  100,   84,  400,   84,   84,   84,  422,  422,  100,
 /*   530 */   142,  102,  158,  157,  156,  137,   97,  119,  133,  120,
 /*   540 */   120,  120,  100,   84,  400,  400,   84,   75,   74,  400,
 /*   550 */   400,  400,   78,   77,   76,   73,   72,   70,   69,   68,
 /*   560 */   387,  388,  389,  390,  391,    8,  400,    9,  353,   71,
 /*   570 */   400,  385,   82,   84,  400,   84,  421,  421,  100,  142,
 /*   580 */   102,  158,  157,  156,  137,   97,  119,  133,  120,  120,
 /*   590 */   120,  100,   84,  400,  400,   84,  400,   84,  400,   84,
 /*   600 */   420,  420,  100,  142,  102,  158,  157,  156,  137,   97,
 /*   610 */   119,  133,  120,  120,  120,  100,   84,   75,   74,   84,
 /*   620 */   400,  400,   78,   77,   76,   73,   72,   70,   69,   68,
 /*   630 */   387,  388,  144,  390,  391,    8,    9,  400,   71,  400,
 /*   640 */   385,   82,   84,  400,   84,  419,  419,  100,  142,  102,
 /*   650 */   158,  157,  156,  137,   97,  119,  133,  120,  120,  120,
 /*   660 */   100,   84,  400,   84,   84,   84,  418,  418,  100,  142,
 /*   670 */   102,  158,  157,  156,  137,   97,  119,  133,  120,  120,
 /*   680 */   120,  100,   84,  400,  400,   84,   75,   74,  506,  400,
 /*   690 */   400,   78,   77,   76,   73,   72,   70,   69,   68,  387,
 /*   700 */   388,  389,  390,  391,    8,   84,   29,   84,  417,  417,
 /*   710 */   100,  142,  102,  158,  157,  156,  137,   97,  119,  133,
 /*   720 */   120,  120,  120,  100,   84,  400,   84,   84,   84,  416,
 /*   730 */   416,  100,  142,  102,  158,  157,  156,  137,   97,  119,
 /*   740 */   133,  120,  120,  120,  100,   84,  400,   84,   84,   84,
 /*   750 */   415,  415,  100,  142,  102,  158,  157,  156,  137,   97,
 /*   760 */   119,  133,  120,  120,  120,  100,   84,  400,   84,   84,
 /*   770 */    84,  414,  414,  100,  142,  102,  158,  157,  156,  137,
 /*   780 */    97,  119,  133,  120,  120,  120,  100,   84,  400,   84,
 /*   790 */    84,   84,  413,  413,  100,  142,  102,  158,  157,  156,
 /*   800 */   137,   97,  119,  133,  120,  120,  120,  100,   84,  400,
 /*   810 */    84,   84,   84,  488,  488,  100,  142,  102,  158,  157,
 /*   820 */   156,  137,   97,  119,  133,  120,  120,  120,  100,   84,
 /*   830 */   400,   84,   84,   84,  542,  542,  100,  142,  102,  158,
 /*   840 */   157,  156,  137,   97,  119,  133,  120,  120,  120,  100,
 /*   850 */    84,  400,   84,   84,   84,  479,  479,  100,  142,  102,
 /*   860 */   158,  157,  156,  137,   97,  119,  133,  120,  120,  120,
 /*   870 */   100,   84,  400,   84,   84,   84,  424,  424,  100,  142,
 /*   880 */   102,  158,  157,  156,  137,   97,  119,  133,  120,  120,
 /*   890 */   120,  100,   84,  400,   84,   84,   84,  162,  162,  100,
 /*   900 */   142,  102,  158,  157,  156,  137,   97,  119,  133,  120,
 /*   910 */   120,  120,  100,   84,  400,   84,   84,   84,  412,  412,
 /*   920 */   100,  142,  102,  158,  157,  156,  137,   97,  119,  133,
 /*   930 */   120,  120,  120,  100,   84,  400,   84,   84,   84,  411,
 /*   940 */   411,  100,  142,  102,  158,  157,  156,  137,   97,  119,
 /*   950 */   133,  120,  120,  120,  100,   84,  400,  400,   84,   58,
 /*   960 */    57,   56,   55,   54,   53,   52,   51,   50,   49,   48,
 /*   970 */    47,   46,   45,   44,   43,   42,   41,   40,   84,  400,
 /*   980 */    84,  400,  400,  139,  400,  101,  158,  157,  156,  137,
 /*   990 */    97,  119,  133,  120,  120,  120,  139,   84,  400,   84,
 /*  1000 */    84,   84,  400,  400,  139,  400,  400,  151,  157,  156,
 /*  1010 */   137,   97,  119,  133,  120,  120,  120,  139,   84,  400,
 /*  1020 */    84,   84,   84,  400,  400,  139,  400,  400,  152,  157,
 /*  1030 */   156,  137,   97,  119,  133,  120,  120,  120,  139,   84,
 /*  1040 */   400,   84,   84,   84,  400,  400,  139,  400,  400,  153,
 /*  1050 */   157,  156,  137,   97,  119,  133,  120,  120,  120,  139,
 /*  1060 */    84,  400,   84,   84,   84,  400,  400,  139,  400,  400,
 /*  1070 */   161,  157,  156,  137,   97,  119,  133,  120,  120,  120,
 /*  1080 */   139,   84,  400,   84,   84,   84,  400,  400,  139,  400,
 /*  1090 */   400,  400,  160,  156,  137,   97,  119,  133,  120,  120,
 /*  1100 */   120,  139,   84,  400,   84,   84,   84,  400,  400,  139,
 /*  1110 */   400,  400,  400,  400,  159,  137,   97,  119,  133,  120,
 /*  1120 */   120,  120,  139,   84,  400,  400,   84,  400,  400,   28,
 /*  1130 */    22,   21,   20,   19,   18,   17,   16,   15,   14,   13,
 /*  1140 */    12,   84,  400,   84,  400,  400,  139,  400,  400,  400,
 /*  1150 */   400,  400,  141,   97,  119,  133,  120,  120,  120,  139,
 /*  1160 */    84,  400,  400,   84,  400,  400,   84,  400,   84,  400,
 /*  1170 */   400,  139,  400,  400,  400,  400,  323,  324,   98,  119,
 /*  1180 */   133,  120,  120,  120,  139,   84,  400,   84,   84,   84,
 /*  1190 */   400,  400,  139,  400,  400,  400,  400,  400,  400,   99,
 /*  1200 */   119,  133,  120,  120,  120,  139,   84,  505,  400,   84,
 /*  1210 */   400,  400,   95,   94,   90,   89,  362,   83,  400,   93,
 /*  1220 */    92,  163,   11,   84,   80,   84,  400,  400,  139,  400,
 /*  1230 */   400,  400,  400,  400,  400,  400,  103,  133,  120,  120,
 /*  1240 */   120,  139,   84,  400,   84,   84,   84,  400,  400,  139,
 /*  1250 */   400,  400,  400,  400,  400,  400,  400,  104,  133,  120,
 /*  1260 */   120,  120,  139,   84,  400,  400,   84,   84,  400,   84,
 /*  1270 */   400,  400,  139,  400,  400,  400,  400,  400,  400,  400,
 /*  1280 */   105,  133,  120,  120,  120,  139,   84,  400,  400,   84,
 /*  1290 */    84,  400,   84,  400,  400,  139,    9,  400,  400,  400,
 /*  1300 */   385,   82,  400,  106,  133,  120,  120,  120,  139,   84,
 /*  1310 */   400,   84,   84,   84,  400,  400,  139,  400,  400,  400,
 /*  1320 */   400,  400,  400,  400,  107,  133,  120,  120,  120,  139,
 /*  1330 */    84,  400,   84,   84,   84,  400,  400,  139,  400,  400,
 /*  1340 */   400,  400,  400,  400,  400,  108,  133,  120,  120,  120,
 /*  1350 */   139,   84,  400,   84,   84,   84,  400,  400,  139,  387,
 /*  1360 */   388,  389,  390,  391,    8,  400,  109,  133,  120,  120,
 /*  1370 */   120,  139,   84,  400,   84,   84,   84,  400,  400,  139,
 /*  1380 */   400,  400,  400,  400,  400,  400,  400,  110,  133,  120,
 /*  1390 */   120,  120,  139,   84,  400,   84,   84,   84,  400,  400,
 /*  1400 */   139,  400,  400,  400,  400,  400,  400,  400,  111,  133,
 /*  1410 */   120,  120,  120,  139,   84,  400,   84,   84,   84,  400,
 /*  1420 */   400,  139,  400,  400,  400,  400,  400,  400,  400,  112,
 /*  1430 */   133,  120,  120,  120,  139,   84,  400,   84,   84,   84,
 /*  1440 */   400,  400,  139,  400,  400,  400,  400,  400,  400,  400,
 /*  1450 */   113,  133,  120,  120,  120,  139,   84,  400,   84,   84,
 /*  1460 */    84,  400,  400,  139,  400,  400,  400,  400,  400,  400,
 /*  1470 */   400,  114,  133,  120,  120,  120,  139,   84,  400,   84,
 /*  1480 */    84,   84,  400,  400,  139,  400,  400,  400,  400,  400,
 /*  1490 */   400,  400,  115,  133,  120,  120,  120,  139,   84,  400,
 /*  1500 */    84,   84,   84,  400,  400,  139,  400,  400,  400,  400,
 /*  1510 */   400,  400,  400,  116,  133,  120,  120,  120,  139,   84,
 /*  1520 */   400,   84,   84,   84,  400,  400,  139,  400,  400,  400,
 /*  1530 */   400,  400,  400,  400,  117,  133,  120,  120,  120,  139,
 /*  1540 */    84,  400,   84,   84,   84,  400,  400,  139,  400,  400,
 /*  1550 */   400,  400,  400,  400,  400,  118,  133,  120,  120,  120,
 /*  1560 */   139,   84,  400,   84,   84,   84,  400,  400,  139,  400,
 /*  1570 */   400,  400,  400,  400,  400,  400,  121,  133,  120,  120,
 /*  1580 */   120,  139,   84,  400,   84,   84,   84,  400,  400,  139,
 /*  1590 */   400,  400,  400,  400,  400,  400,  400,  123,  133,  120,
 /*  1600 */   120,  120,  139,   84,  400,   84,   84,   84,  400,  400,
 /*  1610 */   139,  400,  400,  400,  400,  400,  400,  400,  125,  133,
 /*  1620 */   120,  120,  120,  139,   84,  400,   84,   84,   84,  400,
 /*  1630 */   400,  139,  400,  400,  400,  400,  400,  400,  400,  400,
 /*  1640 */   134,  120,  120,  120,  139,   84,  400,   84,   84,   84,
 /*  1650 */   400,  400,  139,  400,  400,  400,  400,  400,  400,  400,
 /*  1660 */   400,  136,  120,  120,  120,  139,   84,  400,   84,   84,
 /*  1670 */    84,  400,  400,  139,  400,   84,  406,   84,  400,  400,
 /*  1680 */   139,  400,  140,  120,  120,  120,  139,   84,  400,  400,
 /*  1690 */    84,  469,  469,  139,   84,  400,   84,   84,   84,  400,
 /*  1700 */   400,  139,  400,  400,  400,  400,  400,  400,  400,  400,
 /*  1710 */   400,  122,  122,  122,  139,   84,  400,   84,   84,   84,
 /*  1720 */   400,  400,  139,  400,  400,  400,  400,  400,  400,  400,
 /*  1730 */   400,  400,  124,  124,  124,  139,   84,  400,   84,   84,
 /*  1740 */    84,  400,  400,  139,  400,  400,  400,  400,  400,  400,
 /*  1750 */   400,  400,  400,  400,  466,  466,  139,   84,  400,   84,
 /*  1760 */    84,   84,  400,  400,  139,  400,   84,  400,   84,  400,
 /*  1770 */   400,  139,  400,  400,  400,  461,  461,  139,   84,  400,
 /*  1780 */   400,   84,  460,  460,  139,   84,  400,   84,   84,   84,
 /*  1790 */   400,  400,  139,  400,  400,  400,  400,  400,  400,  400,
 /*  1800 */   400,  400,  400,  472,  472,  139,   84,  400,   84,   84,
 /*  1810 */    84,  400,  400,  139,  400,  400,  400,  400,  400,  400,
 /*  1820 */   400,  400,  400,  400,  471,  471,  139,   84,  400,   84,
 /*  1830 */    84,   84,  400,  400,  139,  400,  400,  400,  400,  400,
 /*  1840 */   400,  400,  400,  400,  400,  470,  470,  139,   84,  400,
 /*  1850 */    84,   84,   84,  400,  400,  139,  400,  400,   84,  400,
 /*  1860 */    84,  400,  400,  139,  400,  400,  469,  469,  139,   84,
 /*  1870 */   400,  400,   84,  400,  468,  468,  139,   84,  400,   84,
 /*  1880 */    84,   84,  400,  400,  139,  400,  400,  400,  400,  400,
 /*  1890 */   400,  400,  400,  400,  400,  467,  467,  139,   84,  400,
 /*  1900 */    84,   84,   84,  400,  400,  139,  400,  400,  400,  400,
 /*  1910 */   400,  400,  400,  400,  400,  400,  465,  465,  139,   84,
 /*  1920 */   400,   84,   84,   84,  400,  400,  139,  400,  400,  400,
 /*  1930 */   400,  400,  400,  400,  400,  400,  400,  464,  464,  139,
 /*  1940 */    84,  400,   84,   84,   84,  400,  400,  139,  400,  400,
 /*  1950 */    84,  400,   84,  400,  400,  139,  400,  400,  463,  463,
 /*  1960 */   139,   84,  400,  400,   84,  400,  462,  462,  139,   84,
 /*  1970 */   400,   84,   84,   84,  400,  400,  139,  400,  400,  400,
 /*  1980 */   400,  400,  400,  400,  400,  400,  400,  459,  459,  139,
 /*  1990 */    84,  400,  400,   84,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    90,    1,    2,    3,    4,  113,  114,  115,   90,    9,
 /*    10 */    10,   90,   12,   13,   14,   15,   84,   17,   83,   84,
 /*    20 */    85,   16,   90,   18,   89,   90,   91,   92,   93,   94,
 /*    30 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*    40 */   105,  106,  107,  108,  118,  119,  111,    5,    6,    7,
 /*    50 */     8,    9,   10,   11,   12,   13,   14,   15,   14,   17,
 /*    60 */    60,   61,   89,   15,   91,   65,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   85,
 /*    80 */    62,   63,   64,   89,  111,   91,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   100 */   106,  107,  108,  114,  115,  111,   75,  113,  114,  115,
 /*   110 */     9,   10,   90,   12,   13,   14,   15,   90,   17,   84,
 /*   120 */    85,   10,  109,  110,   89,   90,   91,   92,   93,   94,
 /*   130 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   140 */   105,  106,  107,  108,   90,   10,  111,   12,   90,   14,
 /*   150 */    15,    9,   10,   87,   12,   13,   14,   15,    0,   17,
 /*   160 */    90,   60,   61,   57,   58,   59,   65,   66,   67,   68,
 /*   170 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   180 */     5,    6,   89,    8,  118,  119,   18,   12,   16,   78,
 /*   190 */    18,   80,   11,   60,   61,   60,   61,   62,   32,   18,
 /*   200 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   210 */    75,   76,   77,   78,   86,   18,   81,   89,   60,   91,
 /*   220 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   230 */   102,  103,  104,  105,  106,  107,  108,   11,   10,  111,
 /*   240 */    12,    0,   14,   15,   18,  117,   13,   79,   36,   37,
 /*   250 */    88,   89,   75,   91,   92,   93,   94,   95,   96,   97,
 /*   260 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   270 */   108,   66,   67,  111,    0,   43,   79,   73,   62,   33,
 /*   280 */    14,   32,  120,   35,   34,   32,  121,  121,   60,   61,
 /*   290 */     0,  121,   18,   65,   66,   67,   68,   69,   70,   71,
 /*   300 */    72,   73,   74,   75,   76,   77,   78,    7,   18,   81,
 /*   310 */    89,  121,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   320 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   330 */   121,   31,  111,  121,  121,  121,  121,  121,  117,  121,
 /*   340 */    89,  121,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   350 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   360 */   121,  121,  111,  121,  121,  121,  121,  121,  121,  121,
 /*   370 */   121,  120,   89,  121,   91,   92,   93,   94,   95,   96,
 /*   380 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   390 */   107,  108,  121,  121,  111,  121,  121,  121,  121,  116,
 /*   400 */    89,  121,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   410 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   420 */   121,  121,  111,  112,   85,  121,  121,  121,   89,  121,
 /*   430 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   440 */   101,  102,  103,  104,  105,  106,  107,  108,   85,  121,
 /*   450 */   111,  121,   89,  121,   91,   92,   93,   94,   95,   96,
 /*   460 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   470 */   107,  108,   85,  121,  111,  121,   89,  121,   91,   92,
 /*   480 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   490 */   103,  104,  105,  106,  107,  108,  121,   10,  111,   12,
 /*   500 */   121,   14,   15,   89,  121,   91,   92,   93,   94,   95,
 /*   510 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   520 */   106,  107,  108,  121,   89,  111,   91,   92,   93,   94,
 /*   530 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   540 */   105,  106,  107,  108,  121,  121,  111,   60,   61,  121,
 /*   550 */   121,  121,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   560 */    73,   74,   75,   76,   77,   78,  121,   10,   81,   12,
 /*   570 */   121,   14,   15,   89,  121,   91,   92,   93,   94,   95,
 /*   580 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   590 */   106,  107,  108,  121,  121,  111,  121,   89,  121,   91,
 /*   600 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   610 */   102,  103,  104,  105,  106,  107,  108,   60,   61,  111,
 /*   620 */   121,  121,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   630 */    73,   74,   75,   76,   77,   78,   10,  121,   12,  121,
 /*   640 */    14,   15,   89,  121,   91,   92,   93,   94,   95,   96,
 /*   650 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   660 */   107,  108,  121,   89,  111,   91,   92,   93,   94,   95,
 /*   670 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   680 */   106,  107,  108,  121,  121,  111,   60,   61,    0,  121,
 /*   690 */   121,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   700 */    74,   75,   76,   77,   78,   89,   18,   91,   92,   93,
 /*   710 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   720 */   104,  105,  106,  107,  108,  121,   89,  111,   91,   92,
 /*   730 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   740 */   103,  104,  105,  106,  107,  108,  121,   89,  111,   91,
 /*   750 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   760 */   102,  103,  104,  105,  106,  107,  108,  121,   89,  111,
 /*   770 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   780 */   101,  102,  103,  104,  105,  106,  107,  108,  121,   89,
 /*   790 */   111,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   800 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  121,
 /*   810 */    89,  111,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   820 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   830 */   121,   89,  111,   91,   92,   93,   94,   95,   96,   97,
 /*   840 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   850 */   108,  121,   89,  111,   91,   92,   93,   94,   95,   96,
 /*   860 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   870 */   107,  108,  121,   89,  111,   91,   92,   93,   94,   95,
 /*   880 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   890 */   106,  107,  108,  121,   89,  111,   91,   92,   93,   94,
 /*   900 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   910 */   105,  106,  107,  108,  121,   89,  111,   91,   92,   93,
 /*   920 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   930 */   104,  105,  106,  107,  108,  121,   89,  111,   91,   92,
 /*   940 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   950 */   103,  104,  105,  106,  107,  108,  121,  121,  111,   38,
 /*   960 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   970 */    49,   50,   51,   52,   53,   54,   55,   56,   89,  121,
 /*   980 */    91,  121,  121,   94,  121,   96,   97,   98,   99,  100,
 /*   990 */   101,  102,  103,  104,  105,  106,  107,  108,  121,   89,
 /*  1000 */   111,   91,  121,  121,   94,  121,  121,   97,   98,   99,
 /*  1010 */   100,  101,  102,  103,  104,  105,  106,  107,  108,  121,
 /*  1020 */    89,  111,   91,  121,  121,   94,  121,  121,   97,   98,
 /*  1030 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1040 */   121,   89,  111,   91,  121,  121,   94,  121,  121,   97,
 /*  1050 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*  1060 */   108,  121,   89,  111,   91,  121,  121,   94,  121,  121,
 /*  1070 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1080 */   107,  108,  121,   89,  111,   91,  121,  121,   94,  121,
 /*  1090 */   121,  121,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1100 */   106,  107,  108,  121,   89,  111,   91,  121,  121,   94,
 /*  1110 */   121,  121,  121,  121,   99,  100,  101,  102,  103,  104,
 /*  1120 */   105,  106,  107,  108,  121,  121,  111,  121,  121,   19,
 /*  1130 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
 /*  1140 */    30,   89,  121,   91,  121,  121,   94,  121,  121,  121,
 /*  1150 */   121,  121,  100,  101,  102,  103,  104,  105,  106,  107,
 /*  1160 */   108,  121,  121,  111,  121,  121,   89,  121,   91,  121,
 /*  1170 */   121,   94,  121,  121,  121,  121,   66,   67,  101,  102,
 /*  1180 */   103,  104,  105,  106,  107,  108,  121,   89,  111,   91,
 /*  1190 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  101,
 /*  1200 */   102,  103,  104,  105,  106,  107,  108,    0,  121,  111,
 /*  1210 */   121,  121,    5,    6,    7,    8,    9,   10,  121,   12,
 /*  1220 */    13,   14,   15,   89,   17,   91,  121,  121,   94,  121,
 /*  1230 */   121,  121,  121,  121,  121,  121,  102,  103,  104,  105,
 /*  1240 */   106,  107,  108,  121,   89,  111,   91,  121,  121,   94,
 /*  1250 */   121,  121,  121,  121,  121,  121,  121,  102,  103,  104,
 /*  1260 */   105,  106,  107,  108,  121,  121,  111,   89,  121,   91,
 /*  1270 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  121,
 /*  1280 */   102,  103,  104,  105,  106,  107,  108,  121,  121,  111,
 /*  1290 */    89,  121,   91,  121,  121,   94,   10,  121,  121,  121,
 /*  1300 */    14,   15,  121,  102,  103,  104,  105,  106,  107,  108,
 /*  1310 */   121,   89,  111,   91,  121,  121,   94,  121,  121,  121,
 /*  1320 */   121,  121,  121,  121,  102,  103,  104,  105,  106,  107,
 /*  1330 */   108,  121,   89,  111,   91,  121,  121,   94,  121,  121,
 /*  1340 */   121,  121,  121,  121,  121,  102,  103,  104,  105,  106,
 /*  1350 */   107,  108,  121,   89,  111,   91,  121,  121,   94,   73,
 /*  1360 */    74,   75,   76,   77,   78,  121,  102,  103,  104,  105,
 /*  1370 */   106,  107,  108,  121,   89,  111,   91,  121,  121,   94,
 /*  1380 */   121,  121,  121,  121,  121,  121,  121,  102,  103,  104,
 /*  1390 */   105,  106,  107,  108,  121,   89,  111,   91,  121,  121,
 /*  1400 */    94,  121,  121,  121,  121,  121,  121,  121,  102,  103,
 /*  1410 */   104,  105,  106,  107,  108,  121,   89,  111,   91,  121,
 /*  1420 */   121,   94,  121,  121,  121,  121,  121,  121,  121,  102,
 /*  1430 */   103,  104,  105,  106,  107,  108,  121,   89,  111,   91,
 /*  1440 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  121,
 /*  1450 */   102,  103,  104,  105,  106,  107,  108,  121,   89,  111,
 /*  1460 */    91,  121,  121,   94,  121,  121,  121,  121,  121,  121,
 /*  1470 */   121,  102,  103,  104,  105,  106,  107,  108,  121,   89,
 /*  1480 */   111,   91,  121,  121,   94,  121,  121,  121,  121,  121,
 /*  1490 */   121,  121,  102,  103,  104,  105,  106,  107,  108,  121,
 /*  1500 */    89,  111,   91,  121,  121,   94,  121,  121,  121,  121,
 /*  1510 */   121,  121,  121,  102,  103,  104,  105,  106,  107,  108,
 /*  1520 */   121,   89,  111,   91,  121,  121,   94,  121,  121,  121,
 /*  1530 */   121,  121,  121,  121,  102,  103,  104,  105,  106,  107,
 /*  1540 */   108,  121,   89,  111,   91,  121,  121,   94,  121,  121,
 /*  1550 */   121,  121,  121,  121,  121,  102,  103,  104,  105,  106,
 /*  1560 */   107,  108,  121,   89,  111,   91,  121,  121,   94,  121,
 /*  1570 */   121,  121,  121,  121,  121,  121,  102,  103,  104,  105,
 /*  1580 */   106,  107,  108,  121,   89,  111,   91,  121,  121,   94,
 /*  1590 */   121,  121,  121,  121,  121,  121,  121,  102,  103,  104,
 /*  1600 */   105,  106,  107,  108,  121,   89,  111,   91,  121,  121,
 /*  1610 */    94,  121,  121,  121,  121,  121,  121,  121,  102,  103,
 /*  1620 */   104,  105,  106,  107,  108,  121,   89,  111,   91,  121,
 /*  1630 */   121,   94,  121,  121,  121,  121,  121,  121,  121,  121,
 /*  1640 */   103,  104,  105,  106,  107,  108,  121,   89,  111,   91,
 /*  1650 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  121,
 /*  1660 */   121,  103,  104,  105,  106,  107,  108,  121,   89,  111,
 /*  1670 */    91,  121,  121,   94,  121,   89,   90,   91,  121,  121,
 /*  1680 */    94,  121,  103,  104,  105,  106,  107,  108,  121,  121,
 /*  1690 */   111,  105,  106,  107,  108,  121,   89,  111,   91,  121,
 /*  1700 */   121,   94,  121,  121,  121,  121,  121,  121,  121,  121,
 /*  1710 */   121,  104,  105,  106,  107,  108,  121,   89,  111,   91,
 /*  1720 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  121,
 /*  1730 */   121,  121,  104,  105,  106,  107,  108,  121,   89,  111,
 /*  1740 */    91,  121,  121,   94,  121,  121,  121,  121,  121,  121,
 /*  1750 */   121,  121,  121,  121,  105,  106,  107,  108,  121,   89,
 /*  1760 */   111,   91,  121,  121,   94,  121,   89,  121,   91,  121,
 /*  1770 */   121,   94,  121,  121,  121,  105,  106,  107,  108,  121,
 /*  1780 */   121,  111,  105,  106,  107,  108,  121,   89,  111,   91,
 /*  1790 */   121,  121,   94,  121,  121,  121,  121,  121,  121,  121,
 /*  1800 */   121,  121,  121,  105,  106,  107,  108,  121,   89,  111,
 /*  1810 */    91,  121,  121,   94,  121,  121,  121,  121,  121,  121,
 /*  1820 */   121,  121,  121,  121,  105,  106,  107,  108,  121,   89,
 /*  1830 */   111,   91,  121,  121,   94,  121,  121,  121,  121,  121,
 /*  1840 */   121,  121,  121,  121,  121,  105,  106,  107,  108,  121,
 /*  1850 */    89,  111,   91,  121,  121,   94,  121,  121,   89,  121,
 /*  1860 */    91,  121,  121,   94,  121,  121,  105,  106,  107,  108,
 /*  1870 */   121,  121,  111,  121,  105,  106,  107,  108,  121,   89,
 /*  1880 */   111,   91,  121,  121,   94,  121,  121,  121,  121,  121,
 /*  1890 */   121,  121,  121,  121,  121,  105,  106,  107,  108,  121,
 /*  1900 */    89,  111,   91,  121,  121,   94,  121,  121,  121,  121,
 /*  1910 */   121,  121,  121,  121,  121,  121,  105,  106,  107,  108,
 /*  1920 */   121,   89,  111,   91,  121,  121,   94,  121,  121,  121,
 /*  1930 */   121,  121,  121,  121,  121,  121,  121,  105,  106,  107,
 /*  1940 */   108,  121,   89,  111,   91,  121,  121,   94,  121,  121,
 /*  1950 */    89,  121,   91,  121,  121,   94,  121,  121,  105,  106,
 /*  1960 */   107,  108,  121,  121,  111,  121,  105,  106,  107,  108,
 /*  1970 */   121,   89,  111,   91,  121,  121,   94,  121,  121,  121,
 /*  1980 */   121,  121,  121,  121,  121,  121,  121,  105,  106,  107,
 /*  1990 */   108,  121,  121,  111,   82,   82,   82,   82,   82,   82,
 /*  2000 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2010 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2020 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2030 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2040 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2050 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2060 */    82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
 /*  2070 */    82,   82,   82,   82,   82,   82,
};
#define YY_SHIFT_COUNT    (163)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1286)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  557,  101,  135,  228,  135,  228,  626,  626,  626,
 /*    10 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    20 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    30 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    40 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    50 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    60 */   626,  626,  101,  626,  626,  487,  626,  626,  626,  626,
 /*    70 */   626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
 /*    80 */  1286,   44,   31,  142,  111,   44,   31,   42, 1207,  142,
 /*    90 */   142,  142,  142,  142,  142,  142,   48,  921,  921,  921,
 /*   100 */  1110,  175,  175,  106,  106,  106,  106,  106,  106,  106,
 /*   110 */   106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
 /*   120 */    18,  106,   18,  106,   18,  106,  274,  158,  290,  688,
 /*   130 */   181,    5,  168,  133,  133,  226,  133,  212,  197,  205,
 /*   140 */   133,  212,  300,  172,  166,  233,  241,  177,  232,  204,
 /*   150 */   216,  246,  246,  246,  266,  249,  248,  250,  246,  248,
 /*   160 */   250,  246,  253,  233,
};
#define YY_REDUCE_COUNT (96)
#define YY_REDUCE_MIN   (-108)
#define YY_REDUCE_MAX   (1882)
static const short yy_reduce_ofst[] = {
 /*     0 */   -65,   -6,   35,  128,  162,  221,  251,  283,  311,  339,
 /*    10 */   363,  387,  414,  435,  484,  508,  553,  574,  616,  637,
 /*    20 */   658,  679,  700,  721,  742,  763,  784,  805,  826,  847,
 /*    30 */   889,  910,  931,  952,  973,  994, 1015, 1052, 1077, 1098,
 /*    40 */  1134, 1155, 1178, 1201, 1222, 1243, 1264, 1285, 1306, 1327,
 /*    50 */  1348, 1369, 1390, 1411, 1432, 1453, 1474, 1495, 1516, 1537,
 /*    60 */  1558, 1579, 1586, 1607, 1628, 1649, 1670, 1677, 1698, 1719,
 /*    70 */  1740, 1761, 1769, 1790, 1649, 1811, 1832, 1853, 1861, 1882,
 /*    80 */   -27,   66, -108,  -68,   13,  -74,  -11,  -90,  -90,  -82,
 /*    90 */   -79,   22,   27,   54,   58,   70,   93,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   398,  481,  398,  489,  499,  491,  398,  486,  477,  398,
 /*    10 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    20 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    30 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    40 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    50 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    60 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    70 */   398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
 /*    80 */   398,  545,  481,  398,  530,  398,  398,  398,  398,  398,
 /*    90 */   398,  398,  398,  398,  398,  398,  398,  522,  434,  433,
 /*   100 */   528,  425,  517,  453,  452,  451,  450,  449,  448,  447,
 /*   110 */   446,  445,  444,  443,  442,  441,  440,  439,  438,  523,
 /*   120 */   525,  437,  458,  436,  457,  435,  398,  398,  398,  398,
 /*   130 */   398,  398,  398,  524,  456,  398,  455,  521,  398,  528,
 /*   140 */   454,  432,  516,  398,  539,  535,  398,  398,  398,  398,
 /*   150 */   547,  429,  428,  427,  398,  398,  520,  519,  518,  431,
 /*   160 */   430,  426,  398,  398,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#include <assert.h>
#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "START_SORT_KEYS",
  /*    4 */ "START_OPTIONS",
  /*    5 */ "LOGICAL_AND",
  /*    6 */ "LOGICAL_AND_NOT",
  /*    7 */ "LOGICAL_OR",
  /*    8 */ "NEGATIVE",
  /*    9 */ "QSTRING",
  /*   10 */ "PARENL",
  /*   11 */ "PARENR",
  /*   12 */ "ADJUST",
  /*   13 */ "RELATIVE_OP",
  /*   14 */ "IDENTIFIER",
  /*   15 */ "BRACEL",
  /*   16 */ "BRACER",
  /*   17 */ "EVAL",
  /*   18 */ "COMMA",
  /*   19 */ "ASSIGN",
  /*   20 */ "STAR_ASSIGN",
  /*   21 */ "SLASH_ASSIGN",
  /*   22 */ "MOD_ASSIGN",
  /*   23 */ "PLUS_ASSIGN",
  /*   24 */ "MINUS_ASSIGN",
  /*   25 */ "SHIFTL_ASSIGN",
  /*   26 */ "SHIFTR_ASSIGN",
  /*   27 */ "SHIFTRR_ASSIGN",
  /*   28 */ "AND_ASSIGN",
  /*   29 */ "XOR_ASSIGN",
  /*   30 */ "OR_ASSIGN",
  /*   31 */ "QUESTION",
  /*   32 */ "COLON",
  /*   33 */ "BITWISE_OR",
  /*   34 */ "BITWISE_XOR",
  /*   35 */ "BITWISE_AND",
  /*   36 */ "EQUAL",
  /*   37 */ "NOT_EQUAL",
  /*   38 */ "LESS",
  /*   39 */ "GREATER",
  /*   40 */ "LESS_EQUAL",
  /*   41 */ "GREATER_EQUAL",
  /*   42 */ "IN",
  /*   43 */ "MATCH",
  /*   44 */ "NEAR",
  /*   45 */ "NEAR_NO_OFFSET",
  /*   46 */ "NEAR_PHRASE",
  /*   47 */ "ORDERED_NEAR_PHRASE",
  /*   48 */ "NEAR_PHRASE_PRODUCT",
  /*   49 */ "ORDERED_NEAR_PHRASE_PRODUCT",
  /*   50 */ "SIMILAR",
  /*   51 */ "TERM_EXTRACT",
  /*   52 */ "QUORUM",
  /*   53 */ "LCP",
  /*   54 */ "PREFIX",
  /*   55 */ "SUFFIX",
  /*   56 */ "REGEXP",
  /*   57 */ "SHIFTL",
  /*   58 */ "SHIFTR",
  /*   59 */ "SHIFTRR",
  /*   60 */ "PLUS",
  /*   61 */ "MINUS",
  /*   62 */ "STAR",
  /*   63 */ "SLASH",
  /*   64 */ "MOD",
  /*   65 */ "DELETE",
  /*   66 */ "INCR",
  /*   67 */ "DECR",
  /*   68 */ "NOT",
  /*   69 */ "BITWISE_NOT",
  /*   70 */ "EXACT",
  /*   71 */ "PARTIAL",
  /*   72 */ "UNSPLIT",
  /*   73 */ "DECIMAL",
  /*   74 */ "HEX_INTEGER",
  /*   75 */ "STRING",
  /*   76 */ "BOOLEAN",
  /*   77 */ "NULL",
  /*   78 */ "BRACKETL",
  /*   79 */ "BRACKETR",
  /*   80 */ "DOT",
  /*   81 */ "NONEXISTENT_COLUMN",
  /*   82 */ "suppress_unused_variable_warning",
  /*   83 */ "input",
  /*   84 */ "query",
  /*   85 */ "expression",
  /*   86 */ "output_columns",
  /*   87 */ "adjuster",
  /*   88 */ "sort_keys",
  /*   89 */ "object_literal",
  /*   90 */ "query_element",
  /*   91 */ "primary_expression",
  /*   92 */ "assignment_expression",
  /*   93 */ "conditional_expression",
  /*   94 */ "lefthand_side_expression",
  /*   95 */ "logical_or_expression",
  /*   96 */ "logical_and_expression",
  /*   97 */ "bitwise_or_expression",
  /*   98 */ "bitwise_xor_expression",
  /*   99 */ "bitwise_and_expression",
  /*  100 */ "equality_expression",
  /*  101 */ "relational_expression",
  /*  102 */ "shift_expression",
  /*  103 */ "additive_expression",
  /*  104 */ "multiplicative_expression",
  /*  105 */ "unary_expression",
  /*  106 */ "postfix_expression",
  /*  107 */ "call_expression",
  /*  108 */ "member_expression",
  /*  109 */ "arguments",
  /*  110 */ "member_expression_part",
  /*  111 */ "array_literal",
  /*  112 */ "element_list",
  /*  113 */ "property_list",
  /*  114 */ "property",
  /*  115 */ "property_name",
  /*  116 */ "argument_list",
  /*  117 */ "output_column",
  /*  118 */ "adjust_expression",
  /*  119 */ "adjust_match_expression",
  /*  120 */ "sort_key",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression",
 /*  28 */ "logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression",
 /*  29 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  30 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  31 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  32 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  33 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  36 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  37 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  38 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  39 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  40 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression",
 /*  42 */ "relational_expression ::= relational_expression NEAR_PHRASE shift_expression",
 /*  43 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression",
 /*  44 */ "relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression",
 /*  45 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression",
 /*  46 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  47 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  48 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  49 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  50 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  51 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  52 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  53 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  54 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  55 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  56 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  57 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  58 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  59 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  60 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  61 */ "unary_expression ::= DELETE unary_expression",
 /*  62 */ "unary_expression ::= INCR unary_expression",
 /*  63 */ "unary_expression ::= DECR unary_expression",
 /*  64 */ "unary_expression ::= PLUS unary_expression",
 /*  65 */ "unary_expression ::= MINUS unary_expression",
 /*  66 */ "unary_expression ::= NOT unary_expression",
 /*  67 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  68 */ "unary_expression ::= ADJUST unary_expression",
 /*  69 */ "unary_expression ::= EXACT unary_expression",
 /*  70 */ "unary_expression ::= PARTIAL unary_expression",
 /*  71 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  72 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  73 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  74 */ "call_expression ::= member_expression arguments",
 /*  75 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /*  76 */ "element_list ::=",
 /*  77 */ "element_list ::= assignment_expression",
 /*  78 */ "element_list ::= element_list COMMA assignment_expression",
 /*  79 */ "object_literal ::= BRACEL property_list BRACER",
 /*  80 */ "property_list ::=",
 /*  81 */ "property_list ::= property",
 /*  82 */ "property_list ::= property_list COMMA property",
 /*  83 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  84 */ "arguments ::= PARENL argument_list PARENR",
 /*  85 */ "argument_list ::=",
 /*  86 */ "argument_list ::= assignment_expression",
 /*  87 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  88 */ "output_columns ::=",
 /*  89 */ "output_columns ::= output_column",
 /*  90 */ "output_columns ::= output_columns COMMA",
 /*  91 */ "output_columns ::= output_columns COMMA output_column",
 /*  92 */ "output_column ::= STAR",
 /*  93 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  94 */ "output_column ::= assignment_expression",
 /*  95 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  96 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  97 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  98 */ "sort_keys ::=",
 /*  99 */ "sort_keys ::= sort_key",
 /* 100 */ "sort_keys ::= sort_keys COMMA sort_key",
 /* 101 */ "sort_key ::= NONEXISTENT_COLUMN",
 /* 102 */ "sort_key ::= MINUS NONEXISTENT_COLUMN",
 /* 103 */ "sort_key ::= assignment_expression",
 /* 104 */ "input ::= query",
 /* 105 */ "input ::= expression",
 /* 106 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /* 107 */ "input ::= START_ADJUSTER adjuster",
 /* 108 */ "input ::= START_SORT_KEYS sort_keys",
 /* 109 */ "input ::= START_OPTIONS object_literal",
 /* 110 */ "query ::= query_element",
 /* 111 */ "query_element ::= QSTRING",
 /* 112 */ "query_element ::= PARENL query PARENR",
 /* 113 */ "expression ::= assignment_expression",
 /* 114 */ "assignment_expression ::= conditional_expression",
 /* 115 */ "conditional_expression ::= logical_or_expression",
 /* 116 */ "logical_or_expression ::= logical_and_expression",
 /* 117 */ "logical_and_expression ::= bitwise_or_expression",
 /* 118 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 119 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 120 */ "bitwise_and_expression ::= equality_expression",
 /* 121 */ "equality_expression ::= relational_expression",
 /* 122 */ "relational_expression ::= shift_expression",
 /* 123 */ "shift_expression ::= additive_expression",
 /* 124 */ "additive_expression ::= multiplicative_expression",
 /* 125 */ "multiplicative_expression ::= unary_expression",
 /* 126 */ "unary_expression ::= postfix_expression",
 /* 127 */ "postfix_expression ::= lefthand_side_expression",
 /* 128 */ "lefthand_side_expression ::= call_expression",
 /* 129 */ "lefthand_side_expression ::= member_expression",
 /* 130 */ "member_expression ::= primary_expression",
 /* 131 */ "member_expression ::= member_expression member_expression_part",
 /* 132 */ "primary_expression ::= object_literal",
 /* 133 */ "primary_expression ::= PARENL expression PARENR",
 /* 134 */ "primary_expression ::= IDENTIFIER",
 /* 135 */ "primary_expression ::= array_literal",
 /* 136 */ "primary_expression ::= DECIMAL",
 /* 137 */ "primary_expression ::= HEX_INTEGER",
 /* 138 */ "primary_expression ::= STRING",
 /* 139 */ "primary_expression ::= BOOLEAN",
 /* 140 */ "primary_expression ::= NULL",
 /* 141 */ "property ::= property_name COLON assignment_expression",
 /* 142 */ "property_name ::= STRING",
 /* 143 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 144 */ "adjuster ::=",
 /* 145 */ "adjuster ::= adjust_expression",
 /* 146 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 82: /* suppress_unused_variable_warning */
{
#line 146 "../../groonga/lib/grn_ecmascript.lemon"

  (void)efsi;

#line 1391 "../../groonga/lib/grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    84,  /* (0) query ::= query query_element */
    84,  /* (1) query ::= query LOGICAL_AND query_element */
    84,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
    84,  /* (3) query ::= query LOGICAL_OR query_element */
    84,  /* (4) query ::= query NEGATIVE query_element */
    90,  /* (5) query_element ::= ADJUST query_element */
    90,  /* (6) query_element ::= RELATIVE_OP query_element */
    90,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
    90,  /* (8) query_element ::= BRACEL expression BRACER */
    90,  /* (9) query_element ::= EVAL primary_expression */
    85,  /* (10) expression ::= expression COMMA assignment_expression */
    92,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
    92,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
    92,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
    92,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
    92,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
    92,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
    92,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
    92,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
    92,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
    92,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
    92,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
    92,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
    93,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
    95,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
    96,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
    96,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
    96,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
    96,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
    97,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
    98,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
    99,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   100,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
   100,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   101,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
   101,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
   101,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   101,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   101,  /* (38) relational_expression ::= relational_expression IN shift_expression */
   101,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
   101,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
   101,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
   101,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   101,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   101,  /* (44) relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
   101,  /* (45) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
   101,  /* (46) relational_expression ::= relational_expression SIMILAR shift_expression */
   101,  /* (47) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   101,  /* (48) relational_expression ::= relational_expression QUORUM shift_expression */
   101,  /* (49) relational_expression ::= relational_expression LCP shift_expression */
   101,  /* (50) relational_expression ::= relational_expression PREFIX shift_expression */
   101,  /* (51) relational_expression ::= relational_expression SUFFIX shift_expression */
   101,  /* (52) relational_expression ::= relational_expression REGEXP shift_expression */
   102,  /* (53) shift_expression ::= shift_expression SHIFTL additive_expression */
   102,  /* (54) shift_expression ::= shift_expression SHIFTR additive_expression */
   102,  /* (55) shift_expression ::= shift_expression SHIFTRR additive_expression */
   103,  /* (56) additive_expression ::= additive_expression PLUS multiplicative_expression */
   103,  /* (57) additive_expression ::= additive_expression MINUS multiplicative_expression */
   104,  /* (58) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   104,  /* (59) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   104,  /* (60) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   105,  /* (61) unary_expression ::= DELETE unary_expression */
   105,  /* (62) unary_expression ::= INCR unary_expression */
   105,  /* (63) unary_expression ::= DECR unary_expression */
   105,  /* (64) unary_expression ::= PLUS unary_expression */
   105,  /* (65) unary_expression ::= MINUS unary_expression */
   105,  /* (66) unary_expression ::= NOT unary_expression */
   105,  /* (67) unary_expression ::= BITWISE_NOT unary_expression */
   105,  /* (68) unary_expression ::= ADJUST unary_expression */
   105,  /* (69) unary_expression ::= EXACT unary_expression */
   105,  /* (70) unary_expression ::= PARTIAL unary_expression */
   105,  /* (71) unary_expression ::= UNSPLIT unary_expression */
   106,  /* (72) postfix_expression ::= lefthand_side_expression INCR */
   106,  /* (73) postfix_expression ::= lefthand_side_expression DECR */
   107,  /* (74) call_expression ::= member_expression arguments */
   111,  /* (75) array_literal ::= BRACKETL element_list BRACKETR */
   112,  /* (76) element_list ::= */
   112,  /* (77) element_list ::= assignment_expression */
   112,  /* (78) element_list ::= element_list COMMA assignment_expression */
    89,  /* (79) object_literal ::= BRACEL property_list BRACER */
   113,  /* (80) property_list ::= */
   113,  /* (81) property_list ::= property */
   113,  /* (82) property_list ::= property_list COMMA property */
   110,  /* (83) member_expression_part ::= BRACKETL expression BRACKETR */
   109,  /* (84) arguments ::= PARENL argument_list PARENR */
   116,  /* (85) argument_list ::= */
   116,  /* (86) argument_list ::= assignment_expression */
   116,  /* (87) argument_list ::= argument_list COMMA assignment_expression */
    86,  /* (88) output_columns ::= */
    86,  /* (89) output_columns ::= output_column */
    86,  /* (90) output_columns ::= output_columns COMMA */
    86,  /* (91) output_columns ::= output_columns COMMA output_column */
   117,  /* (92) output_column ::= STAR */
   117,  /* (93) output_column ::= NONEXISTENT_COLUMN */
   117,  /* (94) output_column ::= assignment_expression */
    87,  /* (95) adjuster ::= adjuster PLUS adjust_expression */
   118,  /* (96) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   119,  /* (97) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    88,  /* (98) sort_keys ::= */
    88,  /* (99) sort_keys ::= sort_key */
    88,  /* (100) sort_keys ::= sort_keys COMMA sort_key */
   120,  /* (101) sort_key ::= NONEXISTENT_COLUMN */
   120,  /* (102) sort_key ::= MINUS NONEXISTENT_COLUMN */
   120,  /* (103) sort_key ::= assignment_expression */
    83,  /* (104) input ::= query */
    83,  /* (105) input ::= expression */
    83,  /* (106) input ::= START_OUTPUT_COLUMNS output_columns */
    83,  /* (107) input ::= START_ADJUSTER adjuster */
    83,  /* (108) input ::= START_SORT_KEYS sort_keys */
    83,  /* (109) input ::= START_OPTIONS object_literal */
    84,  /* (110) query ::= query_element */
    90,  /* (111) query_element ::= QSTRING */
    90,  /* (112) query_element ::= PARENL query PARENR */
    85,  /* (113) expression ::= assignment_expression */
    92,  /* (114) assignment_expression ::= conditional_expression */
    93,  /* (115) conditional_expression ::= logical_or_expression */
    95,  /* (116) logical_or_expression ::= logical_and_expression */
    96,  /* (117) logical_and_expression ::= bitwise_or_expression */
    97,  /* (118) bitwise_or_expression ::= bitwise_xor_expression */
    98,  /* (119) bitwise_xor_expression ::= bitwise_and_expression */
    99,  /* (120) bitwise_and_expression ::= equality_expression */
   100,  /* (121) equality_expression ::= relational_expression */
   101,  /* (122) relational_expression ::= shift_expression */
   102,  /* (123) shift_expression ::= additive_expression */
   103,  /* (124) additive_expression ::= multiplicative_expression */
   104,  /* (125) multiplicative_expression ::= unary_expression */
   105,  /* (126) unary_expression ::= postfix_expression */
   106,  /* (127) postfix_expression ::= lefthand_side_expression */
    94,  /* (128) lefthand_side_expression ::= call_expression */
    94,  /* (129) lefthand_side_expression ::= member_expression */
   108,  /* (130) member_expression ::= primary_expression */
   108,  /* (131) member_expression ::= member_expression member_expression_part */
    91,  /* (132) primary_expression ::= object_literal */
    91,  /* (133) primary_expression ::= PARENL expression PARENR */
    91,  /* (134) primary_expression ::= IDENTIFIER */
    91,  /* (135) primary_expression ::= array_literal */
    91,  /* (136) primary_expression ::= DECIMAL */
    91,  /* (137) primary_expression ::= HEX_INTEGER */
    91,  /* (138) primary_expression ::= STRING */
    91,  /* (139) primary_expression ::= BOOLEAN */
    91,  /* (140) primary_expression ::= NULL */
   114,  /* (141) property ::= property_name COLON assignment_expression */
   115,  /* (142) property_name ::= STRING */
   110,  /* (143) member_expression_part ::= DOT IDENTIFIER */
    87,  /* (144) adjuster ::= */
    87,  /* (145) adjuster ::= adjust_expression */
   118,  /* (146) adjust_expression ::= adjust_match_expression */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) query ::= query query_element */
   -3,  /* (1) query ::= query LOGICAL_AND query_element */
   -3,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
   -3,  /* (3) query ::= query LOGICAL_OR query_element */
   -3,  /* (4) query ::= query NEGATIVE query_element */
   -2,  /* (5) query_element ::= ADJUST query_element */
   -2,  /* (6) query_element ::= RELATIVE_OP query_element */
   -3,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
   -3,  /* (8) query_element ::= BRACEL expression BRACER */
   -2,  /* (9) query_element ::= EVAL primary_expression */
   -3,  /* (10) expression ::= expression COMMA assignment_expression */
   -3,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
   -3,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
   -3,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
   -3,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
   -3,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
   -3,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
   -3,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
   -3,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
   -3,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
   -3,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
   -3,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
   -3,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
   -5,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
   -3,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
   -3,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
   -3,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
   -3,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
   -3,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
   -3,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
   -3,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   -3,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   -3,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
   -3,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   -3,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
   -3,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
   -3,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   -3,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   -3,  /* (38) relational_expression ::= relational_expression IN shift_expression */
   -3,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
   -3,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
   -3,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
   -3,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   -3,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   -3,  /* (44) relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
   -3,  /* (45) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
   -3,  /* (46) relational_expression ::= relational_expression SIMILAR shift_expression */
   -3,  /* (47) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   -3,  /* (48) relational_expression ::= relational_expression QUORUM shift_expression */
   -3,  /* (49) relational_expression ::= relational_expression LCP shift_expression */
   -3,  /* (50) relational_expression ::= relational_expression PREFIX shift_expression */
   -3,  /* (51) relational_expression ::= relational_expression SUFFIX shift_expression */
   -3,  /* (52) relational_expression ::= relational_expression REGEXP shift_expression */
   -3,  /* (53) shift_expression ::= shift_expression SHIFTL additive_expression */
   -3,  /* (54) shift_expression ::= shift_expression SHIFTR additive_expression */
   -3,  /* (55) shift_expression ::= shift_expression SHIFTRR additive_expression */
   -3,  /* (56) additive_expression ::= additive_expression PLUS multiplicative_expression */
   -3,  /* (57) additive_expression ::= additive_expression MINUS multiplicative_expression */
   -3,  /* (58) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   -3,  /* (59) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   -3,  /* (60) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   -2,  /* (61) unary_expression ::= DELETE unary_expression */
   -2,  /* (62) unary_expression ::= INCR unary_expression */
   -2,  /* (63) unary_expression ::= DECR unary_expression */
   -2,  /* (64) unary_expression ::= PLUS unary_expression */
   -2,  /* (65) unary_expression ::= MINUS unary_expression */
   -2,  /* (66) unary_expression ::= NOT unary_expression */
   -2,  /* (67) unary_expression ::= BITWISE_NOT unary_expression */
   -2,  /* (68) unary_expression ::= ADJUST unary_expression */
   -2,  /* (69) unary_expression ::= EXACT unary_expression */
   -2,  /* (70) unary_expression ::= PARTIAL unary_expression */
   -2,  /* (71) unary_expression ::= UNSPLIT unary_expression */
   -2,  /* (72) postfix_expression ::= lefthand_side_expression INCR */
   -2,  /* (73) postfix_expression ::= lefthand_side_expression DECR */
   -2,  /* (74) call_expression ::= member_expression arguments */
   -3,  /* (75) array_literal ::= BRACKETL element_list BRACKETR */
    0,  /* (76) element_list ::= */
   -1,  /* (77) element_list ::= assignment_expression */
   -3,  /* (78) element_list ::= element_list COMMA assignment_expression */
   -3,  /* (79) object_literal ::= BRACEL property_list BRACER */
    0,  /* (80) property_list ::= */
   -1,  /* (81) property_list ::= property */
   -3,  /* (82) property_list ::= property_list COMMA property */
   -3,  /* (83) member_expression_part ::= BRACKETL expression BRACKETR */
   -3,  /* (84) arguments ::= PARENL argument_list PARENR */
    0,  /* (85) argument_list ::= */
   -1,  /* (86) argument_list ::= assignment_expression */
   -3,  /* (87) argument_list ::= argument_list COMMA assignment_expression */
    0,  /* (88) output_columns ::= */
   -1,  /* (89) output_columns ::= output_column */
   -2,  /* (90) output_columns ::= output_columns COMMA */
   -3,  /* (91) output_columns ::= output_columns COMMA output_column */
   -1,  /* (92) output_column ::= STAR */
   -1,  /* (93) output_column ::= NONEXISTENT_COLUMN */
   -1,  /* (94) output_column ::= assignment_expression */
   -3,  /* (95) adjuster ::= adjuster PLUS adjust_expression */
   -3,  /* (96) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   -3,  /* (97) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    0,  /* (98) sort_keys ::= */
   -1,  /* (99) sort_keys ::= sort_key */
   -3,  /* (100) sort_keys ::= sort_keys COMMA sort_key */
   -1,  /* (101) sort_key ::= NONEXISTENT_COLUMN */
   -2,  /* (102) sort_key ::= MINUS NONEXISTENT_COLUMN */
   -1,  /* (103) sort_key ::= assignment_expression */
   -1,  /* (104) input ::= query */
   -1,  /* (105) input ::= expression */
   -2,  /* (106) input ::= START_OUTPUT_COLUMNS output_columns */
   -2,  /* (107) input ::= START_ADJUSTER adjuster */
   -2,  /* (108) input ::= START_SORT_KEYS sort_keys */
   -2,  /* (109) input ::= START_OPTIONS object_literal */
   -1,  /* (110) query ::= query_element */
   -1,  /* (111) query_element ::= QSTRING */
   -3,  /* (112) query_element ::= PARENL query PARENR */
   -1,  /* (113) expression ::= assignment_expression */
   -1,  /* (114) assignment_expression ::= conditional_expression */
   -1,  /* (115) conditional_expression ::= logical_or_expression */
   -1,  /* (116) logical_or_expression ::= logical_and_expression */
   -1,  /* (117) logical_and_expression ::= bitwise_or_expression */
   -1,  /* (118) bitwise_or_expression ::= bitwise_xor_expression */
   -1,  /* (119) bitwise_xor_expression ::= bitwise_and_expression */
   -1,  /* (120) bitwise_and_expression ::= equality_expression */
   -1,  /* (121) equality_expression ::= relational_expression */
   -1,  /* (122) relational_expression ::= shift_expression */
   -1,  /* (123) shift_expression ::= additive_expression */
   -1,  /* (124) additive_expression ::= multiplicative_expression */
   -1,  /* (125) multiplicative_expression ::= unary_expression */
   -1,  /* (126) unary_expression ::= postfix_expression */
   -1,  /* (127) postfix_expression ::= lefthand_side_expression */
   -1,  /* (128) lefthand_side_expression ::= call_expression */
   -1,  /* (129) lefthand_side_expression ::= member_expression */
   -1,  /* (130) member_expression ::= primary_expression */
   -2,  /* (131) member_expression ::= member_expression member_expression_part */
   -1,  /* (132) primary_expression ::= object_literal */
   -3,  /* (133) primary_expression ::= PARENL expression PARENR */
   -1,  /* (134) primary_expression ::= IDENTIFIER */
   -1,  /* (135) primary_expression ::= array_literal */
   -1,  /* (136) primary_expression ::= DECIMAL */
   -1,  /* (137) primary_expression ::= HEX_INTEGER */
   -1,  /* (138) primary_expression ::= STRING */
   -1,  /* (139) primary_expression ::= BOOLEAN */
   -1,  /* (140) primary_expression ::= NULL */
   -3,  /* (141) property ::= property_name COLON assignment_expression */
   -1,  /* (142) property_name ::= STRING */
   -2,  /* (143) member_expression_part ::= DOT IDENTIFIER */
    0,  /* (144) adjuster ::= */
   -1,  /* (145) adjuster ::= adjust_expression */
   -1,  /* (146) adjust_expression ::= adjust_match_expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 189 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 2025 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 192 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 2033 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 195 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 2041 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 198 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 2049 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 201 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 2058 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 210 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
}
#line 2066 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 214 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 2074 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 218 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR_NO_OFFSET :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      grn_obj *max_element_intervals;
      GRN_PTR_POP(&efsi->max_element_intervals_stack,
                  max_element_intervals);
      int min_interval;
      GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    }
    break;
  case GRN_OP_NEAR_PHRASE :
  case GRN_OP_ORDERED_NEAR_PHRASE :
  case GRN_OP_NEAR_PHRASE_PRODUCT :
  case GRN_OP_ORDERED_NEAR_PHRASE_PRODUCT :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      int additional_last_interval;
      GRN_INT32_POP(&efsi->additional_last_interval_stack,
                    additional_last_interval);
      grn_obj *max_element_intervals;
      GRN_PTR_POP(&efsi->max_element_intervals_stack,
                  max_element_intervals);
      int min_interval;
      GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 2129 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 269 "../../groonga/lib/grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 2137 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 277 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 2144 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 282 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 2151 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 285 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 2158 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 288 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 2165 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 291 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 2172 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 294 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 2179 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 297 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 2186 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 300 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 2193 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 303 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 2200 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 306 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 2207 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 309 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 2214 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 312 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 2221 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 315 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 2228 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 320 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 2237 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 27: /* logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
#line 338 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_AND, 2);
}
#line 2246 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 28: /* logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
#line 343 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_ADJUST, 2);
}
#line 2255 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 29: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 350 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 2262 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 30: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 355 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 2269 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 31: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 360 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 2276 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 32: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 365 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 2283 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 33: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 368 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 2290 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS shift_expression */
#line 373 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 2297 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 376 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 2304 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 379 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 2311 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 382 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 2318 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression IN shift_expression */
#line 385 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 2325 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 97: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==97);
#line 388 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 2333 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 391 "../../groonga/lib/grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, n_args);
}
#line 2363 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
#line 417 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_NO_OFFSET, 2);
}
#line 2370 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
#line 420 "../../groonga/lib/grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE, n_args);
}
#line 2406 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
#line 452 "../../groonga/lib/grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ORDERED_NEAR_PHRASE, n_args);
}
#line 2442 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression NEAR_PHRASE_PRODUCT shift_expression */
#line 484 "../../groonga/lib/grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE_PRODUCT, n_args);
}
#line 2478 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE_PRODUCT shift_expression */
#line 516 "../../groonga/lib/grn_ecmascript.lemon"
{
  int n_args = 2;
  do {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
    grn_obj *max_element_intervals;
    GRN_PTR_POP(&efsi->max_element_intervals_stack,
                max_element_intervals);
    int min_interval;
    GRN_INT32_POP(&efsi->min_interval_stack, min_interval);
    if (!max_element_intervals) {
      break;
    }
    grn_expr_append_obj(efsi->ctx, efsi->e, max_element_intervals,
                        GRN_OP_PUSH, 1);
    grn_expr_take_obj(efsi->ctx, efsi->e, max_element_intervals);
    n_args++;
    grn_expr_append_const_int(efsi->ctx, efsi->e, min_interval,
                              GRN_OP_PUSH, 1);
    n_args++;
  } while (false);
  grn_expr_append_op(efsi->ctx,
                     efsi->e,
                     GRN_OP_ORDERED_NEAR_PHRASE_PRODUCT,
                     n_args);
}
#line 2517 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 551 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 2530 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 560 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 2537 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 563 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 2550 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression LCP shift_expression */
#line 572 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 2557 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 575 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 2564 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 51: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 578 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 2571 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 52: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 581 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 2578 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 53: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 586 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 2585 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 54: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 589 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 2592 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 55: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 592 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2599 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 56: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 95: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==95);
#line 597 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2607 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 57: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 600 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2614 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 58: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 96: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==96);
#line 605 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2622 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 59: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 608 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2629 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 60: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 611 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2636 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= DELETE unary_expression */
#line 616 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2643 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= INCR unary_expression */
#line 619 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2664 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= DECR unary_expression */
#line 636 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2685 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= PLUS unary_expression */
#line 653 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2692 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= MINUS unary_expression */
#line 656 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2699 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 66: /* unary_expression ::= NOT unary_expression */
#line 659 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2706 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 67: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 662 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2713 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 68: /* unary_expression ::= ADJUST unary_expression */
#line 665 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2720 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 69: /* unary_expression ::= EXACT unary_expression */
#line 668 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2727 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 70: /* unary_expression ::= PARTIAL unary_expression */
#line 671 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2734 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 71: /* unary_expression ::= UNSPLIT unary_expression */
#line 674 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2741 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 72: /* postfix_expression ::= lefthand_side_expression INCR */
#line 679 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2762 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 73: /* postfix_expression ::= lefthand_side_expression DECR */
#line 696 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2783 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 74: /* call_expression ::= member_expression arguments */
#line 717 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2790 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 75: /* array_literal ::= BRACKETL element_list BRACKETR */
#line 734 "../../groonga/lib/grn_ecmascript.lemon"
{
  array_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2797 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 76: /* element_list ::= */
      case 80: /* property_list ::= */ yytestcase(yyruleno==80);
      case 88: /* output_columns ::= */ yytestcase(yyruleno==88);
      case 98: /* sort_keys ::= */ yytestcase(yyruleno==98);
#line 738 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2807 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 77: /* element_list ::= assignment_expression */
      case 81: /* property_list ::= property */ yytestcase(yyruleno==81);
      case 94: /* output_column ::= assignment_expression */ yytestcase(yyruleno==94);
      case 103: /* sort_key ::= assignment_expression */ yytestcase(yyruleno==103);
#line 741 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2817 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 78: /* element_list ::= element_list COMMA assignment_expression */
      case 82: /* property_list ::= property_list COMMA property */ yytestcase(yyruleno==82);
#line 744 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1;
}
#line 2825 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 79: /* object_literal ::= BRACEL property_list BRACER */
#line 748 "../../groonga/lib/grn_ecmascript.lemon"
{
  object_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2833 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 83: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 765 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2840 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 84: /* arguments ::= PARENL argument_list PARENR */
#line 770 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2845 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 85: /* argument_list ::= */
#line 771 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2850 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 86: /* argument_list ::= assignment_expression */
#line 772 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2855 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 87: /* argument_list ::= argument_list COMMA assignment_expression */
#line 773 "../../groonga/lib/grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2860 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 89: /* output_columns ::= output_column */
      case 99: /* sort_keys ::= sort_key */ yytestcase(yyruleno==99);
#line 778 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2869 "../../groonga/lib/grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 90: /* output_columns ::= output_columns COMMA */
#line 783 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2877 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 91: /* output_columns ::= output_columns COMMA output_column */
      case 100: /* sort_keys ::= sort_keys COMMA sort_key */ yytestcase(yyruleno==100);
#line 788 "../../groonga/lib/grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2895 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 92: /* output_column ::= STAR */
#line 801 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      grn_expr_take_obj(ctx, expr, column);
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        grn_expr_take_obj(ctx, expr, column);
      }
    }

    grn_obj_unref(ctx, table);
    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2947 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 93: /* output_column ::= NONEXISTENT_COLUMN */
      case 101: /* sort_key ::= NONEXISTENT_COLUMN */ yytestcase(yyruleno==101);
#line 848 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2955 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 102: /* sort_key ::= MINUS NONEXISTENT_COLUMN */
#line 894 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[-1].minor.yy0 = 0;
}
#line 2962 "../../groonga/lib/grn_ecmascript.c"
        break;
      default:
      /* (104) input ::= query */ yytestcase(yyruleno==104);
      /* (105) input ::= expression */ yytestcase(yyruleno==105);
      /* (106) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==106);
      /* (107) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==107);
      /* (108) input ::= START_SORT_KEYS sort_keys */ yytestcase(yyruleno==108);
      /* (109) input ::= START_OPTIONS object_literal */ yytestcase(yyruleno==109);
      /* (110) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=110);
      /* (111) query_element ::= QSTRING */ yytestcase(yyruleno==111);
      /* (112) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==112);
      /* (113) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=113);
      /* (114) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=114);
      /* (115) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==115);
      /* (116) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==116);
      /* (117) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==117);
      /* (118) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==118);
      /* (119) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==119);
      /* (120) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==120);
      /* (121) equality_expression ::= relational_expression */ yytestcase(yyruleno==121);
      /* (122) relational_expression ::= shift_expression */ yytestcase(yyruleno==122);
      /* (123) shift_expression ::= additive_expression */ yytestcase(yyruleno==123);
      /* (124) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==124);
      /* (125) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=125);
      /* (126) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=126);
      /* (127) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==127);
      /* (128) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=128);
      /* (129) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==129);
      /* (130) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==131);
      /* (132) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=132);
      /* (133) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==133);
      /* (134) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==134);
      /* (135) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=135);
      /* (136) primary_expression ::= DECIMAL */ yytestcase(yyruleno==136);
      /* (137) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==137);
      /* (138) primary_expression ::= STRING */ yytestcase(yyruleno==138);
      /* (139) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==139);
      /* (140) primary_expression ::= NULL */ yytestcase(yyruleno==140);
      /* (141) property ::= property_name COLON assignment_expression */ yytestcase(yyruleno==141);
      /* (142) property_name ::= STRING */ yytestcase(yyruleno==142);
      /* (143) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==143);
      /* (144) adjuster ::= */ yytestcase(yyruleno==144);
      /* (145) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=145);
      /* (146) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==146);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 152 "../../groonga/lib/grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 3095 "../../groonga/lib/grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
#ifndef NDEBUG
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0 
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos > yypParser->yystack ){
          yyact = yy_find_reduce_action(yypParser->yytos->stateno,
                                        YYERRORSYMBOL);
          if( yyact<=YY_MAX_SHIFTREDUCE ) break;
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos <= yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
