/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jsmooth.Native;

public class HTMLPane
extends JPanel {
    private JScrollPane m_scroller;
    private JEditorPane m_html;
    private URL m_baseurl;
    BrowserLauncher m_launcher;

    public HTMLPane() {
        try {
            this.m_baseurl = new File(".").toURL();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_html = new JEditorPane("text/html", "<html></html>"){

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        HTMLEditorKit hek = new HTMLEditorKit();
        this.m_html.setEditorKit(hek);
        this.m_scroller = new JScrollPane(this.m_html);
        this.setLayout(new BorderLayout());
        this.m_html.setEditable(false);
        this.add((Component)this.m_scroller, "Center");
        this.m_html.addHyperlinkListener(new Hyperactive());
        try {
            this.m_launcher = new BrowserLauncher();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void setPage(URL url) {
        try {
            URL u = new URL(this.m_baseurl, url.toExternalForm());
            this.m_html.setPage(u);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setText(String s) {
        this.m_html.setContentType("text/html");
        this.m_html.setText(s);
        this.m_html.setCaretPosition(0);
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        URL nurl = e.getURL();
                        if (nurl == null) {
                            nurl = new URL(HTMLPane.this.m_baseurl, e.getDescription());
                        }
                        if (Native.isAvailable()) {
                            Native.shellExecute((String)"open", (String)nurl.toString(), null, null, (int)1);
                        } else {
                            HTMLPane.this.m_launcher.openURLinBrowser(nurl.toExternalForm());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

