// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudtrailiface provides an interface to enable mocking the AWS CloudTrail service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudtrailiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/cloudtrail"
)

// CloudTrailAPI provides an interface to enable mocking the
// cloudtrail.CloudTrail service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS CloudTrail.
//	func myFunc(svc cloudtrailiface.CloudTrailAPI) bool {
//	    // Make svc.AddTags request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := cloudtrail.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockCloudTrailClient struct {
//	    cloudtrailiface.CloudTrailAPI
//	}
//	func (m *mockCloudTrailClient) AddTags(input *cloudtrail.AddTagsInput) (*cloudtrail.AddTagsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockCloudTrailClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CloudTrailAPI interface {
	AddTags(*cloudtrail.AddTagsInput) (*cloudtrail.AddTagsOutput, error)
	AddTagsWithContext(aws.Context, *cloudtrail.AddTagsInput, ...request.Option) (*cloudtrail.AddTagsOutput, error)
	AddTagsRequest(*cloudtrail.AddTagsInput) (*request.Request, *cloudtrail.AddTagsOutput)

	CancelQuery(*cloudtrail.CancelQueryInput) (*cloudtrail.CancelQueryOutput, error)
	CancelQueryWithContext(aws.Context, *cloudtrail.CancelQueryInput, ...request.Option) (*cloudtrail.CancelQueryOutput, error)
	CancelQueryRequest(*cloudtrail.CancelQueryInput) (*request.Request, *cloudtrail.CancelQueryOutput)

	CreateChannel(*cloudtrail.CreateChannelInput) (*cloudtrail.CreateChannelOutput, error)
	CreateChannelWithContext(aws.Context, *cloudtrail.CreateChannelInput, ...request.Option) (*cloudtrail.CreateChannelOutput, error)
	CreateChannelRequest(*cloudtrail.CreateChannelInput) (*request.Request, *cloudtrail.CreateChannelOutput)

	CreateEventDataStore(*cloudtrail.CreateEventDataStoreInput) (*cloudtrail.CreateEventDataStoreOutput, error)
	CreateEventDataStoreWithContext(aws.Context, *cloudtrail.CreateEventDataStoreInput, ...request.Option) (*cloudtrail.CreateEventDataStoreOutput, error)
	CreateEventDataStoreRequest(*cloudtrail.CreateEventDataStoreInput) (*request.Request, *cloudtrail.CreateEventDataStoreOutput)

	CreateTrail(*cloudtrail.CreateTrailInput) (*cloudtrail.CreateTrailOutput, error)
	CreateTrailWithContext(aws.Context, *cloudtrail.CreateTrailInput, ...request.Option) (*cloudtrail.CreateTrailOutput, error)
	CreateTrailRequest(*cloudtrail.CreateTrailInput) (*request.Request, *cloudtrail.CreateTrailOutput)

	DeleteChannel(*cloudtrail.DeleteChannelInput) (*cloudtrail.DeleteChannelOutput, error)
	DeleteChannelWithContext(aws.Context, *cloudtrail.DeleteChannelInput, ...request.Option) (*cloudtrail.DeleteChannelOutput, error)
	DeleteChannelRequest(*cloudtrail.DeleteChannelInput) (*request.Request, *cloudtrail.DeleteChannelOutput)

	DeleteEventDataStore(*cloudtrail.DeleteEventDataStoreInput) (*cloudtrail.DeleteEventDataStoreOutput, error)
	DeleteEventDataStoreWithContext(aws.Context, *cloudtrail.DeleteEventDataStoreInput, ...request.Option) (*cloudtrail.DeleteEventDataStoreOutput, error)
	DeleteEventDataStoreRequest(*cloudtrail.DeleteEventDataStoreInput) (*request.Request, *cloudtrail.DeleteEventDataStoreOutput)

	DeleteResourcePolicy(*cloudtrail.DeleteResourcePolicyInput) (*cloudtrail.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *cloudtrail.DeleteResourcePolicyInput, ...request.Option) (*cloudtrail.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*cloudtrail.DeleteResourcePolicyInput) (*request.Request, *cloudtrail.DeleteResourcePolicyOutput)

	DeleteTrail(*cloudtrail.DeleteTrailInput) (*cloudtrail.DeleteTrailOutput, error)
	DeleteTrailWithContext(aws.Context, *cloudtrail.DeleteTrailInput, ...request.Option) (*cloudtrail.DeleteTrailOutput, error)
	DeleteTrailRequest(*cloudtrail.DeleteTrailInput) (*request.Request, *cloudtrail.DeleteTrailOutput)

	DeregisterOrganizationDelegatedAdmin(*cloudtrail.DeregisterOrganizationDelegatedAdminInput) (*cloudtrail.DeregisterOrganizationDelegatedAdminOutput, error)
	DeregisterOrganizationDelegatedAdminWithContext(aws.Context, *cloudtrail.DeregisterOrganizationDelegatedAdminInput, ...request.Option) (*cloudtrail.DeregisterOrganizationDelegatedAdminOutput, error)
	DeregisterOrganizationDelegatedAdminRequest(*cloudtrail.DeregisterOrganizationDelegatedAdminInput) (*request.Request, *cloudtrail.DeregisterOrganizationDelegatedAdminOutput)

	DescribeQuery(*cloudtrail.DescribeQueryInput) (*cloudtrail.DescribeQueryOutput, error)
	DescribeQueryWithContext(aws.Context, *cloudtrail.DescribeQueryInput, ...request.Option) (*cloudtrail.DescribeQueryOutput, error)
	DescribeQueryRequest(*cloudtrail.DescribeQueryInput) (*request.Request, *cloudtrail.DescribeQueryOutput)

	DescribeTrails(*cloudtrail.DescribeTrailsInput) (*cloudtrail.DescribeTrailsOutput, error)
	DescribeTrailsWithContext(aws.Context, *cloudtrail.DescribeTrailsInput, ...request.Option) (*cloudtrail.DescribeTrailsOutput, error)
	DescribeTrailsRequest(*cloudtrail.DescribeTrailsInput) (*request.Request, *cloudtrail.DescribeTrailsOutput)

	DisableFederation(*cloudtrail.DisableFederationInput) (*cloudtrail.DisableFederationOutput, error)
	DisableFederationWithContext(aws.Context, *cloudtrail.DisableFederationInput, ...request.Option) (*cloudtrail.DisableFederationOutput, error)
	DisableFederationRequest(*cloudtrail.DisableFederationInput) (*request.Request, *cloudtrail.DisableFederationOutput)

	EnableFederation(*cloudtrail.EnableFederationInput) (*cloudtrail.EnableFederationOutput, error)
	EnableFederationWithContext(aws.Context, *cloudtrail.EnableFederationInput, ...request.Option) (*cloudtrail.EnableFederationOutput, error)
	EnableFederationRequest(*cloudtrail.EnableFederationInput) (*request.Request, *cloudtrail.EnableFederationOutput)

	GetChannel(*cloudtrail.GetChannelInput) (*cloudtrail.GetChannelOutput, error)
	GetChannelWithContext(aws.Context, *cloudtrail.GetChannelInput, ...request.Option) (*cloudtrail.GetChannelOutput, error)
	GetChannelRequest(*cloudtrail.GetChannelInput) (*request.Request, *cloudtrail.GetChannelOutput)

	GetEventDataStore(*cloudtrail.GetEventDataStoreInput) (*cloudtrail.GetEventDataStoreOutput, error)
	GetEventDataStoreWithContext(aws.Context, *cloudtrail.GetEventDataStoreInput, ...request.Option) (*cloudtrail.GetEventDataStoreOutput, error)
	GetEventDataStoreRequest(*cloudtrail.GetEventDataStoreInput) (*request.Request, *cloudtrail.GetEventDataStoreOutput)

	GetEventSelectors(*cloudtrail.GetEventSelectorsInput) (*cloudtrail.GetEventSelectorsOutput, error)
	GetEventSelectorsWithContext(aws.Context, *cloudtrail.GetEventSelectorsInput, ...request.Option) (*cloudtrail.GetEventSelectorsOutput, error)
	GetEventSelectorsRequest(*cloudtrail.GetEventSelectorsInput) (*request.Request, *cloudtrail.GetEventSelectorsOutput)

	GetImport(*cloudtrail.GetImportInput) (*cloudtrail.GetImportOutput, error)
	GetImportWithContext(aws.Context, *cloudtrail.GetImportInput, ...request.Option) (*cloudtrail.GetImportOutput, error)
	GetImportRequest(*cloudtrail.GetImportInput) (*request.Request, *cloudtrail.GetImportOutput)

	GetInsightSelectors(*cloudtrail.GetInsightSelectorsInput) (*cloudtrail.GetInsightSelectorsOutput, error)
	GetInsightSelectorsWithContext(aws.Context, *cloudtrail.GetInsightSelectorsInput, ...request.Option) (*cloudtrail.GetInsightSelectorsOutput, error)
	GetInsightSelectorsRequest(*cloudtrail.GetInsightSelectorsInput) (*request.Request, *cloudtrail.GetInsightSelectorsOutput)

	GetQueryResults(*cloudtrail.GetQueryResultsInput) (*cloudtrail.GetQueryResultsOutput, error)
	GetQueryResultsWithContext(aws.Context, *cloudtrail.GetQueryResultsInput, ...request.Option) (*cloudtrail.GetQueryResultsOutput, error)
	GetQueryResultsRequest(*cloudtrail.GetQueryResultsInput) (*request.Request, *cloudtrail.GetQueryResultsOutput)

	GetQueryResultsPages(*cloudtrail.GetQueryResultsInput, func(*cloudtrail.GetQueryResultsOutput, bool) bool) error
	GetQueryResultsPagesWithContext(aws.Context, *cloudtrail.GetQueryResultsInput, func(*cloudtrail.GetQueryResultsOutput, bool) bool, ...request.Option) error

	GetResourcePolicy(*cloudtrail.GetResourcePolicyInput) (*cloudtrail.GetResourcePolicyOutput, error)
	GetResourcePolicyWithContext(aws.Context, *cloudtrail.GetResourcePolicyInput, ...request.Option) (*cloudtrail.GetResourcePolicyOutput, error)
	GetResourcePolicyRequest(*cloudtrail.GetResourcePolicyInput) (*request.Request, *cloudtrail.GetResourcePolicyOutput)

	GetTrail(*cloudtrail.GetTrailInput) (*cloudtrail.GetTrailOutput, error)
	GetTrailWithContext(aws.Context, *cloudtrail.GetTrailInput, ...request.Option) (*cloudtrail.GetTrailOutput, error)
	GetTrailRequest(*cloudtrail.GetTrailInput) (*request.Request, *cloudtrail.GetTrailOutput)

	GetTrailStatus(*cloudtrail.GetTrailStatusInput) (*cloudtrail.GetTrailStatusOutput, error)
	GetTrailStatusWithContext(aws.Context, *cloudtrail.GetTrailStatusInput, ...request.Option) (*cloudtrail.GetTrailStatusOutput, error)
	GetTrailStatusRequest(*cloudtrail.GetTrailStatusInput) (*request.Request, *cloudtrail.GetTrailStatusOutput)

	ListChannels(*cloudtrail.ListChannelsInput) (*cloudtrail.ListChannelsOutput, error)
	ListChannelsWithContext(aws.Context, *cloudtrail.ListChannelsInput, ...request.Option) (*cloudtrail.ListChannelsOutput, error)
	ListChannelsRequest(*cloudtrail.ListChannelsInput) (*request.Request, *cloudtrail.ListChannelsOutput)

	ListChannelsPages(*cloudtrail.ListChannelsInput, func(*cloudtrail.ListChannelsOutput, bool) bool) error
	ListChannelsPagesWithContext(aws.Context, *cloudtrail.ListChannelsInput, func(*cloudtrail.ListChannelsOutput, bool) bool, ...request.Option) error

	ListEventDataStores(*cloudtrail.ListEventDataStoresInput) (*cloudtrail.ListEventDataStoresOutput, error)
	ListEventDataStoresWithContext(aws.Context, *cloudtrail.ListEventDataStoresInput, ...request.Option) (*cloudtrail.ListEventDataStoresOutput, error)
	ListEventDataStoresRequest(*cloudtrail.ListEventDataStoresInput) (*request.Request, *cloudtrail.ListEventDataStoresOutput)

	ListEventDataStoresPages(*cloudtrail.ListEventDataStoresInput, func(*cloudtrail.ListEventDataStoresOutput, bool) bool) error
	ListEventDataStoresPagesWithContext(aws.Context, *cloudtrail.ListEventDataStoresInput, func(*cloudtrail.ListEventDataStoresOutput, bool) bool, ...request.Option) error

	ListImportFailures(*cloudtrail.ListImportFailuresInput) (*cloudtrail.ListImportFailuresOutput, error)
	ListImportFailuresWithContext(aws.Context, *cloudtrail.ListImportFailuresInput, ...request.Option) (*cloudtrail.ListImportFailuresOutput, error)
	ListImportFailuresRequest(*cloudtrail.ListImportFailuresInput) (*request.Request, *cloudtrail.ListImportFailuresOutput)

	ListImportFailuresPages(*cloudtrail.ListImportFailuresInput, func(*cloudtrail.ListImportFailuresOutput, bool) bool) error
	ListImportFailuresPagesWithContext(aws.Context, *cloudtrail.ListImportFailuresInput, func(*cloudtrail.ListImportFailuresOutput, bool) bool, ...request.Option) error

	ListImports(*cloudtrail.ListImportsInput) (*cloudtrail.ListImportsOutput, error)
	ListImportsWithContext(aws.Context, *cloudtrail.ListImportsInput, ...request.Option) (*cloudtrail.ListImportsOutput, error)
	ListImportsRequest(*cloudtrail.ListImportsInput) (*request.Request, *cloudtrail.ListImportsOutput)

	ListImportsPages(*cloudtrail.ListImportsInput, func(*cloudtrail.ListImportsOutput, bool) bool) error
	ListImportsPagesWithContext(aws.Context, *cloudtrail.ListImportsInput, func(*cloudtrail.ListImportsOutput, bool) bool, ...request.Option) error

	ListInsightsMetricData(*cloudtrail.ListInsightsMetricDataInput) (*cloudtrail.ListInsightsMetricDataOutput, error)
	ListInsightsMetricDataWithContext(aws.Context, *cloudtrail.ListInsightsMetricDataInput, ...request.Option) (*cloudtrail.ListInsightsMetricDataOutput, error)
	ListInsightsMetricDataRequest(*cloudtrail.ListInsightsMetricDataInput) (*request.Request, *cloudtrail.ListInsightsMetricDataOutput)

	ListInsightsMetricDataPages(*cloudtrail.ListInsightsMetricDataInput, func(*cloudtrail.ListInsightsMetricDataOutput, bool) bool) error
	ListInsightsMetricDataPagesWithContext(aws.Context, *cloudtrail.ListInsightsMetricDataInput, func(*cloudtrail.ListInsightsMetricDataOutput, bool) bool, ...request.Option) error

	ListPublicKeys(*cloudtrail.ListPublicKeysInput) (*cloudtrail.ListPublicKeysOutput, error)
	ListPublicKeysWithContext(aws.Context, *cloudtrail.ListPublicKeysInput, ...request.Option) (*cloudtrail.ListPublicKeysOutput, error)
	ListPublicKeysRequest(*cloudtrail.ListPublicKeysInput) (*request.Request, *cloudtrail.ListPublicKeysOutput)

	ListPublicKeysPages(*cloudtrail.ListPublicKeysInput, func(*cloudtrail.ListPublicKeysOutput, bool) bool) error
	ListPublicKeysPagesWithContext(aws.Context, *cloudtrail.ListPublicKeysInput, func(*cloudtrail.ListPublicKeysOutput, bool) bool, ...request.Option) error

	ListQueries(*cloudtrail.ListQueriesInput) (*cloudtrail.ListQueriesOutput, error)
	ListQueriesWithContext(aws.Context, *cloudtrail.ListQueriesInput, ...request.Option) (*cloudtrail.ListQueriesOutput, error)
	ListQueriesRequest(*cloudtrail.ListQueriesInput) (*request.Request, *cloudtrail.ListQueriesOutput)

	ListQueriesPages(*cloudtrail.ListQueriesInput, func(*cloudtrail.ListQueriesOutput, bool) bool) error
	ListQueriesPagesWithContext(aws.Context, *cloudtrail.ListQueriesInput, func(*cloudtrail.ListQueriesOutput, bool) bool, ...request.Option) error

	ListTags(*cloudtrail.ListTagsInput) (*cloudtrail.ListTagsOutput, error)
	ListTagsWithContext(aws.Context, *cloudtrail.ListTagsInput, ...request.Option) (*cloudtrail.ListTagsOutput, error)
	ListTagsRequest(*cloudtrail.ListTagsInput) (*request.Request, *cloudtrail.ListTagsOutput)

	ListTagsPages(*cloudtrail.ListTagsInput, func(*cloudtrail.ListTagsOutput, bool) bool) error
	ListTagsPagesWithContext(aws.Context, *cloudtrail.ListTagsInput, func(*cloudtrail.ListTagsOutput, bool) bool, ...request.Option) error

	ListTrails(*cloudtrail.ListTrailsInput) (*cloudtrail.ListTrailsOutput, error)
	ListTrailsWithContext(aws.Context, *cloudtrail.ListTrailsInput, ...request.Option) (*cloudtrail.ListTrailsOutput, error)
	ListTrailsRequest(*cloudtrail.ListTrailsInput) (*request.Request, *cloudtrail.ListTrailsOutput)

	ListTrailsPages(*cloudtrail.ListTrailsInput, func(*cloudtrail.ListTrailsOutput, bool) bool) error
	ListTrailsPagesWithContext(aws.Context, *cloudtrail.ListTrailsInput, func(*cloudtrail.ListTrailsOutput, bool) bool, ...request.Option) error

	LookupEvents(*cloudtrail.LookupEventsInput) (*cloudtrail.LookupEventsOutput, error)
	LookupEventsWithContext(aws.Context, *cloudtrail.LookupEventsInput, ...request.Option) (*cloudtrail.LookupEventsOutput, error)
	LookupEventsRequest(*cloudtrail.LookupEventsInput) (*request.Request, *cloudtrail.LookupEventsOutput)

	LookupEventsPages(*cloudtrail.LookupEventsInput, func(*cloudtrail.LookupEventsOutput, bool) bool) error
	LookupEventsPagesWithContext(aws.Context, *cloudtrail.LookupEventsInput, func(*cloudtrail.LookupEventsOutput, bool) bool, ...request.Option) error

	PutEventSelectors(*cloudtrail.PutEventSelectorsInput) (*cloudtrail.PutEventSelectorsOutput, error)
	PutEventSelectorsWithContext(aws.Context, *cloudtrail.PutEventSelectorsInput, ...request.Option) (*cloudtrail.PutEventSelectorsOutput, error)
	PutEventSelectorsRequest(*cloudtrail.PutEventSelectorsInput) (*request.Request, *cloudtrail.PutEventSelectorsOutput)

	PutInsightSelectors(*cloudtrail.PutInsightSelectorsInput) (*cloudtrail.PutInsightSelectorsOutput, error)
	PutInsightSelectorsWithContext(aws.Context, *cloudtrail.PutInsightSelectorsInput, ...request.Option) (*cloudtrail.PutInsightSelectorsOutput, error)
	PutInsightSelectorsRequest(*cloudtrail.PutInsightSelectorsInput) (*request.Request, *cloudtrail.PutInsightSelectorsOutput)

	PutResourcePolicy(*cloudtrail.PutResourcePolicyInput) (*cloudtrail.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *cloudtrail.PutResourcePolicyInput, ...request.Option) (*cloudtrail.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*cloudtrail.PutResourcePolicyInput) (*request.Request, *cloudtrail.PutResourcePolicyOutput)

	RegisterOrganizationDelegatedAdmin(*cloudtrail.RegisterOrganizationDelegatedAdminInput) (*cloudtrail.RegisterOrganizationDelegatedAdminOutput, error)
	RegisterOrganizationDelegatedAdminWithContext(aws.Context, *cloudtrail.RegisterOrganizationDelegatedAdminInput, ...request.Option) (*cloudtrail.RegisterOrganizationDelegatedAdminOutput, error)
	RegisterOrganizationDelegatedAdminRequest(*cloudtrail.RegisterOrganizationDelegatedAdminInput) (*request.Request, *cloudtrail.RegisterOrganizationDelegatedAdminOutput)

	RemoveTags(*cloudtrail.RemoveTagsInput) (*cloudtrail.RemoveTagsOutput, error)
	RemoveTagsWithContext(aws.Context, *cloudtrail.RemoveTagsInput, ...request.Option) (*cloudtrail.RemoveTagsOutput, error)
	RemoveTagsRequest(*cloudtrail.RemoveTagsInput) (*request.Request, *cloudtrail.RemoveTagsOutput)

	RestoreEventDataStore(*cloudtrail.RestoreEventDataStoreInput) (*cloudtrail.RestoreEventDataStoreOutput, error)
	RestoreEventDataStoreWithContext(aws.Context, *cloudtrail.RestoreEventDataStoreInput, ...request.Option) (*cloudtrail.RestoreEventDataStoreOutput, error)
	RestoreEventDataStoreRequest(*cloudtrail.RestoreEventDataStoreInput) (*request.Request, *cloudtrail.RestoreEventDataStoreOutput)

	StartEventDataStoreIngestion(*cloudtrail.StartEventDataStoreIngestionInput) (*cloudtrail.StartEventDataStoreIngestionOutput, error)
	StartEventDataStoreIngestionWithContext(aws.Context, *cloudtrail.StartEventDataStoreIngestionInput, ...request.Option) (*cloudtrail.StartEventDataStoreIngestionOutput, error)
	StartEventDataStoreIngestionRequest(*cloudtrail.StartEventDataStoreIngestionInput) (*request.Request, *cloudtrail.StartEventDataStoreIngestionOutput)

	StartImport(*cloudtrail.StartImportInput) (*cloudtrail.StartImportOutput, error)
	StartImportWithContext(aws.Context, *cloudtrail.StartImportInput, ...request.Option) (*cloudtrail.StartImportOutput, error)
	StartImportRequest(*cloudtrail.StartImportInput) (*request.Request, *cloudtrail.StartImportOutput)

	StartLogging(*cloudtrail.StartLoggingInput) (*cloudtrail.StartLoggingOutput, error)
	StartLoggingWithContext(aws.Context, *cloudtrail.StartLoggingInput, ...request.Option) (*cloudtrail.StartLoggingOutput, error)
	StartLoggingRequest(*cloudtrail.StartLoggingInput) (*request.Request, *cloudtrail.StartLoggingOutput)

	StartQuery(*cloudtrail.StartQueryInput) (*cloudtrail.StartQueryOutput, error)
	StartQueryWithContext(aws.Context, *cloudtrail.StartQueryInput, ...request.Option) (*cloudtrail.StartQueryOutput, error)
	StartQueryRequest(*cloudtrail.StartQueryInput) (*request.Request, *cloudtrail.StartQueryOutput)

	StopEventDataStoreIngestion(*cloudtrail.StopEventDataStoreIngestionInput) (*cloudtrail.StopEventDataStoreIngestionOutput, error)
	StopEventDataStoreIngestionWithContext(aws.Context, *cloudtrail.StopEventDataStoreIngestionInput, ...request.Option) (*cloudtrail.StopEventDataStoreIngestionOutput, error)
	StopEventDataStoreIngestionRequest(*cloudtrail.StopEventDataStoreIngestionInput) (*request.Request, *cloudtrail.StopEventDataStoreIngestionOutput)

	StopImport(*cloudtrail.StopImportInput) (*cloudtrail.StopImportOutput, error)
	StopImportWithContext(aws.Context, *cloudtrail.StopImportInput, ...request.Option) (*cloudtrail.StopImportOutput, error)
	StopImportRequest(*cloudtrail.StopImportInput) (*request.Request, *cloudtrail.StopImportOutput)

	StopLogging(*cloudtrail.StopLoggingInput) (*cloudtrail.StopLoggingOutput, error)
	StopLoggingWithContext(aws.Context, *cloudtrail.StopLoggingInput, ...request.Option) (*cloudtrail.StopLoggingOutput, error)
	StopLoggingRequest(*cloudtrail.StopLoggingInput) (*request.Request, *cloudtrail.StopLoggingOutput)

	UpdateChannel(*cloudtrail.UpdateChannelInput) (*cloudtrail.UpdateChannelOutput, error)
	UpdateChannelWithContext(aws.Context, *cloudtrail.UpdateChannelInput, ...request.Option) (*cloudtrail.UpdateChannelOutput, error)
	UpdateChannelRequest(*cloudtrail.UpdateChannelInput) (*request.Request, *cloudtrail.UpdateChannelOutput)

	UpdateEventDataStore(*cloudtrail.UpdateEventDataStoreInput) (*cloudtrail.UpdateEventDataStoreOutput, error)
	UpdateEventDataStoreWithContext(aws.Context, *cloudtrail.UpdateEventDataStoreInput, ...request.Option) (*cloudtrail.UpdateEventDataStoreOutput, error)
	UpdateEventDataStoreRequest(*cloudtrail.UpdateEventDataStoreInput) (*request.Request, *cloudtrail.UpdateEventDataStoreOutput)

	UpdateTrail(*cloudtrail.UpdateTrailInput) (*cloudtrail.UpdateTrailOutput, error)
	UpdateTrailWithContext(aws.Context, *cloudtrail.UpdateTrailInput, ...request.Option) (*cloudtrail.UpdateTrailOutput, error)
	UpdateTrailRequest(*cloudtrail.UpdateTrailInput) (*request.Request, *cloudtrail.UpdateTrailOutput)
}

var _ CloudTrailAPI = (*cloudtrail.CloudTrail)(nil)
