
/*

    seti.c - Seti@home histograms for dock applet
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <sys/vfs.h>

#include "dockhelper.h"
#include "seti.h"



/* reads seti status */
void seti_update(struct seti_monitor *setimon) {
  
  FILE *f;
  char s[255];
  float percent;
  
  if (!(f = fopen(setimon->setiwd, "r")))
  {
    fprintf(stderr, "Open seti work file failed.");
    setimon->perc=0;
    return;
  }
  while (!feof (f))
  {
    fgets (s, 254, f);
    if (strstr (s, "prog="))
    {
      sscanf (s, "prog=%f", &percent);
      break;
    }
  }
  fclose(f);
  setimon->perc=(int) (percent*100000.0);
}



/* set size for setitem histogram */
int seti_size(struct seti_monitor *setimon) {

  dh_getsize(setimon->handler, &(setimon->xf), &(setimon->yf), &(setimon->wf), &(setimon->hf));
  /* if size is less than 2x10 pixel is unusable */
  if ((setimon->hf < 2) || (setimon->wf < 10)) return -1;
  return 0;
}



/* draw seti histogram */
void seti_draw(struct seti_monitor *setimon) {

  int ux=0;

  if (setimon->perc == 0)
  {
    ux = 0;
  }
  else
  {
    ux = ((setimon->perc) * setimon->wf) / 100000;
  }
  dh_color(dh_background());
  dh_fillrect(setimon->xf,setimon->yf,setimon->wf,setimon->hf);
  /* draw individual seti histogram */
  dh_color(setimon->seti_color);
  dh_fillrect(setimon->xf,setimon->yf,ux,setimon->hf);
}



