# Migration from SimpleAnalysis to Rivet v4.1

Use the following table for some first guidance on how to migrate your code from SimpleAnalysis to Rivet v4.1.

| SimpleAnalysis | Rivet |
| -------------- | ----- |
| `accept(region)` | `fill(region, value)` |
| `calcAMT2(fourMom1, fourMom2, met, invisiblesMass, target_mass)` | mT2(fourMom1, fourMom2, met, invisiblesMass, invisiblesMass2=-1) |
| `calcMT(fourMom1, fourMom2)` | `mT(fourMom1, fourMom2)` |
| `calcMTmin()` | |
| `countObjects(objs, conds)` | `select(objs, conds).size()` |
| `d0`, `d0sigma`, `d0significance` | just ignore them for now! |
| `event->getElectrons()` | `electrons()` |
| `event->getJets()` | `jets()` |
| `event->getMET()` | `met()` |
| | `metSignf()` |
| `event->getMuons()` | `muons()` |
| `filterCrack(elecs)` | `select(elecs, Cuts::abseta<1.37 or Cuts::abseta>1.52)` |
| `filterJets(jets, conds)` | `select(jets, conds)` |
| `filterObjects(objs, conds)` | `select(objs, conds)` |
| `filterObjectsRange(objs, cond_low, cond_high)` | `select(objs, cond_low && cond_high)` |
| `minDphi(objs)` | `deltaPhiMin(objs)` |
| `minDR(objs)` | `deltaRMin(objs)` |
| `overlapRemoval(objs)` | `doSimpleOverlapRemoval()` |
| `obj.Eta()` | `obj.eta()` |
| `obj.Phi()` | `obj.phi()` |
| `obj.Pt()` | `obj.pT()` |
| `reclusterJets(jets, conds)` | `reclusterJets(jets, conds)` |
| `sortObjectsByMass(objs)` | `isort(objs, Kin::mass)` |
| `sortObjectsByPt(objs)` | `isortByPt(objs)` |
| `sumObjectsPt(objs, base_val)` | `sumPtVec(objs) + base_val` |

Let us know if you require further advice (in general or to be added here)!
In general, have a look at [MathUtils.hh](../../include/Rivet/Math/MathUtils.hh), [ParticleBaseUtils.hh](../../include/Rivet/Tools/ParticleBaseUtils.hh), and [RivetMT2.hh](../../include/Rivet/Tools/RivetMT2.hh) for further inspiration of handy calculation shortcuts that Rivet provides!