/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import devplugin.Date;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import tvbrowser.core.TvDataBase;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class TvDataInventory {
    public static final int UNKNOWN = 1;
    public static final int OTHER_VERSION = 2;
    public static final int KNOWN = 3;
    private HashMap<String, Integer> mInventoryHash = new HashMap();

    public synchronized int getKnownStatus(Date date, Channel channel, int version) {
        String key = TvDataBase.getDayProgramKey(date, channel);
        Integer ver = this.mInventoryHash.get(key);
        if (ver == null) {
            return 1;
        }
        if (ver != version) {
            return 2;
        }
        return 3;
    }

    public synchronized void setKnown(Date date, Channel channel, int version) {
        String key = TvDataBase.getDayProgramKey(date, channel);
        this.mInventoryHash.put(key, version);
    }

    public synchronized void setUnknown(Date date, Channel channel) {
        String key = TvDataBase.getDayProgramKey(date, channel);
        this.mInventoryHash.remove(key);
    }

    public synchronized void setUnknown(String key) {
        this.mInventoryHash.remove(key);
    }

    public synchronized String[] getKnownDayPrograms() {
        String[] keyArr = new String[this.mInventoryHash.size()];
        this.mInventoryHash.keySet().toArray(keyArr);
        return keyArr;
    }

    public synchronized void readData(File file) throws IOException, ClassNotFoundException {
        StreamUtilities.objectInputStream(file, 65536, new ObjectInputStreamProcessor(){

            @Override
            public void process(ObjectInputStream in) throws IOException {
                try {
                    in.readInt();
                    TvDataInventory.this.mInventoryHash.clear();
                    int count = in.readInt();
                    for (int i = 0; i < count; ++i) {
                        String key = (String)in.readObject();
                        Integer ver = in.readInt();
                        TvDataInventory.this.mInventoryHash.put(key, ver);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public synchronized void writeData(File file) throws IOException {
        StreamUtilities.objectOutputStream(file, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(1);
                out.writeInt(TvDataInventory.this.mInventoryHash.size());
                for (String key : TvDataInventory.this.mInventoryHash.keySet()) {
                    Integer ver = TvDataInventory.this.mInventoryHash.get(key);
                    out.writeObject(key);
                    out.writeInt(ver);
                }
                out.close();
            }
        });
    }
}

