/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.FinishWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class RenameWizardStep
extends AbstractWizardStep {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(RenameWizardStep.class);
    private JTextField mNameTf;
    private WizardStep mCaller;

    public RenameWizardStep(WizardStep caller) {
        this.mCaller = caller;
    }

    @Override
    protected JPanel createContent(WizardHandler handler) {
        this.mNameTf = new JTextField(((Favorite)handler.getCurrentValue()).getName());
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("5dlu, default, 3dlu, default:grow", "default"));
        panelBuilder.border(Borders.DLU4);
        panelBuilder.labelAdd(LOCALIZER.msg("saveAs", "Save as:"), 2);
        panelBuilder.add(this.mNameTf, 4);
        JPanel panel = panelBuilder.getPanel();
        panel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                RenameWizardStep.this.mNameTf.requestFocusInWindow();
            }
        });
        return panel;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 3, 1};
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "name");
    }

    @Override
    public Object createDataObject(Object obj) {
        ((Favorite)obj).setName(this.mNameTf.getText());
        return obj;
    }

    @Override
    public WizardStep next() {
        return new FinishWizardStep(this);
    }

    @Override
    public WizardStep back() {
        return this.mCaller;
    }

    @Override
    public boolean isValid() {
        String name = this.mNameTf.getText();
        return name != null && name.trim().length() > 0;
    }
}

