/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import java.awt.Window;
import tvbrowser.extras.favoritesplugin.wizards.WizardDlg;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.ui.UiUtilities;

public class WizardHandler {
    private Window mParent;
    private WizardStep mStep;
    private WizardDlg mWizardDialog;
    private boolean mAllowNext;
    private boolean mAllowFinish;

    public WizardHandler(Window parent, WizardStep initialStep) {
        this.mParent = parent;
        this.mStep = initialStep;
        this.mAllowNext = true;
        this.mAllowFinish = true;
    }

    public Object show() {
        WizardStep currentStep = this.mStep;
        Object obj = null;
        this.mWizardDialog = new WizardDlg(this.mParent, this, currentStep);
        this.changeDoneBtnText();
        this.allowNext(this.mAllowNext);
        this.allowFinish(this.mAllowFinish);
        UiUtilities.centerAndShow(this.mWizardDialog);
        int result = this.mWizardDialog.getResult();
        if (result == 2) {
            obj = this.mWizardDialog.getDataObject();
        }
        this.mWizardDialog.dispose();
        this.mWizardDialog = null;
        return obj;
    }

    public Object getCurrentValue() {
        if (this.mWizardDialog != null) {
            return this.mWizardDialog.getDataObject();
        }
        return null;
    }

    public void allowNext(boolean allow) {
        this.mAllowNext = allow;
        if (this.mWizardDialog != null) {
            this.mWizardDialog.allowNext(allow);
        }
    }

    public void allowFinish(boolean allow) {
        this.mAllowFinish = allow;
        if (this.mWizardDialog != null) {
            this.mWizardDialog.allowFinish(allow);
        }
    }

    public void allowCancel(boolean allow) {
        if (this.mWizardDialog != null) {
            this.mWizardDialog.allowCancel(allow);
        }
    }

    public void finishWithCurrentStep() {
        if (this.mWizardDialog != null) {
            this.mWizardDialog.finish();
        }
    }

    public void closeCurrentStep() {
        if (this.mWizardDialog != null) {
            this.mWizardDialog.close();
        }
    }

    public void changeDoneBtnText() {
        if (this.mWizardDialog != null) {
            this.mWizardDialog.setDoneBtnText();
        }
    }

    public WizardDlg getDialog() {
        return this.mWizardDialog;
    }
}

