/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.l2fprod.common.swing.JLinkButton;
import com.l2fprod.common.swing.JTaskPaneGroup;
import devplugin.ActionMenu;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import util.ui.UIThreadRunner;
import util.ui.findasyoutype.TextComponentFindAction;

public class TaskMenuAction {
    private Action mAction;
    private ProgramInfoDialog mInfo;
    private TextComponentFindAction mFind;

    public TaskMenuAction(JTaskPaneGroup parent, Program program, ActionMenu menu, ProgramInfoDialog info, String id, TextComponentFindAction comp, HashSet<Integer> disabled) {
        this.mInfo = info;
        this.mFind = comp;
        if (!(menu.getAction() != null && menu.getAction().getValue("DISABLED_ON_TASK_MENU") != null && ((Boolean)menu.getAction().getValue("DISABLED_ON_TASK_MENU")).booleanValue() || menu.getActionId() != -1 && disabled != null && disabled.contains(menu.getActionId()))) {
            if (!menu.hasSubItems()) {
                this.addAction(parent, menu);
            } else {
                ActionMenu childMenu = this.getSingleActiveChild(menu);
                if (childMenu != null) {
                    if (id.contains("WebPlugin")) {
                        childMenu.getAction().putValue("Name", menu.getAction().getValue("Name"));
                    }
                    childMenu.getAction().putValue("SmallIcon", menu.getAction().getValue("SmallIcon"));
                    this.addAction(parent, childMenu);
                } else {
                    this.addTaskPaneGroup(parent, program, menu, info, id, disabled);
                }
            }
        }
    }

    private ActionMenu getSingleActiveChild(ActionMenu menu) {
        int count = 0;
        ActionMenu result = null;
        for (int i = 0; i < menu.getSubItems().length; ++i) {
            ActionMenu subItem = menu.getSubItems()[i];
            if (subItem.getAction().getValue("DISABLED_ON_TASK_MENU") != null) continue;
            ++count;
            result = subItem;
        }
        if (count == 1) {
            return result;
        }
        return null;
    }

    private void addAction(JTaskPaneGroup parent, ActionMenu menu) {
        Component c;
        final Action a = menu.getAction();
        this.mAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                a.actionPerformed(e);
                if (TaskMenuAction.this.mAction.getValue("ActionCommandKey") == null || !TaskMenuAction.this.mAction.getValue("ActionCommandKey").equals("action")) {
                    TaskMenuAction.this.mInfo.addPluginActions(true);
                }
            }
        };
        this.mAction.putValue("Name", "<html>" + a.getValue("Name") + "</html>");
        this.mAction.putValue("ActionCommandKey", a.getValue("ActionCommandKey"));
        this.mAction.putValue("SmallIcon", a.getValue("SmallIcon"));
        if (ContextMenuSeparatorAction.getInstance().equals(menu.getAction())) {
            parent.add(Box.createRigidArea(new Dimension(0, 2)));
            c = parent.add((Component)new JSeparator());
            parent.add(Box.createRigidArea(new Dimension(0, 2)));
        } else {
            c = parent.add(this.mAction);
        }
        if (menu.isSelected()) {
            try {
                Method m = c.getClass().getMethod("getFont", new Class[0]);
                Font font = (Font)m.invoke((Object)c, new Object[0]);
                m = c.getClass().getMethod("setFont", Font.class);
                m.invoke((Object)c, font.deriveFont(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mFind.installKeyListener(c);
        if (c instanceof JLinkButton) {
            c.setForeground(UIManager.getColor("List.foreground"));
            ((JLinkButton)c).setVerticalTextPosition(1);
            ((JLinkButton)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    private void addTaskPaneGroup(JTaskPaneGroup parent, Program program, final ActionMenu menu, ProgramInfoDialog info, final String id, HashSet<Integer> disabled) {
        ActionMenu[] subs = menu.getSubItems();
        final JTaskPaneGroup group = new JTaskPaneGroup();
        group.setTitle((String)menu.getAction().getValue("Name"));
        boolean expanded = ProgramInfo.getInstance().getSettings().getExpanded(id + "_" + (String)menu.getAction().getValue("Name"));
        group.setExpanded(expanded);
        if (Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiTimeBlock") || Settings.ProgramTable.STYLE_BACKGROUND.getString().equals("uiColor")) {
            ((JComponent)((JComponent)((JComponent)group.getComponent(0)).getComponent(0)).getComponent(0)).setBackground(UIManager.getColor("List.background"));
        }
        group.setEnabled(true);
        this.mFind.installKeyListener((Component)group);
        group.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProgramInfo.getInstance().getSettings().setExpanded(id + "_" + (String)menu.getAction().getValue("Name"), group.isExpanded());
            }
        });
        if (menu.getAction().getValue("SmallIcon") != null) {
            group.setIcon((Icon)menu.getAction().getValue("SmallIcon"));
        }
        if (expanded) {
            for (ActionMenu subMenu : subs) {
                new TaskMenuAction(group, program, subMenu, info, id, this.mFind, disabled);
            }
        } else {
            UIThreadRunner.invokeLater(() -> {
                for (ActionMenu subMenu : subs) {
                    new TaskMenuAction(group, program, subMenu, info, id, this.mFind, disabled);
                }
            });
        }
        parent.add(Box.createRigidArea(new Dimension(0, 10)));
        parent.add((Component)group);
        parent.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    protected void setText(String value) {
        this.mAction.putValue("Name", "<html>" + value + "</html>");
    }
}

