/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;

public class MinutesCellRenderer
extends DefaultTableCellRenderer {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MinutesCellRenderer.class);
    private JPanel mPanel = new JPanel((LayoutManager)new FormLayout("3dlu,default,default:grow,default,2dlu", "0dlu:grow,default,2dlu,default,0dlu:grow"));
    private JLabel mTextLabel;
    private JLabel mIconLabel;
    private JLabel mNoteLabel;
    private JPanel mDateSeparator;

    public MinutesCellRenderer() {
        CellConstraints cc = new CellConstraints();
        this.mTextLabel = new JLabel();
        this.mTextLabel.setOpaque(false);
        this.mIconLabel = new JLabel(TVBrowserIcons.edit(16));
        this.mNoteLabel = new JLabel("");
        this.mPanel.add((Component)this.mTextLabel, cc.xy(2, 2));
        this.mPanel.add((Component)this.mIconLabel, cc.xy(4, 2));
        this.mPanel.add((Component)this.mNoteLabel, cc.xy(2, 4));
        this.mDateSeparator = new JPanel((LayoutManager)new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,default,5dlu"));
        this.mDateSeparator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component def = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof ReminderListItem) {
            ReminderListItem listItem = (ReminderListItem)value;
            if (listItem.getProgram().equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                def = this.mDateSeparator;
            } else {
                Integer minutes = listItem.getMinutes();
                this.mTextLabel.setText(ReminderConstants.getStringForMinutes(minutes));
                this.mPanel.setOpaque(def.isOpaque());
                this.mPanel.setBackground(def.getBackground());
                String comment = listItem.getComment();
                if (comment != null && !comment.isEmpty()) {
                    this.mNoteLabel.setVisible(true);
                    this.mNoteLabel.setText(mLocalizer.msg("note", "Note: {0}", comment));
                    this.mNoteLabel.setOpaque(def.isOpaque());
                    this.mNoteLabel.setForeground(def.getForeground());
                    this.mNoteLabel.setBackground(def.getBackground());
                } else {
                    this.mNoteLabel.setVisible(false);
                }
                def = this.mPanel;
            }
        }
        return def;
    }
}

