/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.FrameReminders;
import tvbrowser.extras.reminderplugin.MinutesCellEditor;
import tvbrowser.extras.reminderplugin.MinutesCellRenderer;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderTableModel;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.programkeyevent.ProgramKeyAndContextMenuListener;
import util.programkeyevent.ProgramKeyEventHandler;
import util.programmouseevent.ProgramMouseAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.PluginPictureSettings;
import util.ui.ProgramList;
import util.ui.ProgramTableCellRenderer;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.TabListenerPanel;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;

public class ReminderListPanel
extends TabListenerPanel
implements PersonaListener,
ProgramMouseAndContextMenuListener {
    private static final Localizer mLocalizer = ReminderListDialog.mLocalizer;
    private JButton mUndo;
    private JButton mDelete;
    private JButton mSend;
    private JButton mScrollToPreviousDay;
    private JButton mScrollToNextDay;
    private ReminderList mReminderList;
    private JTable mTable;
    private ReminderTableModel mModel;
    private RevertCache<ReminderListItem[]> mRevertCache;
    private JComboBox<String> mTitleSelection;
    private JLabel mFilterLabel;
    private long mLastEditorClosing = 0L;
    private JScrollPane tableScroll;
    public static final int SCROLL_TO_DATE_TYPE = 0;
    public static final int SCROLL_TO_NOW_TYPE = 1;
    public static final int SCROLL_TO_NEXT_TIME_TYPE = 2;
    public static final int SCROLL_TO_TIME_TYPE = 3;

    public ReminderListPanel(ReminderList list, JButton close) {
        this.mReminderList = list;
        this.createGui(close);
    }

    private void createGui(JButton close) {
        FormLayout layout = new FormLayout("default,5dlu,50dlu:grow", "default,5dlu,fill:default:grow");
        this.setLayout((LayoutManager)layout);
        this.setOpaque(false);
        if (close == null) {
            this.setBorder(Borders.DLU4);
        }
        CellConstraints cc = new CellConstraints();
        this.mRevertCache = new RevertCache(3);
        this.mTitleSelection = new JComboBox<String>();
        this.mModel = new ReminderTableModel(this.mReminderList, this.mTitleSelection);
        this.mTable = new JTable();
        this.setDefaultFocusOwner(this.mTable);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selection;
                if (!e.getValueIsAdjusting() && (selection = ReminderListPanel.this.mTable.getSelectedRows()).length == 1) {
                    SwingUtilities.invokeLater(() -> {
                        Rectangle r = ReminderListPanel.this.mTable.getCellRect(selection[0], 0, false);
                        ReminderListPanel.this.mTable.scrollRectToVisible(r);
                    });
                }
            }
        });
        this.mTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
                    ReminderListPanel.this.mTable.getRootPane().dispatchEvent(e);
                }
            }
        });
        ProgramMouseEventHandler mouseEventHandler = new ProgramMouseEventHandler(this, ReminderPluginProxy.getInstance()){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ReminderListPanel.this.mTable.rowAtPoint(e.getPoint());
                int[] rows = ReminderListPanel.this.mTable.getSelectedRows();
                if (ReminderListPanel.this.mTable.getValueAt(row, 0).equals(PluginManagerImpl.getInstance().getExampleProgram()) && rows.length <= 1) {
                    ReminderListPanel.this.mTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                } else {
                    int column = ReminderListPanel.this.mTable.columnAtPoint(e.getPoint());
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && column == 1) {
                        ReminderListPanel.this.mTable.editCellAt(row, column);
                        ((MinutesCellEditor)ReminderListPanel.this.mTable.getCellEditor()).getComboBox().addPopupMenuListener(new PopupMenuListener(){

                            @Override
                            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                            }

                            @Override
                            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                ReminderListPanel.this.mLastEditorClosing = System.currentTimeMillis();
                            }

                            @Override
                            public void popupMenuCanceled(PopupMenuEvent e) {
                            }
                        });
                        ((MinutesCellEditor)ReminderListPanel.this.mTable.getCellEditor()).getComboBox().showPopup();
                    } else {
                        super.mouseClicked(e);
                    }
                    ReminderListPanel.this.mTable.repaint();
                }
            }
        };
        this.mTable.addMouseListener(mouseEventHandler);
        this.mTable.addKeyListener(new ProgramKeyEventHandler(new ProgramKeyAndContextMenuListener(){

            @Override
            public void showContextMenu(Program program) {
                Rectangle rect = ReminderListPanel.this.mTable.getCellRect(ReminderListPanel.this.mTable.getSelectedRow(), 0, false);
                Point p = new Point((int)((double)rect.x + (double)(rect.width * 1) / 4.0) + 15, (int)((double)rect.y + (double)(rect.height * 2) / 3.0) + 15);
                ReminderListPanel.this.showContextMenu(p);
            }

            @Override
            public void keyEventActionFinished() {
            }

            @Override
            public Program getProgramForKeyEvent(KeyEvent e) {
                int row = ReminderListPanel.this.mTable.getSelectedRow();
                Program p = (Program)ReminderListPanel.this.mTable.getModel().getValueAt(row, 0);
                if (p != null && !p.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                    return p;
                }
                return null;
            }
        }, ReminderPluginProxy.getInstance()));
        this.installTableModel(this.mModel);
        UiUtilities.addKeyRotation(this.mTable, index -> {
            if (index >= 0 && index < this.mTable.getRowCount()) {
                return (Program)this.mTable.getValueAt(index, 0);
            }
            return null;
        });
        this.mFilterLabel = new JLabel(mLocalizer.msg("titleFilterText", "Show only programs with the following title:"));
        this.add((Component)this.mFilterLabel, cc.xy(1, 1));
        this.add(this.mTitleSelection, cc.xy(3, 1));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRight(true);
        JButton config = new JButton(TVBrowserIcons.preferences(16));
        config.setToolTipText(mLocalizer.msg("config", "Configure Reminder"));
        config.addActionListener(e -> MainFrame.getInstance().showSettingsDialog("#reminder"));
        if (close != null) {
            builder.addFixed((JComponent)config);
            builder.addRelatedGap();
        }
        this.mSend = new JButton(TVBrowserIcons.copy(16));
        this.mSend.setToolTipText(mLocalizer.msg("send", "Send to other Plugins"));
        this.mSend.setEnabled(this.mTable.getRowCount() > 0);
        this.mSend.addActionListener(e -> this.showSendDialog());
        builder.addFixed((JComponent)this.mSend);
        builder.addRelatedGap();
        this.mDelete = new JButton(TVBrowserIcons.delete(16));
        this.mDelete.setToolTipText(mLocalizer.msg("delete", "Remove all/selected programs from reminder list"));
        this.mDelete.setEnabled(this.mTable.getRowCount() > 0);
        this.mDelete.addActionListener(e -> this.deleteItems());
        builder.addFixed((JComponent)this.mDelete);
        builder.addRelatedGap();
        this.mUndo = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "edit-undo", 16));
        this.mUndo.setToolTipText(mLocalizer.msg("undo", "Undo"));
        this.mUndo.setEnabled(false);
        this.mUndo.addActionListener(e -> this.undo());
        builder.addFixed((JComponent)this.mUndo);
        this.mScrollToPreviousDay = new JButton(TVBrowserIcons.left(16));
        this.mScrollToPreviousDay.setToolTipText(ProgramList.getPreviousActionTooltip());
        this.mScrollToPreviousDay.setEnabled(this.mTable.getRowCount() > 0);
        this.mScrollToPreviousDay.addActionListener(e -> {
            int row = this.mTable.rowAtPoint(this.mTable.getVisibleRect().getLocation()) - 1;
            if (row > 0) {
                Object o = this.mTable.getValueAt(row, 0);
                if (o.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                    o = this.mTable.getValueAt(row - 1, 0);
                    --row;
                }
                if (row > 0) {
                    Date current = ((Program)o).getDate();
                    for (int i = row - 1; i >= 0; --i) {
                        Object test = this.mTable.getValueAt(i, 0);
                        if (test.equals(PluginManagerImpl.getInstance().getExampleProgram()) || !(test instanceof Program) || current.compareTo(((Program)test).getDate()) <= 0) continue;
                        this.mTable.scrollRectToVisible(this.mTable.getCellRect(i + 1, 0, true));
                        return;
                    }
                }
            }
            if (this.mTable.getRowCount() > 0) {
                this.mTable.scrollRectToVisible(this.mTable.getCellRect(0, 0, true));
            }
        });
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)this.mScrollToPreviousDay);
        this.mScrollToNextDay = new JButton(TVBrowserIcons.right(16));
        this.mScrollToNextDay.setToolTipText(ProgramList.getNextActionTooltip());
        this.mScrollToNextDay.setEnabled(this.mTable.getRowCount() > 0);
        this.mScrollToNextDay.addActionListener(e -> {
            int row = this.mTable.rowAtPoint(this.mTable.getVisibleRect().getLocation());
            if (row < this.mTable.getRowCount() - 1) {
                Object o = this.mTable.getValueAt(row, 0);
                if (o.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                    o = this.mTable.getValueAt(row + 1, 0);
                    ++row;
                }
                if (row < this.mTable.getRowCount() - 1) {
                    Date current = ((Program)o).getDate();
                    for (int i = row + 1; i < this.mTable.getRowCount(); ++i) {
                        Object test = this.mTable.getValueAt(i, 0);
                        if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) >= 0) continue;
                        Rectangle rect = this.mTable.getCellRect(i - (ReminderPlugin.getInstance().showDateSeparators() ? 1 : 0), 0, true);
                        rect.setSize(rect.width, this.mTable.getVisibleRect().height);
                        this.mTable.scrollRectToVisible(rect);
                        return;
                    }
                }
            }
        });
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.mScrollToNextDay);
        if (close != null) {
            builder.addUnrelatedGap();
            builder.addGlue();
            builder.addFixed((JComponent)close);
        }
        builder.getPanel().setOpaque(false);
        this.tableScroll = new JScrollPane(this.mTable);
        this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
        this.tableScroll.setBackground(UIManager.getColor("TextField.background"));
        this.tableScroll.getViewport().setBackground(UIManager.getColor("TextField.background"));
        if (close != null) {
            layout.appendRow(RowSpec.decode((String)"3dlu"));
            layout.appendRow(RowSpec.decode((String)"default"));
            this.add((Component)this.tableScroll, cc.xyw(1, 3, 3));
            this.add((Component)builder.getPanel(), cc.xyw(1, 5, 3));
        } else {
            layout.appendColumn(ColumnSpec.decode((String)"5dlu"));
            layout.appendColumn(ColumnSpec.decode((String)"default"));
            this.add((Component)this.tableScroll, cc.xyw(1, 3, 5));
            this.add((Component)builder.getPanel(), cc.xy(5, 1));
        }
    }

    private void installTableModel(ReminderTableModel model) {
        DefaultTableColumnModel cModel = new DefaultTableColumnModel(){

            @Override
            public TableColumn getColumn(int n) {
                TableColumn column = super.getColumn(n);
                if (n == 1) {
                    column.setMaxWidth(ReminderListPanel.this.mTable.getFontMetrics(ReminderListPanel.this.mTable.getFont()).stringWidth(ReminderConstants.REMIND_AFTER_VALUE_ARR[ReminderConstants.REMIND_AFTER_VALUE_ARR.length - 1].toString()) + 20);
                    column.setPreferredWidth(column.getMaxWidth());
                }
                return column;
            }
        };
        this.mTable.setColumnModel(cModel);
        this.mTable.setModel(model);
        this.mTable.setSelectionBackground(Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getColor());
        final ProgramTableCellRenderer backend = new ProgramTableCellRenderer(new PluginPictureSettings(0));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private JPanel mDateSeparator;
            private JLabel mDateLabel;

            public void initialize() {
                this.mDateSeparator = new JPanel((LayoutManager)new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,min,5dlu"));
                this.mDateSeparator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
                this.mDateLabel = new JLabel();
                this.mDateLabel.setFont(this.mDateLabel.getFont().deriveFont(this.mDateLabel.getFont().getSize2D() + 4.0f).deriveFont(1));
                this.mDateSeparator.add((Component)this.mDateLabel, new CellConstraints().xy(2, 2));
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = backend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    if (value instanceof Program && value.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                        this.mDateLabel.setText(((Program)table.getModel().getValueAt(row + 1, 0)).getDateString());
                        if (table.getModel().getRowCount() > row + 1 && table.getRowHeight(row) != this.mDateSeparator.getPreferredSize().height) {
                            table.setRowHeight(row, this.mDateSeparator.getPreferredSize().height);
                        }
                        c = this.mDateSeparator;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return c;
            }
        };
        try {
            Method initialize = renderer.getClass().getDeclaredMethod("initialize", new Class[0]);
            initialize.invoke((Object)renderer, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(new MinutesCellEditor());
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(new MinutesCellRenderer());
        this.updateButtons();
        SwingUtilities.invokeLater(() -> {
            try {
                this.mTable.updateUI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void deleteItems() {
        int[] selected = this.mTable.getSelectedRows();
        if (selected.length < 1 && this.mTable.getRowCount() > 0) {
            this.mTable.getSelectionModel().setSelectionInterval(0, this.mTable.getRowCount() - 1);
            selected = this.mTable.getSelectedRows();
        }
        boolean frameReminders = ReminderPlugin.getInstance().getSettings().isSet("showFrameReminders");
        if (selected.length > 0) {
            Arrays.sort(selected);
            ArrayList<ReminderListItem> itemList = new ArrayList<ReminderListItem>();
            for (int element : selected) {
                Program prog = (Program)this.mTable.getValueAt(element, 0);
                ReminderListItem item = this.mReminderList.removeWithoutChecking(prog);
                if (frameReminders) {
                    FrameReminders.getInstance().removeReminder(item);
                }
                if (item == null) continue;
                itemList.add(item);
            }
            this.mRevertCache.push(itemList.toArray(new ReminderListItem[itemList.size()]));
            int row = selected[0] - 1;
            this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
            SwingUtilities.invokeLater(() -> this.mTable.scrollRectToVisible(this.mTable.getCellRect(row, 0, true)));
            ReminderPlugin.getInstance().updateRootNode(true, false);
        }
        this.updateButtons();
    }

    private void undo() {
        for (ReminderListItem item : this.mRevertCache.pop()) {
            this.mReminderList.addWithoutChecking(item);
            item.getProgram().mark(ReminderPluginProxy.getInstance());
        }
        this.mUndo.setEnabled(!this.mRevertCache.isEmpty());
        this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
        ReminderPlugin.getInstance().updateRootNode(true);
        this.updateButtons();
    }

    private void showSendDialog() {
        Program[] programArr;
        int[] rows = this.mTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            ReminderListItem[] items = this.mReminderList.getReminderItems();
            programArr = new Program[items.length];
            for (int i = 0; i < items.length; ++i) {
                programArr[i] = items[i].getProgram();
            }
        } else {
            ArrayList<Program> programs = new ArrayList<Program>();
            for (int row : rows) {
                Program test = (Program)this.mTable.getValueAt(row, 0);
                if (test.equals(PluginManagerImpl.getInstance().getExampleProgram())) continue;
                programs.add(test);
            }
            programArr = programs.toArray(new Program[programs.size()]);
        }
        if (programArr.length > 0) {
            SendToPluginDialog send = new SendToPluginDialog(ReminderPluginProxy.getInstance(), ReminderListDialog.getInstance() != null ? ReminderListDialog.getInstance() : MainFrame.getInstance(), programArr);
            send.setVisible(true);
        }
    }

    void stopCellEditing() {
        if (this.mTable.isEditing()) {
            this.mTable.getCellEditor().stopCellEditing();
        }
    }

    public void installTableModel(boolean scroll) {
        this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
        if (scroll) {
            SwingUtilities.invokeLater(() -> this.mTable.scrollRectToVisible(new Rectangle(0, 0)));
        }
    }

    void updateTableEntries() {
        this.mModel.updateTableEntries();
        this.updateButtons();
        if (this.tableScroll != null) {
            this.tableScroll.getViewport().getSize();
        }
    }

    private void updateButtons() {
        if (this.mDelete != null) {
            this.mDelete.setEnabled(this.mTable.getRowCount() > 0);
            this.mSend.setEnabled(this.mTable.getRowCount() > 0);
            this.mScrollToPreviousDay.setEnabled(this.mTable.getRowCount() > 0);
            this.mScrollToNextDay.setEnabled(this.mTable.getRowCount() > 0);
            this.mUndo.setEnabled(!this.mRevertCache.isEmpty());
        }
    }

    @Override
    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.mFilterLabel.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.mFilterLabel.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    @Override
    public Program getProgramForMouseEvent(MouseEvent e) {
        int column = this.mTable.columnAtPoint(e.getPoint());
        if (column == 0 && this.mLastEditorClosing + (long)Plugin.SINGLE_CLICK_WAITING_TIME + 50L < System.currentTimeMillis()) {
            int row = this.mTable.rowAtPoint(e.getPoint());
            Program p = (Program)this.mTable.getModel().getValueAt(row, 0);
            if (p != null && !p.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                return p;
            }
        }
        return null;
    }

    @Override
    public void mouseEventActionFinished() {
    }

    @Override
    public void showContextMenu(MouseEvent e) {
        this.showContextMenu(e.getPoint());
    }

    private void showContextMenu(Point point) {
        int row = this.mTable.rowAtPoint(point);
        this.mTable.changeSelection(row, 0, false, false);
        Program p = (Program)this.mTable.getModel().getValueAt(row, 0);
        if (p != null && !p.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            JPopupMenu menu = PluginManagerImpl.getInstance().createPluginContextMenu(p, ReminderPluginProxy.getInstance(), ReminderPlugin.getInstance().getDeleteMenu(p));
            UiUtilities.registerForClosing(menu);
            menu.show(this.mTable, point.x - 15, point.y - 15);
        }
    }

    public void scrollTo(int type, Date date, int time) {
        Program test;
        int row;
        Program example = PluginManagerImpl.getInstance().getExampleProgram();
        int startRow = 0;
        int rowTime = -1;
        if (date == null && (row = this.mTable.rowAtPoint(this.mTable.getVisibleRect().getLocation())) < this.mTable.getRowCount()) {
            test = null;
            do {
                Object o;
                if (!((o = this.mTable.getValueAt(row, 0)) instanceof Program)) continue;
                test = (Program)this.mTable.getValueAt(row, 0);
            } while (test != null && test.equals(example) && ++row < this.mTable.getRowCount());
            if (test != null) {
                date = test.getDate();
                if (type == 2) {
                    startRow = row - 1;
                    rowTime = test.getStartTime();
                }
            }
        }
        for (int i = startRow; i < this.mTable.getRowCount(); ++i) {
            test = (Program)this.mTable.getValueAt(i, 0);
            if (!(test instanceof Program) || test.equals(example)) continue;
            boolean condition = false;
            int sub = 0;
            switch (type) {
                case 0: {
                    condition = date.compareTo(test.getDate()) == 0;
                    break;
                }
                case 1: {
                    condition = !test.isExpired();
                    break;
                }
                case 2: {
                    condition = (test.getDate().compareTo(date) == 0 && test.getStartTime() >= time && rowTime < time || test.getDate().compareTo(date) > 0 && test.getStartTime() >= time) && rowTime != time;
                    break;
                }
                case 3: {
                    boolean bl = condition = test.getDate().compareTo(date) == 0 && test.getStartTime() >= time || test.getDate().compareTo(date) > 0;
                    if (!condition || test.getStartTime() <= time && test.getDate().compareTo(date) <= 0) break;
                    sub = 1;
                }
            }
            if (!condition) continue;
            int add = 0;
            if (i > 0 && ((Program)this.mTable.getValueAt(i - 1, 0)).equals(example)) {
                add = 1;
            }
            Rectangle rect = this.mTable.getCellRect(i - add - sub, 0, true);
            rect.setSize(rect.width, this.mTable.getVisibleRect().height);
            SwingUtilities.invokeLater(() -> this.mTable.scrollRectToVisible(rect));
            return;
        }
    }

    private class RevertCache<E> {
        private ArrayList<E> mStackList;
        private int mSize;

        public RevertCache(int size) {
            this.mSize = size;
            this.mStackList = new ArrayList(size);
        }

        public void push(E value) {
            if (this.mStackList.size() >= this.mSize) {
                this.mStackList.remove(0);
            }
            this.mStackList.add(value);
        }

        public E pop() {
            if (this.mStackList.size() < 1) {
                return null;
            }
            return this.mStackList.remove(this.mStackList.size() - 1);
        }

        public boolean isEmpty() {
            return this.mStackList.isEmpty();
        }
    }
}

