/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.toolbar;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.Date;
import devplugin.ProgressMonitor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.filter.dlgs.FilterButtons;
import tvbrowser.ui.filter.dlgs.FilterComponentsDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.MenuBar;
import tvbrowser.ui.mainframe.actions.TVBrowserAction;
import tvbrowser.ui.mainframe.toolbar.ContextMenu;
import tvbrowser.ui.mainframe.toolbar.DefaultToolBarModel;
import tvbrowser.ui.mainframe.toolbar.ToolBarModel;
import tvbrowser.ui.settings.ToolBarDragAndDropSettings;
import util.i18n.Localizer;
import util.ui.ChannelContextMenu;
import util.ui.PopupButton;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class ToolBar
extends JToolBar {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ToolBar.class);
    private static final Logger LOG = Logger.getLogger(ToolBar.class.getName());
    public static final String ACTION_VALUE = "ActionValue";
    public static final String ACTION_TYPE_KEY = "ActionType";
    public static final String ACTION_ID_KEY = "ActionId";
    public static final String ACTION_IS_SELECTED = "ActionIsSelected";
    public static final int BUTTON_ACTION = 0;
    public static final int TOOGLE_BUTTON_ACTION = 1;
    protected static final int SEPARATOR = 2;
    protected static final int SPACE = 3;
    protected static final int GLUE = 4;
    public static final int STYLE_TEXT = 1;
    public static final int STYLE_ICON = 2;
    private static final int ICON_BIG = 1;
    private static final int ICON_SMALL = 2;
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    protected static final Font TEXT_FONT = new Font("Dialog", 0, 10);
    private ToolBarModel mModel;
    private ContextMenu mContextMenu;
    private int mStyle;
    private int mIconSize;
    private String mLocation;
    private boolean disabled = false;
    private JButton mUpdateButton = null;
    private JLabel mStatusLabel;

    public ToolBar(ToolBarModel model, JLabel statusLabel) {
        this.mStatusLabel = statusLabel;
        this.mModel = model;
        this.loadSettings();
        this.mContextMenu = new ContextMenu(this);
        this.setFloatable(false);
        this.update();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ToolBar.this.mContextMenu.show(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ToolBar.this.mContextMenu.show(e.getX(), e.getY());
                }
            }
        });
    }

    public void updatePluginButtons() {
        ((DefaultToolBarModel)this.mModel).updatePluginButtons();
        this.update();
    }

    public void updateTimeButtons() {
        ((DefaultToolBarModel)this.mModel).updateTimeButtons();
        this.update();
    }

    public void updateUpdateButton(boolean showStopButton) {
        if (showStopButton) {
            ((DefaultToolBarModel)this.mModel).showStopButton();
        } else {
            ((DefaultToolBarModel)this.mModel).showUpdateButton();
        }
        if (this.mUpdateButton != null) {
            this.mUpdateButton.removeActionListener(this.mUpdateButton.getActionListeners()[0]);
            this.addButtonProperties(this.mUpdateButton, ((DefaultToolBarModel)this.mModel).getUpdateAction());
        }
    }

    public void update() {
        Action[] actions;
        super.removeAll();
        this.mUpdateButton = null;
        for (Action action : actions = this.mModel.getActions()) {
            Integer typeInteger = (Integer)action.getValue(ACTION_TYPE_KEY);
            int type = -1;
            if (typeInteger != null) {
                type = typeInteger;
            }
            if (type == 1) {
                this.addToggleButton(action);
                continue;
            }
            if (type == 2) {
                this.add(new ToolBarSeparatorPanel());
                continue;
            }
            if (type == 4) {
                JPanel gluePanel = new JPanel();
                gluePanel.setOpaque(false);
                gluePanel.setBorder(BorderFactory.createEmptyBorder());
                gluePanel.setAlignmentX(0.5f);
                this.add(gluePanel);
                continue;
            }
            if (type == 3) {
                JPanel spacePanel = new JPanel();
                spacePanel.setOpaque(false);
                spacePanel.setBorder(BorderFactory.createEmptyBorder());
                spacePanel.setAlignmentX(0.5f);
                int height = this.mLocation.equals("North") ? this.getPreferredSize().height : 20;
                spacePanel.setPreferredSize(new Dimension(20, height));
                spacePanel.setMaximumSize(new Dimension(20, height));
                spacePanel.setMinimumSize(new Dimension(20, height));
                this.add(spacePanel);
                continue;
            }
            this.addButton(action);
        }
        this.updateUI();
        if (Persona.getInstance().getHeaderImage() != null) {
            this.setOpaque(false);
        }
        this.disabled = false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.mLocation != null) {
            if (this.mLocation.equals("North")) {
                super.setLayout(new BoxLayout(this, 0));
            } else {
                super.setLayout(new BoxLayout(this, 1));
            }
        }
    }

    public void disableForDragAndDrop(ToolBarDragAndDropSettings s, boolean west) {
        this.disabled = true;
        if (this.getComponentCount() == 0) {
            if (!west) {
                this.setPreferredSize(new Dimension(this.getWidth(), 15));
            } else {
                this.setPreferredSize(new Dimension(15, this.getHeight()));
            }
        }
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(12));
        int x = this.getComponentCount();
        for (int i = 0; i < x; ++i) {
            new DragSource().createDefaultDragGestureRecognizer(this.getComponent(i), 2, s);
            if (this.getComponent(i) instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)this.getComponent(i);
                b.setDisabledIcon(b.getIcon());
                b.setBorder(BorderFactory.createEmptyBorder(b.getInsets().top, b.getInsets().left, b.getInsets().bottom, b.getInsets().right));
                b.setEnabled(false);
            } else if (this.getComponent(i) instanceof JToolBar.Separator) {
                ((JToolBar.Separator)this.getComponent(i)).setBorder(BorderFactory.createLineBorder(this.getBackground().darker().darker().darker()));
            } else if (this.getComponent(i) instanceof JPanel) {
                JPanel filler = (JPanel)this.getComponent(i);
                filler.setSize(filler.getWidth(), 10);
                filler.setVisible(true);
                filler.setOpaque(true);
                filler.setBackground(filler.getBackground().brighter());
                filler.setBorder(BorderFactory.createLineBorder(this.getBackground().darker().darker().darker()));
            }
            this.getComponent(i).addMouseListener(s);
        }
    }

    private void addToggleButton(Action action) {
        final JToggleButton button = new JToggleButton(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                    if (UiUtilities.isGTKLookAndFeel()) {
                        if (this.isBorderPainted()) {
                            g.setColor(UIManager.getColor("List.selectionBackground"));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.isSelected()) {
                            g.draw3DRect(0, 0, this.getWidth(), this.getHeight(), false);
                        }
                    }
                    if (Settings.ToolBar.BUTTON_STYLE.getString().equals("text&icon")) {
                        this.getIcon().paintIcon(this, g, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getInsets().top);
                    }
                    if (Settings.ToolBar.BUTTON_STYLE.getString().contains("text")) {
                        FontMetrics metrics = g.getFontMetrics(this.getFont());
                        int textWidth = metrics.stringWidth(this.getText());
                        if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                            g.setColor(Persona.getInstance().getShadowColor());
                            g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 1, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 1);
                            g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 2);
                        }
                        g.setColor(Persona.getInstance().getTextColor());
                        g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top);
                    } else {
                        super.paintComponent(g);
                    }
                } else {
                    super.paintComponent(g);
                }
            }
        };
        button.setOpaque(false);
        button.setAlignmentX(0.5f);
        action.putValue(ACTION_VALUE, button);
        this.addButtonProperties(button, action);
        Boolean isSelected = (Boolean)action.getValue(ACTION_IS_SELECTED);
        if (isSelected != null) {
            button.setSelected(isSelected);
        }
        button.setBorderPainted(isSelected != null && isSelected != false);
        button.addChangeListener(e -> {
            if (!button.isFocusOwner() && button.getToolTipText() != null && button.getToolTipText().equals(this.mStatusLabel.getText())) {
                this.mStatusLabel.setText("");
            }
        });
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!button.isSelected()) {
                    button.setBorderPainted(true);
                }
                if (button.getToolTipText() != null && button.getToolTipText().trim().length() > 0) {
                    ToolBar.this.mStatusLabel.setText(button.getToolTipText());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!button.isSelected()) {
                    button.setBorderPainted(false);
                }
                if (button.getToolTipText() != null && button.getToolTipText().equals(ToolBar.this.mStatusLabel.getText())) {
                    ToolBar.this.mStatusLabel.setText("");
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && !ToolBar.this.disabled) {
                    ToolBar.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !ToolBar.this.disabled) {
                    ToolBar.this.showPopupMenu(e);
                }
            }
        });
        this.add(button);
    }

    private void addButton(final Action action) {
        final PopupButton button = new PopupButton(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                    if (this.isBorderPainted() && UiUtilities.isGTKLookAndFeel()) {
                        g.setColor(UIManager.getColor("List.selectionBackground"));
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (Settings.ToolBar.BUTTON_STYLE.getString().equals("text&icon")) {
                        this.getIcon().paintIcon(this, g, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getInsets().top);
                    }
                    if (Settings.ToolBar.BUTTON_STYLE.getString().contains("text")) {
                        FontMetrics metrics = g.getFontMetrics(this.getFont());
                        int textWidth = metrics.stringWidth(this.getText());
                        if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                            g.setColor(Persona.getInstance().getShadowColor());
                            g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 1, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 1);
                            g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2 + 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top + 2);
                        }
                        g.setColor(Persona.getInstance().getTextColor());
                        g.drawString(this.getText(), this.getWidth() / 2 - textWidth / 2, this.getHeight() - this.getInsets().bottom - this.getInsets().top);
                    } else {
                        super.paintComponent(g);
                    }
                } else {
                    super.paintComponent(g);
                }
            }
        };
        this.addButtonProperties(button, action);
        button.setBorderPainted(false);
        button.setAlignmentX(0.5f);
        action.putValue(ACTION_VALUE, button);
        if (action.equals(((DefaultToolBarModel)this.mModel).getUpdateAction())) {
            this.mUpdateButton = button;
            this.mUpdateButton.setOpaque(false);
        }
        button.addChangeListener(e -> {
            if (!button.isFocusOwner() && button.getToolTipText() != null && button.getToolTipText().equals(this.mStatusLabel.getText())) {
                this.mStatusLabel.setText("");
            }
        });
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBorderPainted(true);
                if (button.getToolTipText() != null && button.getToolTipText().trim().length() > 0) {
                    ToolBar.this.mStatusLabel.setText(button.getToolTipText());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBorderPainted(false);
                if (button.getToolTipText() != null && button.getToolTipText().equals(ToolBar.this.mStatusLabel.getText())) {
                    ToolBar.this.mStatusLabel.setText("");
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && !ToolBar.this.disabled) {
                    ToolBar.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !ToolBar.this.disabled) {
                    ToolBar.this.showPopupMenu(e);
                }
            }
        });
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    button.setEnabled(action.isEnabled());
                }
            }
        });
        this.add(button);
    }

    private void showPopupMenu(final MouseEvent e) {
        JMenuItem pluginMenu;
        JPopupMenu menu = new JPopupMenu();
        String label = LOCALIZER.ellipsisMsg("configure", "Configure");
        ActionMenu buttonAction = null;
        ButtonActionIf buttonActionIf = null;
        String name = null;
        boolean configItemEnabled = false;
        if (e.getSource() instanceof AbstractButton) {
            name = ((AbstractButton)e.getSource()).getName();
            if (name.startsWith("#scrollTo") && name.indexOf("Channel") == -1) {
                configItemEnabled = true;
                label = LOCALIZER.ellipsisMsg("configureTime", "Configure time buttons");
            } else if (name.startsWith("#filter")) {
                configItemEnabled = true;
                label = FilterButtons.LOCALIZER.ellipsisMsg("createFilter", "Create filter");
            } else if (name.startsWith("#scrollToChannel")) {
                configItemEnabled = true;
                label = ChannelContextMenu.LOCALIZER.ellipsisMsg("addChannels", "Add/Remove channels");
            } else if (name.indexOf("##") != -1) {
                String id = name.substring(0, name.indexOf("##"));
                PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId(id);
                if (plugin != null) {
                    buttonAction = plugin.getButtonAction();
                    configItemEnabled = plugin.getSettingsTab() != null;
                } else {
                    InternalPluginProxyIf internal = InternalPluginProxyList.getInstance().getProxyForId(id);
                    if (internal != null) {
                        if (internal instanceof ButtonActionIf) {
                            buttonAction = ((ButtonActionIf)((Object)internal)).getButtonAction();
                        }
                        configItemEnabled = true;
                        name = internal.getSettingsId();
                    }
                }
            } else if (PluginProxyManager.getInstance().getActivatedPluginForId(name) != null) {
                PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId(name);
                buttonAction = plugin.getButtonAction();
                configItemEnabled = plugin.getSettingsTab() != null;
            } else if (InternalPluginProxyList.getInstance().getProxyForId(name) != null) {
                InternalPluginProxyIf internal = InternalPluginProxyList.getInstance().getProxyForId(name);
                if (internal instanceof ButtonActionIf) {
                    buttonAction = ((ButtonActionIf)((Object)internal)).getButtonAction();
                }
                configItemEnabled = internal.getSettingsTab() != null;
                name = internal.getSettingsId();
            }
        } else {
            return;
        }
        if (Settings.ToolBar.PLUGIN_FUNCTIONS_IN_MENU_SHOW.getBoolean() && buttonAction != null && (pluginMenu = MenuBar.createMenuItem(buttonAction, buttonActionIf, MainFrame.getInstance().getStatusBarLabel())) != null) {
            menu.add(pluginMenu);
        }
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(name);
        item.setEnabled(configItemEnabled);
        item.addActionListener(e1 -> {
            if (e1.getActionCommand().startsWith("#scrollTo") && e1.getActionCommand().indexOf("Channel") == -1) {
                MainFrame.getInstance().showSettingsDialog("#timebuttons");
            } else if (e1.getActionCommand().startsWith("#filter")) {
                MainFrame.getInstance().showFilterDialog();
            } else if (e1.getActionCommand().startsWith("#scrollToChannel")) {
                MainFrame.getInstance().showSettingsDialog("#channels");
            } else if (e1.getActionCommand().indexOf("##") != -1) {
                MainFrame.getInstance().showSettingsDialog(e1.getActionCommand().substring(0, e1.getActionCommand().indexOf("##")));
            } else {
                MainFrame.getInstance().showSettingsDialog(e1.getActionCommand());
            }
        });
        menu.add(item);
        if (name.startsWith("#filter")) {
            item = new JMenuItem(FilterComponentsDlg.LOCALIZER.ellipsisMsg("title", "Edit filter components"));
            item.setActionCommand("#filterComponentEdit");
            item.addActionListener(e1 -> new FilterComponentsDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance())));
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem(LOCALIZER.msg("removeButton", "Remove button"));
        String buttonName = ((AbstractButton)e.getSource()).getName();
        item.addActionListener(e1 -> {
            Action[] actions = this.mModel.getActions();
            ArrayList<String> idList = new ArrayList<String>();
            for (Action a : actions) {
                String key = (String)a.getValue(ACTION_ID_KEY);
                String test = key;
                if (test.equals("searchplugin.SearchPlugin") && buttonName.equals("#search")) {
                    test = "#search";
                } else if (test.equals("reminderplugin.ReminderPlugin") && buttonName.equals("#reminder")) {
                    test = "#reminder";
                } else if (test.equals("favoritesplugin.FavoritesPlugin") && buttonName.equals("#favorite")) {
                    test = "#favorite";
                }
                if (test.compareTo(buttonName) == 0) continue;
                idList.add(key);
            }
            String[] ids = new String[idList.size()];
            idList.toArray(ids);
            DefaultToolBarModel.getInstance().setButtonIds(ids);
            MainFrame.getInstance().updateToolbar();
            Settings.ToolBar.BUTTONS.setStringArray(ids);
        });
        menu.add(item);
        menu.add(ContextMenu.getSubMenu());
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent pe) {
                if (e.getSource() instanceof AbstractButton) {
                    ((AbstractButton)e.getSource()).doClick();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
            }
        });
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addButtonProperties(AbstractButton button, Action action) {
        String tooltip = (String)action.getValue("ShortDescription");
        Icon icon = this.getIcon(action);
        String title = this.getTitle(action);
        if (Persona.getInstance().getHeaderImage() != null) {
            button.setOpaque(false);
        }
        button.addActionListener(e -> {
            action.actionPerformed(new ActionEvent(action, 1001, ""));
            MainFrame.getInstance().getProgramTableScrollPane().requestFocusInWindow();
        });
        button.setText(title);
        button.setIcon(icon);
        button.setName(action.getValue(ACTION_ID_KEY).toString());
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setFont(TEXT_FONT);
        button.setMargin(NULL_INSETS);
        button.setFocusPainted(false);
        button.setToolTipText(tooltip);
    }

    private String getTitle(Action action) {
        if ((this.mStyle & 1) == 1) {
            return (String)action.getValue("Name");
        }
        return null;
    }

    private Icon getIcon(Action action) {
        if ((this.mStyle & 2) == 2) {
            Icon icon;
            if (this.mIconSize == 1) {
                icon = (Icon)action.getValue("BigIcon");
                if (icon == null) {
                    LOG.warning("Big icon missing for action " + action.getValue("Name"));
                    icon = (Icon)action.getValue("SmallIcon");
                }
                if (!(icon == null || action.getValue("NoIconResize") != null && ((Boolean)action.getValue("NoIconResize")).booleanValue() || icon.getIconHeight() == 22 && icon.getIconWidth() == 22)) {
                    icon = UiUtilities.scaleIcon(icon, 22, 22);
                }
            } else {
                icon = (Icon)action.getValue("SmallIcon");
                if (!(icon == null || action.getValue("NoIconResize") != null && ((Boolean)action.getValue("NoIconResize")).booleanValue() || icon.getIconHeight() == 16 && icon.getIconWidth() == 16)) {
                    icon = UiUtilities.scaleIcon(icon, 16, 16);
                }
            }
            return icon;
        }
        return null;
    }

    public void setStyle(int style) {
        this.mStyle = style;
    }

    public int getStyle() {
        return this.mStyle;
    }

    private void loadSettings() {
        String styleStr = Settings.ToolBar.BUTTON_STYLE.getString();
        this.mStyle = "text".equals(styleStr) ? 1 : ("icon".equals(styleStr) ? 2 : 3);
        this.setUseBigIcons(Settings.ToolBar.BIG_ICONS_USE.getBoolean());
        String locationStr = Settings.ToolBar.LOCATION.getString();
        this.mLocation = null;
        this.mLocation = "west".equals(locationStr) ? "West" : "North";
        if (this.mLocation.equals("East") || this.mLocation.equals("West")) {
            this.setOrientation(1);
        } else {
            this.setOrientation(0);
        }
        this.setLayout(null);
    }

    public void storeSettings() {
        if (this.mStyle == 1) {
            Settings.ToolBar.BUTTON_STYLE.setString("text");
        } else if (this.mStyle == 2) {
            Settings.ToolBar.BUTTON_STYLE.setString("icon");
        } else {
            Settings.ToolBar.BUTTON_STYLE.setString("text&icon");
        }
        Settings.ToolBar.BIG_ICONS_USE.setBoolean(this.mIconSize == 1);
        if (this.mLocation == null) {
            Settings.ToolBar.LOCATION.setString("hidden");
        } else if (this.mLocation.equals("West")) {
            Settings.ToolBar.LOCATION.setString("west");
        } else {
            Settings.ToolBar.LOCATION.setString("north");
        }
    }

    public void setToolbarLocation(String location) {
        this.mLocation = location;
    }

    public String getToolbarLocation() {
        return this.mLocation;
    }

    public void setUseBigIcons(boolean arg) {
        this.mIconSize = arg ? 1 : 2;
    }

    public boolean useBigIcons() {
        return this.mIconSize == 1;
    }

    public void dateChanged(Date date, ProgressMonitor monitor, Runnable callback) {
        this.mModel.dateChanged(date, monitor, callback);
    }

    public void showPopupMenu(TVBrowserAction tvBrowserAction) {
        ((DefaultToolBarModel)this.mModel).showPopupMenu(tvBrowserAction);
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
        this.update();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!UiUtilities.isGTKLookAndFeel() || Persona.getInstance().getHeaderImage() == null) {
            super.paintComponent(g);
        }
    }

    private class ToolBarSeparatorPanel
    extends JPanel
    implements ContainerListener {
        public ToolBarSeparatorPanel() {
            this.initUI();
        }

        private ToolBar getToolBar() {
            return ToolBar.this;
        }

        private void initUI() {
            String toolbarLocation = this.getToolBar().getToolbarLocation();
            if ("North".equals(toolbarLocation)) {
                this.setLayout((LayoutManager)new FormLayout("0dlu:grow,default,0dlu:grow", "fill:default:grow"));
            } else {
                this.setLayout((LayoutManager)new FormLayout("default:grow", "0dlu:grow,default,0dlu:grow"));
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setAlignmentX(0.5f);
            if ("North".equals(toolbarLocation)) {
                this.add((Component)new JSeparator(1), new CellConstraints().xy(2, 1));
            } else {
                this.add((Component)new JSeparator(0), new CellConstraints().xy(1, 2));
            }
            this.adjustSize();
            ToolBar.this.addContainerListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.adjustSize();
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            this.adjustSize();
        }

        private void adjustSize() {
            Dimension newSize;
            ToolBar toolBar = this.getToolBar();
            String toolbarLocation = toolBar.getToolbarLocation();
            Dimension preferredSize = toolBar.getPreferredSize();
            int height = (int)((double)("North".equals(toolbarLocation) ? preferredSize.height : 20) * 0.85);
            int width = (int)((double)("North".equals(toolbarLocation) ? 10 : preferredSize.width) * 0.85);
            Dimension actualSize = this.getSize();
            if (!actualSize.equals(newSize = new Dimension(width, height))) {
                this.setPreferredSize(newSize);
                this.setMaximumSize(newSize);
                this.setMinimumSize(newSize);
            }
        }
    }
}

