/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.ProgramFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.WrapperFilter;
import util.ui.persona.Persona;

public class FilterPanel
extends JPanel {
    private JLabel mFilterLabel;
    private String mCurrentName;
    private JButton mDeactivate;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FilterPanel.class);

    public FilterPanel(KeyListener keyListener) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setBackground(UIManager.getColor("List.background"));
        this.setOpaque(false);
        this.mFilterLabel = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getHeaderImage() != null) {
                    String info = mLocalizer.msg("filterActive", "Active Filter:") + ": ";
                    Font boldFont = this.getFont().deriveFont(1);
                    FontMetrics metrics = g.getFontMetrics(boldFont);
                    int textWidth = metrics.stringWidth(info);
                    int baseLine = this.getBaseline(this.getWidth(), this.getHeight());
                    String text = FilterPanel.this.mCurrentName.replaceAll("</*span.*?>|</*s>|</*u>|</*b>", "");
                    boolean orange = FilterPanel.this.mCurrentName.contains("color:orange");
                    boolean darkred = FilterPanel.this.mCurrentName.contains("color:red");
                    if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                        g.setColor(Persona.getInstance().getShadowColor());
                        g.setFont(boldFont);
                        g.drawString(info, this.getIconTextGap() + this.getInsets().left + 1, baseLine + 1);
                        g.drawString(info, this.getIconTextGap() + this.getInsets().left + 2, baseLine + 2);
                        g.setFont(this.getFont());
                        g.drawString(text, this.getIconTextGap() + this.getInsets().left + 1 + textWidth, baseLine + 1);
                        g.drawString(text, this.getIconTextGap() + this.getInsets().left + 2 + textWidth, baseLine + 2);
                    }
                    g.setColor(Persona.getInstance().getTextColor());
                    g.setFont(boldFont);
                    g.drawString(info, this.getIconTextGap() + this.getInsets().left, baseLine);
                    if (orange) {
                        g.setColor(new Color(255, 125, 0));
                    } else if (darkred) {
                        g.setColor(Color.RED);
                    }
                    boolean strikeThrough = FilterPanel.this.mCurrentName.contains("text-decoration:line-through") || FilterPanel.this.mCurrentName.contains("<s>");
                    boolean underline = FilterPanel.this.mCurrentName.contains("text-decoration:underline") || FilterPanel.this.mCurrentName.contains("<u>");
                    int x = this.getIconTextGap() + this.getInsets().left + textWidth;
                    g.setFont(this.getFont());
                    g.drawString(text, x, baseLine);
                    if (strikeThrough || underline) {
                        int textWidth2 = g.getFontMetrics(this.getFont()).stringWidth(text);
                        int y = baseLine + 1;
                        if (strikeThrough) {
                            y = baseLine - baseLine / 4;
                        }
                        g.drawLine(x, y, x + textWidth2 - this.getInsets().left - this.getInsets().right, y);
                    }
                    g.setFont(this.getFont());
                    g.drawString(text, x, baseLine);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        this.mFilterLabel.addKeyListener(keyListener);
        this.mFilterLabel.setHorizontalAlignment(2);
        this.add((Component)this.mFilterLabel, "Center");
        this.mDeactivate = Persona.createPersonaButton(mLocalizer.msg("deactivate", "Deactivate"));
        this.mDeactivate.addKeyListener(keyListener);
        this.mDeactivate.addActionListener(e -> MainFrame.getInstance().setProgramFilter(FilterManagerImpl.getInstance().getDefaultFilter()));
        if (Persona.getInstance().getHeaderImage() != null) {
            this.mDeactivate.setRolloverEnabled(true);
            this.mDeactivate.setOpaque(false);
        }
        this.add((Component)this.mDeactivate, "East");
    }

    private void setFilterLabel(String name) {
        if (name.equals(this.mCurrentName)) {
            return;
        }
        this.mCurrentName = name.replaceAll("</*html>", "");
        this.mFilterLabel.setText("<html><body><b>" + mLocalizer.msg("filterActive", "Active Filter:") + ":</b> " + this.mCurrentName + "</body></html>");
    }

    public void setCurrentFilter(ProgramFilter filter) {
        this.setFilterLabel(new WrapperFilter(filter).toString());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color c;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        Color c2 = Persona.getInstance().getTextColor() != null ? Persona.getInstance().getTextColor() : UIManager.getColor("List.selectionBackground");
        Color color = c = Persona.getInstance().getAccentColor() != null ? Persona.getInstance().getAccentColor() : this.getBackground();
        if (Persona.getInstance().getHeaderImage() != null) {
            c = Persona.testPersonaForegroundAgainst(c);
            c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 200);
        }
        GradientPaint paint = new GradientPaint((float)width / 3.0f, 0.0f, c, width, height, c2, false);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, width, height);
    }

    public void updateLabel(ProgramFilter filter) {
        this.setFilterLabel(new WrapperFilter(filter).toString());
    }

    public void updatePersona() {
        if (this.mDeactivate != null) {
            if (Persona.getInstance().getHeaderImage() != null) {
                this.mDeactivate.setBorder(Persona.getPersonaButtonBorder());
                this.mDeactivate.setRolloverEnabled(true);
                this.mDeactivate.setOpaque(false);
            } else {
                this.mDeactivate.setBorder(UIManager.getBorder("Button.border"));
                this.mDeactivate.setRolloverEnabled(UIManager.getBoolean("Button.rollover"));
                this.mDeactivate.setOpaque(true);
            }
        }
    }
}

