/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import devplugin.PluginAccess;
import devplugin.Version;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.ui.mainframe.SoftwareUpdater;
import tvbrowser.ui.settings.BlockedPlugin;
import util.settings.Property;
import util.settings.PropertyManager;

public final class BlockedPluginArrayProperty
extends Property {
    private BlockedPlugin[] mCachedValue = null;
    private BlockedPlugin[] mOldValue = null;
    private ArrayList<BlockedPlugin> mNewValues = new ArrayList(0);

    public BlockedPluginArrayProperty(PropertyManager manager, String key) {
        super(manager, key);
    }

    public BlockedPlugin[] getBlockedPluginArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            this.mCachedValue = StringUtils.isBlank((CharSequence)asString) ? new BlockedPlugin[0] : this.loadBlockedPlugins(asString);
        }
        return this.mCachedValue;
    }

    public boolean isBlocked(PluginAccess plugin) {
        if (this.mCachedValue == null) {
            this.getBlockedPluginArray();
        }
        for (BlockedPlugin blocked : this.mCachedValue) {
            if (!blocked.isBlockedVersion(plugin)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlocked(String pluginId, Version version) {
        if (this.mCachedValue == null) {
            this.getBlockedPluginArray();
        }
        for (BlockedPlugin blocked : this.mCachedValue) {
            if (!blocked.isBlockedVersion(pluginId, version)) continue;
            return true;
        }
        return false;
    }

    public void addBlockedPlugin(SoftwareUpdater updater, String pluginId, Version blockStart, Version blockEnd) {
        if (this.mCachedValue == null) {
            if (updater != null && updater.isRequestingToBlockAPlugin(pluginId)) {
                this.mCachedValue = new BlockedPlugin[]{new BlockedPlugin(blockStart, blockEnd, pluginId)};
            }
        } else if (updater != null && updater.isRequestingToBlockAPlugin(pluginId)) {
            BlockedPlugin[] blockedArray = new BlockedPlugin[this.mCachedValue.length + 1];
            System.arraycopy(this.mCachedValue, 0, blockedArray, 0, this.mCachedValue.length);
            blockedArray[this.mCachedValue.length] = new BlockedPlugin(blockStart, blockEnd, pluginId);
            this.mCachedValue = blockedArray;
        }
        if (this.mCachedValue != null && this.mCachedValue.length > 0 && !this.checkAndRemoveValueFromOld(this.mCachedValue[this.mCachedValue.length - 1])) {
            this.mNewValues.add(this.mCachedValue[this.mCachedValue.length - 1]);
        }
        this.setBlockedPluginArray(this.mCachedValue);
    }

    private boolean checkAndRemoveValueFromOld(BlockedPlugin plugin) {
        if (this.mOldValue != null) {
            for (int i = 0; i < this.mOldValue.length; ++i) {
                if (this.mOldValue[i] == null || !this.mOldValue[i].equals(plugin)) continue;
                this.mOldValue[i] = null;
                return true;
            }
        }
        return false;
    }

    public void clear(SoftwareUpdater updater) {
        if (updater != null && updater.isRequestingBlockArrayClear()) {
            this.mOldValue = this.mCachedValue;
            this.mCachedValue = null;
            this.mNewValues = new ArrayList(0);
            this.setProperty("");
        }
    }

    private void setBlockedPluginArray(BlockedPlugin[] blockedPluginArray) {
        if (blockedPluginArray != null) {
            StringBuilder asString = new StringBuilder();
            asString.append(blockedPluginArray[0].getPropertyString());
            for (int i = 1; i < blockedPluginArray.length; ++i) {
                asString.append("#_#");
                asString.append(blockedPluginArray[i].getPropertyString());
            }
            this.setProperty(asString.toString());
        }
    }

    private BlockedPlugin[] loadBlockedPlugins(String settingsValue) {
        BlockedPlugin[] blockedPlugins;
        if (settingsValue != null) {
            String[] parts = settingsValue.split("#_#");
            blockedPlugins = new BlockedPlugin[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                blockedPlugins[i] = new BlockedPlugin(parts[i]);
            }
        } else {
            blockedPlugins = new BlockedPlugin[]{};
        }
        return blockedPlugins;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    public BlockedPlugin[] getNewBlockedPlugins() {
        return this.mNewValues.toArray(new BlockedPlugin[this.mNewValues.size()]);
    }
}

