/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.FontChooserPanel;

public class FontsSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FontsSettingsTab.class);
    private JCheckBox mUseUserDefindedFontsCB;
    private JCheckBox mEnableAntialiasingCB;
    private FontChooserPanel mTitleFontPanel;
    private FontChooserPanel mInfoFontPanel;
    private FontChooserPanel mChannelNameFontPanel;
    private FontChooserPanel mTimeFontPanel;
    private JLabel mTimeFontLabel;
    private JLabel mChannelNameFontLabel;
    private JLabel mInfoFontLabel;
    private JLabel mTitleFontLabel;
    private JComboBox<String> mTextLineGap;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder mainPanel = new EnhancedPanelBuilder(new FormLayout("5dlu, 10dlu, default, 3dlu, default, fill:3dlu:grow"));
        mainPanel.border(Borders.DIALOG);
        mainPanel.addSeparatorRowFull(false, LOCALIZER.msg("Fonts", "Fonts"));
        this.mEnableAntialiasingCB = new JCheckBox(LOCALIZER.msg("EnableAntialiasing", "Enable antialiasing"));
        this.mEnableAntialiasingCB.setSelected(Settings.Fonts.ANTIALIASING_ENABLED.getBoolean());
        mainPanel.addRowFull(this.mEnableAntialiasingCB, 2);
        this.mUseUserDefindedFontsCB = new JCheckBox(LOCALIZER.msg("UserDefinedFonts", "Use userdefined fonts"));
        this.mUseUserDefindedFontsCB.setSelected(!Settings.Fonts.USE_DEFAULT.getBoolean());
        mainPanel.addRowFull(false, (Component)this.mUseUserDefindedFontsCB, 2);
        this.mChannelNameFontLabel = mainPanel.addLabelRow(LOCALIZER.msg("ChannelNames", "Channel name"), 3);
        this.mChannelNameFontPanel = new FontChooserPanel(Settings.Fonts.CHANNEL_NAME.getFont());
        mainPanel.add(this.mChannelNameFontPanel, 5);
        this.mTitleFontLabel = mainPanel.addLabelRow("13dlu, default", LOCALIZER.msg("ProgramTitle", "Program title"), 3);
        this.mTitleFontPanel = new FontChooserPanel(Settings.Fonts.PROGRAM_TITLE.getFont());
        mainPanel.add(this.mTitleFontPanel, 5);
        this.mInfoFontLabel = mainPanel.addLabelRow("3dlu, default", LOCALIZER.msg("ProgramInfo", "Program information"), 3);
        this.mInfoFontPanel = new FontChooserPanel(Settings.Fonts.PROGRAM_INFO.getFont());
        mainPanel.add(this.mInfoFontPanel, 5);
        this.mTimeFontLabel = mainPanel.addLabelRow("3dlu, default", LOCALIZER.msg("Time", "Time"), 3);
        this.mTimeFontPanel = new FontChooserPanel(Settings.Fonts.PROGRAM_TIME.getFont());
        mainPanel.add(this.mTimeFontPanel, 5);
        mainPanel.addLabelRow("10dlu, default", LOCALIZER.msg("lineSpacing", "Line spacing:"), 2, 2);
        this.mTextLineGap = new JComboBox<String>(new String[]{LOCALIZER.msg("lineSpacing.singleLine", "Single line"), LOCALIZER.msg("lineSpacing.oneAndAQuaterLine", "1.25 line"), LOCALIZER.msg("lineSpacing.oneAndAHalfLine", "1.5 line"), LOCALIZER.msg("lineSpacing.oneAndThreeQuaterLine", "1.75 line"), LOCALIZER.msg("lineSpacing.doubleLine", "Double line")});
        this.mTextLineGap.setSelectedIndex(Settings.Fonts.PROGRAM_TEX_TLINE_GAP.getInt());
        mainPanel.add(this.mTextLineGap, 5);
        this.mUseUserDefindedFontsCB.addActionListener(e -> this.enableFontFields(this.mUseUserDefindedFontsCB.isSelected()));
        this.enableFontFields(this.mUseUserDefindedFontsCB.isSelected());
        return mainPanel.getPanel();
    }

    private void enableFontFields(boolean enable) {
        this.mTitleFontLabel.setEnabled(enable);
        this.mTitleFontPanel.setEnabled(enable);
        this.mInfoFontLabel.setEnabled(enable);
        this.mInfoFontPanel.setEnabled(enable);
        this.mChannelNameFontLabel.setEnabled(enable);
        this.mChannelNameFontPanel.setEnabled(enable);
        this.mTimeFontLabel.setEnabled(enable);
        this.mTimeFontPanel.setEnabled(enable);
    }

    @Override
    public void saveSettings() {
        Settings.Fonts.PROGRAM_TITLE.setFont(this.mTitleFontPanel.getChosenFont());
        Settings.Fonts.PROGRAM_INFO.setFont(this.mInfoFontPanel.getChosenFont());
        Settings.Fonts.CHANNEL_NAME.setFont(this.mChannelNameFontPanel.getChosenFont());
        Settings.Fonts.PROGRAM_TIME.setFont(this.mTimeFontPanel.getChosenFont());
        Settings.Fonts.USE_DEFAULT.setBoolean(!this.mUseUserDefindedFontsCB.isSelected());
        Settings.Fonts.ANTIALIASING_ENABLED.setBoolean(this.mEnableAntialiasingCB.isSelected());
        Settings.Fonts.PROGRAM_TEX_TLINE_GAP.setInt(this.mTextLineGap.getSelectedIndex());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-font", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("Fonts", "Fonts");
    }
}

