/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormating;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormatingManager;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.LocalPluginProgramFormatingSettingsDialog;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SortableItemList;

public class GlobalPluginProgramFormatingSettings
implements SettingsTab,
ActionListener {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(GlobalPluginProgramFormatingSettings.class);
    private SortableItemList<GlobalPluginProgramFormating> mConfigurations;
    private JButton mAdd;
    private JButton mEdit;
    private JButton mDelete;

    @Override
    public JPanel createSettingsPanel() {
        try {
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default:grow,5dlu"));
            pb.border(Borders.DIALOG);
            this.mConfigurations = new SortableItemList<GlobalPluginProgramFormating>("", GlobalPluginProgramFormatingManager.getInstance().getAvailableGlobalPluginProgramFormatings());
            this.mConfigurations.getList().setSelectionMode(0);
            this.mConfigurations.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                        LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().getSelectedValue(), GlobalPluginProgramFormatingManager.getDefaultConfiguration(), true, true);
                        GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().repaint();
                    }
                }
            });
            pb.addSeparatorRowFull(false, LOCALIZER.msg("title", "Plugin program formating"));
            pb.addGrowingRow(this.mConfigurations, 2);
            EnhancedPanelBuilder buttonPanel = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default,5dlu,default", "default"));
            buttonPanel.getLayout().setColumnGroups((int[][])new int[][]{{1, 3, 5}});
            this.mAdd = new JButton(Localizer.getLocalization("i18n_add"));
            this.mAdd.setIcon(TVBrowserIcons.newIcon(16));
            this.mAdd.addActionListener(this);
            this.mEdit = new JButton(Localizer.getLocalization("i18n_edit"));
            this.mEdit.setIcon(TVBrowserIcons.edit(16));
            this.mEdit.setEnabled(false);
            this.mEdit.addActionListener(this);
            this.mDelete = new JButton(Localizer.getLocalization("i18n_delete"));
            this.mDelete.setIcon(TVBrowserIcons.delete(16));
            this.mDelete.setEnabled(false);
            this.mDelete.addActionListener(this);
            buttonPanel.add(this.mAdd, 1);
            buttonPanel.add(this.mEdit, 3);
            buttonPanel.add(this.mDelete, 5);
            pb.addRow(buttonPanel.getPanel(), 2);
            pb.addLabelRow("10dlu,pref", LOCALIZER.msg("help", "<html>This list of formating can be used by several plugins. So a formating don't have to be entered in every plugin that should use the formating. The selection of the formating can be done in the settings of the plugin.</html>"), 2);
            this.mConfigurations.getList().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.mEdit.setEnabled(this.mConfigurations.getList().getSelectedIndex() != -1);
                    this.mDelete.setEnabled(this.mConfigurations.getList().getSelectedIndex() != -1);
                }
            });
            return pb.getPanel();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Plugin program formating");
    }

    @Override
    public void saveSettings() {
        Object[] o = this.mConfigurations.getItems();
        if (o != null && o.length > 0) {
            GlobalPluginProgramFormating[] p = new GlobalPluginProgramFormating[o.length];
            for (int i = 0; i < o.length; ++i) {
                p[i] = (GlobalPluginProgramFormating)o[i];
            }
            GlobalPluginProgramFormatingManager.getInstance().setAvailableProgramConfigurations(p);
        } else {
            final GlobalPluginProgramFormating[] formating = new GlobalPluginProgramFormating[2];
            formating[0] = GlobalPluginProgramFormatingManager.getDefaultConfiguration();
            Thread t = new Thread("Plugin formating setting"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    formating[1] = GlobalPluginProgramFormatingManager.getTvPearlFormating();
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            GlobalPluginProgramFormatingManager.getInstance().setAvailableProgramConfigurations(formating);
        }
        GlobalPluginProgramFormatingManager.getInstance().store();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mAdd) {
            this.mConfigurations.addElement(GlobalPluginProgramFormatingManager.getDefaultConfiguration());
        } else if (e.getSource() == this.mDelete) {
            this.mConfigurations.removeElementAt(this.mConfigurations.getList().getSelectedIndex());
        } else if (e.getSource() == this.mEdit) {
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), this.mConfigurations.getList().getSelectedValue(), GlobalPluginProgramFormatingManager.getDefaultConfiguration(), true, true);
            this.mConfigurations.getList().repaint();
        }
    }
}

