/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.looksSettings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.ui.BrownSugarDark;
import tvbrowser.ui.DarkStarDark;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class JGoodiesLNFSettings
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(JGoodiesLNFSettings.class);
    private JComboBox<PlasticTheme> mColorScheme;
    private JCheckBox mShadow;

    public JGoodiesLNFSettings(JDialog parent) {
        super((Dialog)parent, true);
        this.setTitle(mLocalizer.msg("title", "Title"));
        this.createGui();
    }

    private void createGui() {
        List themesList = PlasticLookAndFeel.getInstalledThemes();
        themesList.add(2, new DarkStarDark(true));
        themesList.add(1, new BrownSugarDark(true));
        PlasticTheme[] themes = themesList.toArray(new PlasticTheme[themesList.size()]);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout((LayoutManager)new FormLayout("pref, 3dlu, fill:pref:grow", "pref, 3dlu, pref, fill:3dlu:grow, pref"));
        content.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        content.add((Component)new JLabel(mLocalizer.msg("colorTheme", "Color-Theme") + ":"), cc.xy(1, 1));
        this.mColorScheme = new JComboBox<PlasticTheme>(themes);
        this.mColorScheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                label.setText(((PlasticTheme)value).getName());
                return label;
            }
        });
        String theme = Settings.LookAndFeel.JGOODIES_THEME.getString();
        if (theme == null) {
            theme = PlasticLookAndFeel.createMyDefaultTheme().getClass().getName();
        }
        for (int i = 0; i < themes.length; ++i) {
            if (!themes[i].getClass().getName().equals(theme)) continue;
            this.mColorScheme.setSelectedIndex(i);
        }
        content.add(this.mColorScheme, cc.xy(3, 1));
        this.mShadow = new JCheckBox(mLocalizer.msg("dropShadow", "Drop Shadow on Menus"));
        this.mShadow.setSelected(Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean());
        content.add((Component)this.mShadow, cc.xyw(1, 3, 3));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> this.okPressed());
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(e -> this.cancelPressed());
        ButtonBarBuilder bar = new ButtonBarBuilder();
        bar.addButton((JComponent[])new JButton[]{ok, cancel});
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.add(bar.getPanel());
        content.add((Component)panel, cc.xyw(1, 5, 3));
        UiUtilities.registerForClosing(this);
        this.pack();
    }

    protected void cancelPressed() {
        this.setVisible(false);
    }

    protected void okPressed() {
        Settings.LookAndFeel.JGOODIES_THEME.setString(this.mColorScheme.getSelectedItem().getClass().getName());
        Settings.LookAndFeel.JGOODIES_SHADOW.setBoolean(this.mShadow.isSelected());
        this.setVisible(false);
    }

    @Override
    public void close() {
        this.cancelPressed();
    }
}

