/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.ProgramTableSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import util.i18n.Localizer;
import util.ui.TabLayout;

public class DayTimeBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(DayTimeBackgroundStyle.class);
    private JTextField mTimeOfDayEdgeTF;
    private JTextField mTimeOfDayEarlyTF;
    private JTextField mTimeOfDayMiddayTF;
    private JTextField mTimeOfDayAfternoonTF;
    private JTextField mTimeOfDayEveningTF;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mContent = new JPanel(new TabLayout(3));
        this.mContent.add(new JLabel(LOCALIZER.msg("timeOfDay.edge", "Edge")));
        this.mTimeOfDayEdgeTF = new JTextField(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EDGE.getString(), 25);
        this.mContent.add(this.mTimeOfDayEdgeTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEdgeTF));
        this.mContent.add(new JLabel(LOCALIZER.msg("timeOfDay.early", "Early")));
        this.mTimeOfDayEarlyTF = new JTextField(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EARLY.getString(), 25);
        this.mContent.add(this.mTimeOfDayEarlyTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEarlyTF));
        this.mContent.add(new JLabel(LOCALIZER.msg("timeOfDay.midday", "Midday")));
        this.mTimeOfDayMiddayTF = new JTextField(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_MIDDAY.getString(), 25);
        this.mContent.add(this.mTimeOfDayMiddayTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayMiddayTF));
        this.mContent.add(new JLabel(LOCALIZER.msg("timeOfDay.afternoon", "Afternoon")));
        this.mTimeOfDayAfternoonTF = new JTextField(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_AFTERNOON.getString(), 25);
        this.mContent.add(this.mTimeOfDayAfternoonTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayAfternoonTF));
        this.mContent.add(new JLabel(LOCALIZER.msg("timeOfDay.evening", "Evening")));
        this.mTimeOfDayEveningTF = new JTextField(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EVENING.getString(), 25);
        this.mContent.add(this.mTimeOfDayEveningTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEveningTF));
        return this.mContent;
    }

    @Override
    public void storeSettings() {
        if (this.mContent == null) {
            return;
        }
        Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EDGE.setString(this.mTimeOfDayEdgeTF.getText());
        Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EARLY.setString(this.mTimeOfDayEarlyTF.getText());
        Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_MIDDAY.setString(this.mTimeOfDayMiddayTF.getText());
        Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_AFTERNOON.setString(this.mTimeOfDayAfternoonTF.getText());
        Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EVENING.setString(this.mTimeOfDayEveningTF.getText());
    }

    @Override
    public String getName() {
        return LOCALIZER.msg("style", "Day time");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "timeOfDay";
    }
}

