/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import util.io.CheckNetworkConnection;
import util.io.NtpMessage;

public class NetworkUtilities {
    private static final Logger mLog = Logger.getLogger(NetworkUtilities.class.getName());

    public static boolean checkConnection() {
        return new CheckNetworkConnection().checkConnection();
    }

    public static boolean checkConnection(URL url) {
        return new CheckNetworkConnection().checkConnection(url);
    }

    public static boolean checkConnection(URL url, int timeout, boolean showWaitingDialog) {
        return new CheckNetworkConnection().checkConnection(url, timeout, showWaitingDialog);
    }

    public static int getTimeDifferenceSeconds(String serverName) {
        if (!NetworkUtilities.checkConnection()) {
            return 0;
        }
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(10000);
            InetAddress address = InetAddress.getByName(serverName);
            byte[] buf = new NtpMessage().toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
            NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
            socket.send(packet);
            mLog.info("NTP request sent, waiting for response...");
            packet = new DatagramPacket(buf, buf.length);
            socket.receive(packet);
            double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
            NtpMessage msg = new NtpMessage(packet.getData());
            double roundTripDelay = destinationTimestamp - msg.originateTimestamp - (msg.transmitTimestamp - msg.receiveTimestamp);
            double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
            mLog.info("NTP server: " + serverName);
            mLog.info(msg.toString());
            mLog.info("Dest. timestamp:     " + NtpMessage.timestampToString(destinationTimestamp));
            mLog.info("Round-trip delay: " + new DecimalFormat("0.00").format(roundTripDelay * 1000.0) + " ms");
            mLog.info("Local clock offset: " + new DecimalFormat("0.00").format(localClockOffset * 1000.0) + " ms");
            socket.close();
            return (int)localClockOffset;
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String[] getConnectionCheckUrls() {
        return CheckNetworkConnection.getUrls();
    }
}

