/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public void zipDirectory(File zipfile, File directory, FileFilter fileFilter) throws IOException {
        zipfile.delete();
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
        this.zipDirFiles(out, directory, directory.getAbsolutePath().length() + 1, fileFilter);
        out.close();
    }

    public void zipDirectory(File zipfile, File directory) throws IOException {
        this.zipDirectory(zipfile, directory, null);
    }

    private void zipDirFiles(ZipOutputStream out, File directory, int parentlength, FileFilter fileFilter) throws IOException {
        File[] files = directory.listFiles();
        System.out.println(">" + directory.getAbsolutePath());
        if (files != null) {
            for (File file : files) {
                int len;
                if (file.isDirectory()) {
                    this.zipDirFiles(out, file, parentlength, fileFilter);
                    continue;
                }
                if (fileFilter != null && !fileFilter.accept(file)) continue;
                System.out.println(">" + file.getAbsolutePath());
                byte[] buf = new byte[1024];
                FileInputStream in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getAbsolutePath().substring(parentlength).replace("\\", "/")));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
        }
    }
}

