/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertyBasedSettings {
    private static final String ARRAY_SEPARATOR = "|||";
    private Properties mProperties;

    public PropertyBasedSettings(Properties properties) {
        this.mProperties = properties == null ? new Properties() : properties;
    }

    public Properties storeSettings() {
        return this.mProperties;
    }

    private void internalSet(String key, String value) {
        this.mProperties.setProperty(key, value);
    }

    private String internalGet(String key, String defaultValue) {
        return this.mProperties.getProperty(key, defaultValue);
    }

    protected void remove(String key) {
        this.mProperties.remove(key);
    }

    protected String get(String key) {
        return this.internalGet(key, "");
    }

    protected String get(String key, String defaultValue) {
        return this.internalGet(key, defaultValue);
    }

    protected void set(String key, String value) {
        this.internalSet(key, value);
    }

    protected boolean get(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.internalGet(key, String.valueOf(defaultValue)));
    }

    protected void set(String key, boolean value) {
        this.internalSet(key, String.valueOf(value));
    }

    protected int get(String key, int defaultValue) {
        return Integer.valueOf(this.internalGet(key, String.valueOf(defaultValue)));
    }

    protected void set(String key, int value) {
        this.internalSet(key, String.valueOf(value));
    }

    protected void set(String key, String[] value) {
        this.internalSet(key, StringUtils.join((Object[])value, (String)ARRAY_SEPARATOR));
    }

    protected String[] get(String key, String[] defaultValue) {
        return StringUtils.split((String)this.internalGet(key, StringUtils.join((Object[])defaultValue, (String)ARRAY_SEPARATOR)), (String)ARRAY_SEPARATOR);
    }
}

