/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import tvbrowser.TVBrowser;
import util.io.PropertiesSorted;
import util.io.stream.OutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.settings.Property;

public class PropertyManager {
    private static final Logger mLog = Logger.getLogger(PropertyManager.class.getName());
    private PropertiesSorted mProperties = new PropertiesSorted();
    private HashMap<String, Property> mPropertyHash = new HashMap();
    private HashSet<String> mChangedKeySet = new HashSet();

    public void writeToFile(File settingsFile) throws IOException {
        if (TVBrowser.isTransportable()) {
            this.mProperties.remove("dir.tvdata");
            this.mProperties.remove("dir.plugins");
        }
        StreamUtilities.outputStream(settingsFile, new OutputStreamProcessor(){

            @Override
            public void process(OutputStream outputStream) throws IOException {
                PropertyManager.this.mProperties.store(outputStream, null);
            }
        });
    }

    public void readFromFile(File settingsFile) throws IOException {
        try (BufferedInputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(settingsFile), 16384);
            this.readFromStream(in);
        }
    }

    public void readFromStream(InputStream in) throws IOException {
        this.mProperties.load(in);
        try {
            if (TVBrowser.isTransportable()) {
                if (!this.mProperties.getProperty("dir.tvdata", "./settings/tvdata").startsWith("./settings/tvdata")) {
                    this.mProperties.setProperty("dir.tvdata", "./settings/tvdata");
                }
                this.mProperties.remove("dir.plugins");
            }
            this.clearCaches();
        }
        finally {
            if (this.mProperties.isEmpty()) {
                throw new IOException("Settings file is empty!");
            }
        }
        this.removeUnknownEntries();
    }

    void addProperty(Property prop) {
        this.mPropertyHash.put(prop.getKey(), prop);
    }

    void setProperty(String key, String value) {
        boolean equalsOld;
        String oldVal = this.getProperty(key);
        boolean bl = oldVal == null ? value == null : (equalsOld = oldVal.equals(value));
        if (!equalsOld) {
            if (value == null) {
                this.mProperties.remove(key);
            } else {
                this.mProperties.setProperty(key, value);
            }
            this.mChangedKeySet.add(key);
        }
    }

    public String getProperty(String key) {
        return this.mProperties.getProperty(key);
    }

    public boolean hasChanged(Property prop) {
        return this.mChangedKeySet.contains(prop.getKey());
    }

    public boolean hasChanged(Property[] propArr) {
        for (Property element : propArr) {
            if (!this.mChangedKeySet.contains(element.getKey())) continue;
            return true;
        }
        return false;
    }

    public void clearChanges() {
        this.mChangedKeySet.clear();
    }

    private void clearCaches() {
        for (Property prop : this.mPropertyHash.values()) {
            prop.clearCache();
        }
    }

    private void removeUnknownEntries() {
        Iterator<Object> iter = this.mProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            boolean isKnown = key.equals("leftSingleClickIf") || key.equals("contextmenudefaultplugin") || key.equals("middleclickplugin") || key.equals("middledoubleclickplugin") || key.equals("leftSingleCtrlClickIf") || this.mPropertyHash.get(key) != null;
            if (isKnown) continue;
            mLog.info("Removing unknown setting: " + key + " (" + this.mProperties.get(key) + ")");
            iter.remove();
        }
    }
}

