/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Position;

public class CaretPositionCorrector {
    private Point mClickLocation;
    private int mCaretPosition;
    private int mStartPosition;
    private CaretListener mCaretListener;
    private char[] mJumpCharacters;
    private char mStartIndexChar;
    private boolean mMouseDown;

    private CaretPositionCorrector(JFormattedTextField field, char[] jumpCharacters, char startIndexChar, int startPosition) {
        this.mJumpCharacters = jumpCharacters;
        this.mStartIndexChar = startIndexChar;
        this.mStartPosition = startPosition;
        this.mClickLocation = null;
        this.mCaretPosition = -1;
        field.setHorizontalAlignment(4);
        if (jumpCharacters != null && jumpCharacters.length > 0) {
            this.createCaretListener(field);
            this.addKeyListenerToField(field);
        }
        this.addMouseListenerToField(field);
        this.addFocusListenerToField(field);
    }

    public static void createCorrector(JFormattedTextField field, char[] jumpCharacters, char startIndexChar) {
        new CaretPositionCorrector(field, jumpCharacters, startIndexChar, -1);
    }

    public static void createCorrector(JFormattedTextField field, char[] jumpCharacters, int startPosition) {
        new CaretPositionCorrector(field, jumpCharacters, '\u0000', startPosition);
    }

    private void createCaretListener(final JFormattedTextField field) {
        this.mCaretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (CaretPositionCorrector.this.mCaretPosition != -1 && field.getSelectedText() == null) {
                    CaretPositionCorrector.this.mCaretPosition = field.getCaretPosition();
                }
            }
        };
    }

    private boolean hasToMoveCaret(String text, int pos) {
        for (char value : this.mJumpCharacters) {
            if (text.charAt(pos) != value) continue;
            return true;
        }
        return false;
    }

    private void addKeyListenerToField(final JFormattedTextField field) {
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (38 == e.getKeyCode() || 40 == e.getKeyCode()) {
                    CaretPositionCorrector.this.mCaretPosition = field.getCaretPosition();
                    if (CaretPositionCorrector.this.mCaretPosition <= field.getText().length() && CaretPositionCorrector.this.mCaretPosition > 0 && field.getSelectedText() == null && (CaretPositionCorrector.this.mCaretPosition >= field.getText().length() || CaretPositionCorrector.this.hasToMoveCaret(field.getText(), CaretPositionCorrector.this.mCaretPosition))) {
                        field.setCaretPosition(--CaretPositionCorrector.this.mCaretPosition);
                    }
                }
            }
        });
    }

    private void addMouseListenerToField(final JFormattedTextField field) {
        field.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CaretPositionCorrector.this.mMouseDown = true;
                CaretPositionCorrector.this.mClickLocation = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CaretPositionCorrector.this.mMouseDown = false;
                CaretPositionCorrector.this.mCaretPosition = field.getUI().viewToModel2D(field, e.getPoint(), new Position.Bias[0]);
                if (CaretPositionCorrector.this.mCaretPosition <= field.getText().length() && CaretPositionCorrector.this.mCaretPosition > 0 && field.getSelectedText() == null && (CaretPositionCorrector.this.mCaretPosition >= field.getText().length() || CaretPositionCorrector.this.hasToMoveCaret(field.getText(), CaretPositionCorrector.this.mCaretPosition))) {
                    field.setCaretPosition(--CaretPositionCorrector.this.mCaretPosition);
                }
            }
        });
    }

    private void addFocusListenerToField(final JFormattedTextField field) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CaretPositionCorrector.this.mCaretPosition == -1) {
                    CaretPositionCorrector.this.mCaretPosition = CaretPositionCorrector.this.mStartIndexChar != '\u0000' ? field.getText().indexOf(String.valueOf(CaretPositionCorrector.this.mStartIndexChar)) + 1 : (CaretPositionCorrector.this.mStartPosition != -1 ? CaretPositionCorrector.this.mStartPosition : 0);
                }
                SwingUtilities.invokeLater(() -> {
                    if (CaretPositionCorrector.this.mClickLocation != null) {
                        CaretPositionCorrector.this.mCaretPosition = field.getUI().viewToModel2D(field, CaretPositionCorrector.this.mClickLocation, new Position.Bias[0]);
                    }
                    CaretPositionCorrector.this.mClickLocation = null;
                    if (CaretPositionCorrector.this.mCaretPosition <= field.getText().length() && CaretPositionCorrector.this.mCaretPosition > 0 && field.getSelectedText() == null && !CaretPositionCorrector.this.mMouseDown && (CaretPositionCorrector.this.mCaretPosition >= field.getText().length() || CaretPositionCorrector.this.hasToMoveCaret(field.getText(), CaretPositionCorrector.this.mCaretPosition))) {
                        --CaretPositionCorrector.this.mCaretPosition;
                    }
                    field.setCaretPosition(CaretPositionCorrector.this.mCaretPosition);
                    field.addCaretListener(CaretPositionCorrector.this.mCaretListener);
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                CaretPositionCorrector.this.mCaretPosition = field.getCaretPosition();
                field.removeCaretListener(CaretPositionCorrector.this.mCaretListener);
            }
        });
    }
}

