/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Plugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.MarkPriorityComboBoxRenderer;
import util.ui.UiUtilities;

public final class DefaultMarkingPrioritySelectionPanel
extends JPanel {
    public static final String TYPE_LABEL = "labeled";
    public static final String TYPE_SELECTABLE = "selectable";
    private static final long serialVersionUID = 1L;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(DefaultMarkingPrioritySelectionPanel.class);
    private ArrayList<Object> mPrioritySelection;
    private JEditorPane mHelpLabel;
    private JComponent mSeparator;
    private ArrayList<JComponent> mLabel;

    private DefaultMarkingPrioritySelectionPanel(int priority, boolean showTitle, boolean withDefaultDialogBorder) {
        this(priority, LOCALIZER.msg("color", "Highlighting color"), showTitle, true, withDefaultDialogBorder);
    }

    private DefaultMarkingPrioritySelectionPanel(int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        this(new State(TYPE_LABEL, true), priority, label, showTitle, showHelpLabel, withDefaultDialogBorder, false, true);
    }

    private DefaultMarkingPrioritySelectionPanel(State state, int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder, boolean growingGap, boolean showNoMarkingPriority) {
        this(new State[]{state}, new int[]{priority}, new String[]{label}, showTitle, showHelpLabel, withDefaultDialogBorder, growingGap, showNoMarkingPriority);
    }

    private DefaultMarkingPrioritySelectionPanel(int[] priority, String[] label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        this(DefaultMarkingPrioritySelectionPanel.getStatesDefault(label.length), priority, label, showTitle, showHelpLabel, withDefaultDialogBorder, false, true);
    }

    private static State[] getStatesDefault(int length) {
        Object[] states = new State[length];
        Arrays.fill(states, new State(TYPE_LABEL, true));
        return states;
    }

    private DefaultMarkingPrioritySelectionPanel(State[] states, int[] priority, String[] label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder, boolean growingGap, boolean showNoMarkingPriority) {
        try {
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default,default,0dlu:grow"), (JPanel)this);
            if (growingGap) {
                pb.getLayout().insertColumn(3, ColumnSpec.decode((String)"5dlu:grow"));
            } else {
                pb.getLayout().insertColumn(3, ColumnSpec.decode((String)"5dlu"));
            }
            int choosersToDraw = Math.min(priority.length, label.length);
            if (withDefaultDialogBorder) {
                pb.border(Borders.DIALOG);
            }
            this.mLabel = new ArrayList();
            this.mPrioritySelection = new ArrayList();
            if (showTitle) {
                this.mSeparator = pb.addSeparatorRowFull(DefaultMarkingPrioritySelectionPanel.getTitle());
            }
            for (int i = 0; i < choosersToDraw; ++i) {
                JComboBox<Object> box = new JComboBox<Object>();
                String[] names = DefaultMarkingPrioritySelectionPanel.getMarkingColorNames(showNoMarkingPriority);
                for (int j = 0; j < names.length; ++j) {
                    box.addItem(new PriortiyLabel(j + (showNoMarkingPriority ? -1 : 0), names[j]));
                }
                State state = states[i];
                if (state.mType.equals(TYPE_SELECTABLE)) {
                    this.mLabel.add(new JCheckBox(label[i], state.mActivated));
                    box.setEnabled(state.mActivated);
                    ((JCheckBox)this.mLabel.get(i)).addItemListener(e -> {
                        box.setEnabled(e.getStateChange() == 1);
                        state.mActivated = box.isEnabled();
                    });
                    pb.addRow(this.mLabel.get(i), 2);
                } else {
                    this.mLabel.add(pb.addLabelRow(label[i], 2));
                }
                this.mPrioritySelection.add(box);
                box.setSelectedIndex(Math.min(priority[i], Settings.getHighlightingPriorityMaximum()) + (showNoMarkingPriority ? 1 : 0));
                box.setRenderer(new MarkPriorityComboBoxRenderer(box.getRenderer()));
                pb.add(box, 4);
            }
            if (showHelpLabel) {
                this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The selected higlighting color is only shown if the program is higlighted by this plugin only or if the other higlightings have a lower or the same priority. The higlighting colors of the priorities can be changed in the <a href=\"#link\">higlighting settings</a>."), e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        SettingsDialog.getInstance().showSettingsTab("#programpanelmarking");
                    }
                });
                this.mHelpLabel.setMaximumSize(new Dimension(Sizes.dialogUnitXAsPixel((int)200, (Component)this.mHelpLabel), Sizes.dialogUnitXAsPixel((int)600, (Component)this.mHelpLabel)));
                pb.addRowFull(this.mHelpLabel, 2);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int priority, boolean showTitle, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, showTitle, withDefaultDialogBorder);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, label, showTitle, showHelpLabel, withDefaultDialogBorder);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(State state, int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder, boolean growingGap, boolean showNoMarkingPriority) {
        return new DefaultMarkingPrioritySelectionPanel(state, priority, label, showTitle, showHelpLabel, withDefaultDialogBorder, growingGap, showNoMarkingPriority);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(State[] states, int[] priorities, String[] labels, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder, boolean growingGap, boolean showNoMarkingPriority) {
        return new DefaultMarkingPrioritySelectionPanel(states, priorities, labels, showTitle, showHelpLabel, withDefaultDialogBorder, growingGap, showNoMarkingPriority);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int[] priority, String[] label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, label, showTitle, showHelpLabel, withDefaultDialogBorder);
    }

    public int getSelectedPriority() {
        return this.getSelectedPriority(0);
    }

    public int getSelectedPriority(int index) {
        return ((PriortiyLabel)((JComboBox)this.mPrioritySelection.get(index)).getSelectedItem()).getPriority();
    }

    public int[] getSelectedPriorities() {
        int[] prios = new int[this.mPrioritySelection.size()];
        for (int i = 0; i < this.mPrioritySelection.size(); ++i) {
            prios[i] = this.getSelectedPriority(i);
        }
        return prios;
    }

    public static String getTitle() {
        return LOCALIZER.msg("title", "Highlighting");
    }

    public static String[] getMarkingColorNames(boolean withNoMarkPriority) {
        String[] colors = new String[Settings.getHighlightingPriorityMaximum() + (withNoMarkPriority ? 2 : 1)];
        int offset = withNoMarkPriority ? 0 : 1;
        int i = 0;
        if (withNoMarkPriority) {
            colors[i++] = MarkingsSettingsTab.LOCALIZER.msg("color.noPriority", "Don't highlight");
        }
        while (i < colors.length) {
            colors[i] = i + offset + ". " + MarkingsSettingsTab.LOCALIZER.msg("color.colorPriority", "Color/priority");
            ++i;
        }
        i = withNoMarkPriority ? 1 : 0;
        if (colors.length > 2 || !withNoMarkPriority && colors.length > 1) {
            int n = i;
            colors[n] = colors[n] + MarkingsSettingsTab.LOCALIZER.msg("color.colorPriority.min", " (minimum)");
            int n2 = colors.length - 1;
            colors[n2] = colors[n2] + MarkingsSettingsTab.LOCALIZER.msg("color.colorPriority.max", " (maximum)");
        }
        return colors;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mSeparator != null) {
            this.mSeparator.setEnabled(enabled);
        }
        if (this.mHelpLabel != null) {
            this.mHelpLabel.setEnabled(enabled);
        }
        for (int i = 0; i < this.mLabel.size(); ++i) {
            this.mLabel.get(i).setEnabled(enabled);
            ((JComboBox)this.mPrioritySelection.get(i)).setEnabled(enabled && (!(this.mLabel.get(i) instanceof JCheckBox) || ((JCheckBox)this.mLabel.get(i)).isSelected()));
        }
    }

    public static final class PriortiyLabel {
        private final int mPriority;
        private final String mLabel;

        public PriortiyLabel(int priority, String label) {
            this.mPriority = priority;
            this.mLabel = label;
        }

        public int getPriority() {
            return this.mPriority;
        }

        public Color getColor() {
            return Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority(this.mPriority);
        }

        public String toString() {
            return this.mLabel;
        }
    }

    public static final class State {
        private String mType;
        private boolean mActivated;
        private boolean mActivatedInitialy;

        public State(String type, boolean activated) {
            this.mType = type;
            this.mActivatedInitialy = this.mActivated = activated;
        }

        public boolean isActivated() {
            return this.mType.equals(DefaultMarkingPrioritySelectionPanel.TYPE_SELECTABLE) ? this.mActivated : true;
        }

        public boolean wasChanged() {
            return this.mActivated != this.mActivatedInitialy;
        }
    }
}

