/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public final class DisclosureTriangle
extends JPanel {
    private final JLabel label;
    private final Container container;
    private boolean collapsed;
    private Icon collapseIcon;
    private Icon expandIcon;
    public static final String DEFAULT_LABEL_TEXT = "Details";

    public DisclosureTriangle(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("container must not be null");
        }
        this.container = container;
        this.collapsed = true;
        this.collapseIcon = UIManager.getIcon("Tree.expandedIcon");
        this.expandIcon = UIManager.getIcon("Tree.collapsedIcon");
        this.label = new JLabel(DEFAULT_LABEL_TEXT, this.expandIcon, 10);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (DisclosureTriangle.this.collapsed) {
                    DisclosureTriangle.this.expand();
                } else {
                    DisclosureTriangle.this.collapse();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add("North", this.label);
    }

    public void expand() {
        this.setCollapsed(false);
    }

    private void doExpand() {
        this.add("Center", this.container);
        this.label.setIcon(this.collapseIcon);
        Container rootPaneContainer = this.getParentRootPaneContainer();
        if (rootPaneContainer != null) {
            Dimension d0 = rootPaneContainer.getSize();
            Dimension d1 = this.container.getSize();
            Dimension d2 = this.container.getPreferredSize();
            rootPaneContainer.setSize(d0.width, d0.height + Math.max(d1.height, d2.height));
        }
    }

    public void collapse() {
        this.setCollapsed(true);
    }

    private void doCollapse() {
        this.remove(this.container);
        this.label.setIcon(this.expandIcon);
        Container rootPaneContainer = this.getParentRootPaneContainer();
        if (rootPaneContainer != null) {
            Dimension d0 = rootPaneContainer.getSize();
            Dimension d1 = this.container.getSize();
            Dimension d2 = this.container.getPreferredSize();
            rootPaneContainer.setSize(d0.width, d0.height - Math.max(d1.height, d2.height));
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        boolean oldCollapsed = this.collapsed;
        if (collapsed && !oldCollapsed) {
            this.doCollapse();
        }
        if (!collapsed && oldCollapsed) {
            this.doExpand();
        }
        this.collapsed = collapsed;
        this.firePropertyChange("collapsed", oldCollapsed, this.collapsed);
    }

    private Container getParentRootPaneContainer() {
        Container c = this;
        while (!(c instanceof RootPaneContainer)) {
            if (c.getParent() == null) {
                return null;
            }
            c = c.getParent();
        }
        return c;
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void setLabelText(String labelText) {
        String oldLabelText = this.label.getText();
        this.label.setText(labelText);
        this.firePropertyChange("labelText", oldLabelText, this.label.getText());
    }

    public Icon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(Icon collapseIcon) {
        Icon oldCollapseIcon = this.collapseIcon;
        this.collapseIcon = collapseIcon;
        this.firePropertyChange("collapseIcon", oldCollapseIcon, this.collapseIcon);
        if (!this.collapsed) {
            this.label.setIcon(this.collapseIcon);
        }
    }

    public Icon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(Icon expandIcon) {
        Icon oldExpandIcon = this.expandIcon;
        this.expandIcon = expandIcon;
        this.firePropertyChange("expandIcon", oldExpandIcon, this.expandIcon);
        if (this.collapsed) {
            this.label.setIcon(this.expandIcon);
        }
    }
}

