/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import util.i18n.Localizer;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.TVBrowserIcons;
import util.ui.TabLayout;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemRenderer;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class OrderChooser<E>
extends JPanel
implements ListDropAction<SelectableItem<E>> {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(OrderChooser.class);
    private JList<SelectableItem<E>> mList;
    private DefaultListModel<SelectableItem<E>> mListModel;
    private SelectableItemRenderer<E> mItemRenderer;
    private JButton mUpBt;
    private JButton mDownBt;
    private JButton mSelectAllBt;
    private JButton mDeSelectAllBt;
    private boolean mIsEnabled = true;
    private JScrollPane mScrollPane;
    private JPanel mButtonPanel;

    public OrderChooser(E[] currOrder, E[] allItems) {
        this(currOrder, allItems, false);
    }

    public OrderChooser(E[] currOrder, E[] allItems, boolean showSelectionButtons) {
        this(currOrder, allItems, showSelectionButtons, null, null);
    }

    public OrderChooser(E[] currOrder, E[] allItems, Class<?> renderClass, SelectableItemRendererCenterComponentIf<E> renderComponent) {
        this(currOrder, allItems, false, renderClass, renderComponent);
    }

    public OrderChooser(E[] currOrder, E[] allItems, boolean showSelectionButtons, Class<?> renderClass, SelectableItemRendererCenterComponentIf<E> renderComponent) {
        super(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout(0, 3));
        this.mListModel = new DefaultListModel();
        this.setEntries(currOrder, allItems);
        this.mList = new JList<SelectableItem<SelectableItem<E>>>(this.mListModel);
        this.mItemRenderer = new SelectableItemRenderer();
        this.mList.setCellRenderer(this.mItemRenderer);
        if (renderClass != null && renderComponent != null) {
            this.mItemRenderer.setCenterRendererComponent(renderClass, renderComponent);
        }
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mList, this.mList, this);
        new DragAndDropMouseListener<SelectableItem<E>>(this.mList, this.mList, this, dnDHandler);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int index;
                if (evt.getX() < OrderChooser.this.mItemRenderer.getSelectionWidth() && OrderChooser.this.mIsEnabled && (index = OrderChooser.this.mList.locationToIndex(evt.getPoint())) != -1) {
                    SelectableItem item;
                    item.setSelected(!(item = OrderChooser.this.mListModel.elementAt(index)).isSelected());
                    OrderChooser.this.mList.repaint();
                }
            }
        });
        this.mList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    List objs = OrderChooser.this.mList.getSelectedValuesList();
                    for (SelectableItem obj : objs) {
                        obj.setSelected(!obj.isSelected());
                    }
                    OrderChooser.this.mList.repaint();
                }
            }
        });
        this.mScrollPane = new JScrollPane(this.mList);
        main.add((Component)this.mScrollPane, "Center");
        this.add((Component)main, "Center");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel((int)3, (Component)p1), 0, 0));
        this.mButtonPanel = new JPanel(new TabLayout(1));
        this.add((Component)p1, "East");
        p1.add((Component)this.mButtonPanel, "North");
        this.mUpBt = new JButton(TVBrowserIcons.up(22));
        this.mUpBt.setToolTipText(LOCALIZER.msg("tooltip.up", "Move selected rows up"));
        this.mUpBt.addActionListener(e -> UiUtilities.moveSelectedItems(this.mList, -1));
        this.mButtonPanel.add(this.mUpBt);
        this.mDownBt = new JButton(TVBrowserIcons.down(22));
        this.mDownBt.setToolTipText(LOCALIZER.msg("tooltip.down", "Move selected rows down"));
        this.mDownBt.addActionListener(e -> UiUtilities.moveSelectedItems(this.mList, 1));
        this.mButtonPanel.add(this.mDownBt);
        JPanel p3 = new JPanel(new BorderLayout());
        this.mSelectAllBt = new JButton(LOCALIZER.msg("addAll", "Select all items"));
        this.mSelectAllBt.setToolTipText(LOCALIZER.msg("tooltip.all", "Select all items in the list."));
        this.mSelectAllBt.addActionListener(e -> this.selectAll());
        p3.add((Component)this.mSelectAllBt, "West");
        this.mDeSelectAllBt = new JButton(LOCALIZER.msg("delAll", "Deselect all items"));
        this.mDeSelectAllBt.setToolTipText(LOCALIZER.msg("tooltip.none", "Deselect all items in the list."));
        this.mDeSelectAllBt.addActionListener(e -> this.clearSelection());
        p3.add((Component)this.mDeSelectAllBt, "East");
        if (showSelectionButtons) {
            main.add((Component)p3, "South");
        }
    }

    private void setEntries(E[] currOrder, E[] allItems) {
        this.mListModel.removeAllElements();
        for (E element : currOrder) {
            if (!this.contains(allItems, element)) continue;
            SelectableItem<E> item = new SelectableItem<E>(element, true);
            this.mListModel.addElement(item);
        }
        for (int i = 0; i < allItems.length; ++i) {
            if (this.contains(currOrder, allItems[i])) continue;
            SelectableItem<E> item = new SelectableItem<E>(allItems[i], false);
            this.mListModel.addElement(item);
        }
    }

    public JButton getUpButton() {
        return this.mUpBt;
    }

    public JButton getDownButton() {
        return this.mDownBt;
    }

    private boolean contains(Object[] array, Object obj) {
        for (Object element : array) {
            if (!element.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(since="3.4.5")
    public Object[] getOrder() {
        ArrayList<E> objList = new ArrayList<E>();
        for (int i = 0; i < this.mListModel.size(); ++i) {
            SelectableItem<E> item = this.mListModel.elementAt(i);
            if (!item.isSelected()) continue;
            objList.add(item.getItem());
        }
        Object[] asArr = new Object[objList.size()];
        objList.toArray(asArr);
        return asArr;
    }

    public List<E> getOrderList() {
        ArrayList<E> objList = new ArrayList<E>();
        for (int i = 0; i < this.mListModel.size(); ++i) {
            SelectableItem<E> item = this.mListModel.elementAt(i);
            if (!item.isSelected()) continue;
            objList.add(item.getItem());
        }
        return objList;
    }

    public void invertSelection() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem<E> item;
                item.setSelected(!(item = this.mListModel.elementAt(i)).isSelected());
            }
            this.mList.repaint();
        }
    }

    public void selectAll() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem<E> item = this.mListModel.elementAt(i);
                item.setSelected(true);
            }
            this.mList.repaint();
        }
    }

    public void setOrder(E[] currOrder, E[] allItems) {
        this.setEntries(currOrder, allItems);
        this.mList.repaint();
    }

    public void clearSelection() {
        if (this.mIsEnabled) {
            for (int i = 0; i < this.mListModel.size(); ++i) {
                SelectableItem<E> item = this.mListModel.elementAt(i);
                item.setSelected(false);
            }
            this.mList.repaint();
        }
    }

    @Override
    public void drop(JList<SelectableItem<E>> source, JList<SelectableItem<E>> target, int rows, boolean move) {
        UiUtilities.moveSelectedItems(target, rows, true);
    }

    @Override
    public void setEnabled(boolean value) {
        this.mIsEnabled = value;
        this.mItemRenderer.setEnabled(value);
        this.mList.setEnabled(value);
        this.mUpBt.setEnabled(value);
        this.mDownBt.setEnabled(value);
        this.mSelectAllBt.setEnabled(value);
        this.mDeSelectAllBt.setEnabled(value);
        this.mScrollPane.getVerticalScrollBar().setEnabled(value);
        this.mScrollPane.setWheelScrollingEnabled(value);
    }

    public void setSelectionMode(int value) {
        this.mList.setSelectionMode(value);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.mList.addListSelectionListener(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mList.addMouseListener(listener);
    }

    public void refreshList() {
        this.mList.repaint();
    }

    public void addElement(E value) {
        SelectableItem<E> item = new SelectableItem<E>(value, true);
        this.mListModel.addElement(item);
        this.mList.repaint();
    }

    public void removeElementAt(int index) {
        this.mListModel.removeElementAt(index);
        this.mList.repaint();
    }

    public int getSelectedIndex() {
        return this.mList.getSelectedIndex();
    }

    public Object getSelectedValue() {
        if (this.mList.getSelectedValue() != null) {
            SelectableItem<E> item = this.mList.getSelectedValue();
            return item.getItem();
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        this.mList.setSelectedIndex(index);
    }

    public int getItemCount() {
        return this.mList.getModel().getSize();
    }

    public void addButton(JButton button) {
        this.mButtonPanel.add(button);
    }

    public void addElement(E value, int index, boolean selected) {
        SelectableItem<E> item = new SelectableItem<E>(value, selected);
        if (index < this.mListModel.getSize()) {
            this.mListModel.add(index, item);
        } else {
            this.mListModel.addElement(item);
        }
        this.mList.repaint();
    }
}

