/*
 * Decompiled with CFR 0.152.
 */
package util.ui.findasyoutype;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Position;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;

public abstract class FindAction
extends AbstractAction
implements DocumentListener,
KeyListener,
Runnable {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FindAction.class);
    private JTextField mSearchField = new JTextField();
    private JComponent mComponent;
    private boolean mIgnoreCase;
    private boolean mBlockAutoClosing = false;
    private int mWaitTime = 5000;
    private Thread mThread;
    private JLabel mMessage;
    private Color mBg = this.mSearchField.getBackground();
    private Color mFg = this.mSearchField.getForeground();
    private static final Color COLOR_NOT_FOUND = new Color(255, 102, 102);
    protected boolean shiftDown = false;
    protected boolean controlDown = false;
    protected boolean metaDown = false;

    public FindAction(JComponent comp, boolean startAtKeytype) {
        super(mLocalizer.msg("incrementalSearch", "Incremental Search"));
        this.mComponent = comp;
        this.mMessage = new JLabel(mLocalizer.msg("notFound", "Phrase not found"));
        this.mMessage.setIcon(TVBrowserIcons.warning(16));
        this.mMessage.setVisible(false);
        this.install(comp);
        if (startAtKeytype) {
            this.installKeyListener(comp);
        }
    }

    protected void setBlockAutoClosing(boolean value) {
        this.mBlockAutoClosing = value;
    }

    protected boolean isBlockAutoClosing() {
        return this.mBlockAutoClosing;
    }

    protected Thread getThread() {
        return this.mThread;
    }

    protected int getWaitTime() {
        return this.mWaitTime;
    }

    protected void setWaitTime(int value) {
        this.mWaitTime = value;
    }

    protected JLabel getMessageLabel() {
        return this.mMessage;
    }

    protected void reset() {
        this.mSearchField.setBackground(this.mBg);
        this.mSearchField.setForeground(this.mFg);
        this.mMessage.setVisible(false);
    }

    public void prev() {
        this.mWaitTime = 5000;
        this.changed(Position.Bias.Backward);
    }

    public void next() {
        this.mWaitTime = 5000;
        this.changed(Position.Bias.Forward);
    }

    private void start() {
        if (!(this.mThread != null && this.mThread.isAlive() || this.mBlockAutoClosing)) {
            this.mThread = new Thread(this);
            this.mThread.setPriority(1);
            this.mThread.start();
        }
    }

    public boolean isIgnoreCase() {
        return this.mIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.mIgnoreCase = ignoreCase;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.setIgnoreCase((ae.getModifiers() & 1) == 0);
        this.mSearchField.removeActionListener(this);
        this.mSearchField.removeKeyListener(this);
        this.mSearchField.getDocument().removeDocumentListener(this);
        this.initSearch(ae);
        this.mSearchField.addActionListener(this);
        this.mSearchField.addKeyListener(this);
        this.mSearchField.getDocument().addDocumentListener(this);
    }

    protected void initSearch(ActionEvent ae) {
        this.mSearchField.setText("");
        this.reset();
    }

    private void changed(Position.Bias bias) {
        this.mSearchField.requestFocusInWindow();
        if (this.changed(this.mComponent, this.mSearchField.getText(), bias)) {
            this.reset();
        } else {
            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getCanonicalName())) {
                this.mSearchField.setBackground(COLOR_NOT_FOUND);
                this.mSearchField.setForeground(Color.white);
            } else {
                this.mSearchField.setForeground(COLOR_NOT_FOUND);
            }
            this.mMessage.setVisible(true);
        }
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.mWaitTime = 5000;
        this.shiftDown = ke.isShiftDown();
        this.controlDown = ke.isControlDown();
        this.metaDown = ke.isMetaDown();
        switch (ke.getKeyCode()) {
            case 114: {
                this.next();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected JTextField getSearchField() {
        return this.mSearchField;
    }

    public JComponent getComponent() {
        return this.mComponent;
    }

    private void install(JComponent comp) {
        comp.registerKeyboardAction(this, KeyStroke.getKeyStroke(73, 128), 0);
        comp.registerKeyboardAction(this, KeyStroke.getKeyStroke(73, 192), 0);
    }

    public void installKeyListener(Component comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar()) && !e.isControlDown() && !e.isMetaDown()) {
                    FindAction.this.actionPerformed(new ActionEvent(this, 0, "show"));
                    FindAction.this.mSearchField.setText(Character.toString(e.getKeyChar()));
                    FindAction.this.start();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && e.isControlDown()) {
                    FindAction.this.setBlockAutoClosing(true);
                    FindAction.this.actionPerformed(new ActionEvent(this, 0, "show"));
                }
            }
        });
    }
}

