/*
 * Decompiled with CFR 0.152.
 */
package util.ui.persona;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.i18n.Localizer;
import util.ui.ImageIconEnhanced;

public final class PersonaInfo {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PersonaInfo.class);
    static final String DEFAULT_ID = "51b73c81-7d61-4626-b230-89627c9f5ce7";
    static final String RANDOM_ID = "eb365437-e702-4c05-98c2-db5834bb4fa3";
    private File mSettings;
    private String mName;
    private String mDescription;
    private File mHeaderFile;
    private File mFooterFile;
    private Color mTextColor;
    private Color mShadowColor;
    private Color mAccentColor;
    private String mDetailURL;
    private String mId;
    private ImageIcon mIcon;

    PersonaInfo(boolean dummy) {
        this.mName = mLocalizer.msg("randomPersona", "Random Persona");
        this.mDescription = mLocalizer.msg("randomPersonaDesc", "Select random Persona each start");
        this.mId = RANDOM_ID;
        this.mDetailURL = mLocalizer.msg("wikiPage", "http://wiki.tvbrowser.org/index.php/Oberfl%C3%A4che#Personas");
    }

    PersonaInfo() {
        this.mName = mLocalizer.msg("noPersona", "No Persona");
        this.mDescription = mLocalizer.msg("noPersonaDesc", "No Persona selected");
        this.mId = DEFAULT_ID;
        this.mDetailURL = mLocalizer.msg("wikiPage", "http://wiki.tvbrowser.org/index.php/Oberfl%C3%A4che#Personas");
    }

    public PersonaInfo(File settings) throws IndexOutOfBoundsException {
        this.mSettings = settings;
        this.load();
    }

    void load() throws IndexOutOfBoundsException {
        Properties prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.mSettings);
            prop.load(in);
            in.close();
        }
        catch (Exception in) {
            // empty catch block
        }
        this.mName = prop.getProperty("name." + Locale.getDefault().getLanguage(), prop.getProperty("name"));
        this.mDescription = prop.getProperty("description." + Locale.getDefault().getLanguage(), prop.getProperty("description"));
        this.mHeaderFile = this.getImageFile("headerImage", prop, this.mSettings);
        this.mFooterFile = this.getImageFile("footerImage", prop, this.mSettings);
        this.mDetailURL = prop.getProperty("detailURL", mLocalizer.msg("wikiPage", "http://wiki.tvbrowser.org/index.php/Oberfl%C3%A4che#Personas"));
        this.mIcon = null;
        String[] textColor = prop.getProperty("textColor").trim().split(",");
        String[] shadowColor = prop.getProperty("shadowColor").trim().split(",");
        String[] accentColor = prop.getProperty("accentColor").trim().split(",");
        this.mTextColor = new Color(Integer.parseInt(textColor[0]), Integer.parseInt(textColor[1]), Integer.parseInt(textColor[2]));
        this.mShadowColor = new Color(Integer.parseInt(shadowColor[0]), Integer.parseInt(shadowColor[1]), Integer.parseInt(shadowColor[2]));
        this.mAccentColor = new Color(Integer.parseInt(accentColor[0]), Integer.parseInt(accentColor[1]), Integer.parseInt(accentColor[2]));
    }

    private File getImageFile(String key, Properties prop, File file) {
        String value = prop.getProperty(key);
        if (value != null) {
            value = value.replace("{tvb.persona}", file.getParent());
            value = value.replace("{user.persona}", file.getParent());
            return new File(value);
        }
        return null;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getDetailURL() {
        return this.mDetailURL;
    }

    public Color getTextColor() {
        return this.mTextColor;
    }

    public Color getShadowColor() {
        return this.mShadowColor == null ? this.mTextColor : this.mShadowColor;
    }

    public Color getAccentColor() {
        return this.mAccentColor;
    }

    public BufferedImage getHeaderImage() {
        try {
            if (this.mHeaderFile != null) {
                return ImageIO.read(this.mHeaderFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public BufferedImage getFooterImage() {
        try {
            if (this.mFooterFile != null) {
                return ImageIO.read(this.mFooterFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getId() {
        return this.mId == null ? this.mSettings.getParentFile().getName() : this.mId;
    }

    public boolean isEditable() {
        return this.mSettings != null && this.mSettings.getAbsolutePath().replace("\\", "/").startsWith(Settings.getUserSettingsDirName().replace("\\", "/"));
    }

    public ImageIcon getIcon() {
        if (this.mIcon == null) {
            try {
                File test;
                this.mIcon = this.mSettings != null ? ((test = new File(this.mSettings.getParentFile(), "icon")).isFile() ? new ImageIconEnhanced(ImageIO.read(test)) : IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-theme", 22)) : IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-theme", 22);
            }
            catch (IOException e) {
                this.mIcon = IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-theme", 22);
            }
        }
        return this.mIcon;
    }

    public boolean isSelectedPersona() {
        return Settings.LookAndFeel.PERSONA_RANDOM.getBoolean() ? this.getId().equals(RANDOM_ID) : this.getId().equals(Settings.LookAndFeel.PERSONA_SELECTED.getString());
    }

    public static boolean isRandomPersona(PersonaInfo info) {
        return info != null && info.getId().equals(RANDOM_ID);
    }
}

