/*
 * Decompiled with CFR 0.152.
 */
package util.ui.view;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.view.AbstractView;
import util.ui.view.SplitViewProperty;
import util.ui.view.ViewProperty;

public class SplitView
extends AbstractView {
    private Component mComponent;

    @Override
    public void setComponents(Component[] components) {
        if (components.length == 1) {
            this.mComponent = components[0];
        } else if (components.length == 2) {
            JSplitPane splitPane = new JSplitPane();
            for (int i = 0; i < splitPane.getComponentCount(); ++i) {
                splitPane.getComponent(i).setBackground(new Color(0, 0, 0, 0));
            }
            splitPane.setOpaque(false);
            splitPane.setContinuousLayout(true);
            splitPane.setOneTouchExpandable(true);
            splitPane.setLeftComponent(components[0]);
            splitPane.setRightComponent(components[1]);
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!MainFrame.isStarting()) {
                        int fixedWidth;
                        int oldValue = (Integer)evt.getOldValue();
                        int dividerLocation = (Integer)evt.getNewValue();
                        SplitViewProperty prop = (SplitViewProperty)SplitView.this.getProperty();
                        if (prop.getLeftComponentFixed()) {
                            fixedWidth = dividerLocation;
                        } else {
                            int width = SplitView.this.mComponent.getWidth();
                            int height = SplitView.this.mComponent.getHeight();
                            fixedWidth = (prop.getVerticalSplit() ? height : width) - dividerLocation;
                        }
                        if (oldValue >= 0 && fixedWidth >= 0 && prop.getFixedComponentWidth() != fixedWidth) {
                            prop.setFixedComponentWidth(fixedWidth);
                            SplitView.this.update();
                        }
                    }
                }
            });
            this.mComponent = splitPane;
        } else {
            throw new IllegalArgumentException("invalid number of components: " + components.length);
        }
    }

    @Override
    public void update() {
        ViewProperty properties = this.getProperty();
        this.onPropertiesChanged(properties);
    }

    @Override
    protected void onPropertiesChanged(ViewProperty properties) {
        if (this.mComponent instanceof JSplitPane && properties instanceof SplitViewProperty) {
            JSplitPane splitPane = (JSplitPane)this.mComponent;
            SplitViewProperty prop = (SplitViewProperty)properties;
            if (prop.getLeftComponentFixed()) {
                splitPane.setResizeWeight(0.0);
            } else {
                splitPane.setResizeWeight(1.0);
            }
            splitPane.setOrientation(prop.getVerticalSplit() ? 0 : 1);
            int abs = prop.getFixedComponentWidth();
            if (prop.getLeftComponentFixed()) {
                splitPane.setDividerLocation(abs);
            } else {
                int width = this.mComponent.getWidth();
                int height = this.mComponent.getHeight();
                int dividerLocation = (prop.getVerticalSplit() ? height : width) - abs;
                splitPane.setDividerLocation(dividerLocation);
            }
        }
    }

    @Override
    public Component getContent() {
        return this.mComponent;
    }

    @Override
    public void storeProperties() {
        ViewProperty property = this.getProperty();
        if (property instanceof SplitViewProperty && this.mComponent instanceof JSplitPane && !MainFrame.isStarting()) {
            JSplitPane splitPane = (JSplitPane)this.mComponent;
            SplitViewProperty prop = (SplitViewProperty)property;
            Component comp = prop.getLeftComponentFixed() ? splitPane.getLeftComponent() : splitPane.getRightComponent();
            if (comp != null) {
                if (prop.getVerticalSplit()) {
                    prop.setFixedComponentWidth(comp.getHeight());
                } else if (prop.getLeftComponentFixed()) {
                    prop.setFixedComponentWidth(comp.getWidth());
                } else {
                    prop.setFixedComponentWidth(comp.getWidth() + splitPane.getDividerSize());
                }
            }
        }
    }
}

