
// copicatrecord_2_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.500000
 // --table_div  90.560287
 // --table_op  0.025000

struct tablecopicatrecord_2_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicatrecord_2_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicatrecord_2_neg&() const { return *(tablecopicatrecord_2_neg*)this; }
};

 static tablecopicatrecord_2_neg_imp<2048> copicatrecord_2_neg_table __rt_data = {
	0,0.454165,34.1167,2048, {
	0.000000000000,0.000130504252,0.000488004380,0.001006033473,0.001637333092,
	0.002348303370,0.003115056386,0.003920609813,0.004752891478,0.005603320535,
	0.006465798634,0.007335992621,0.008210824509,0.009088108825,0.009966294749,
	0.010844282756,0.011721294233,0.012596778769,0.013470348223,0.014341729846,
	0.015210732936,0.016077225132,0.016941115553,0.017802342803,0.018660866448,
	0.019516660946,0.020369711337,0.021220010173,0.022067555339,0.022912348495,
	0.023754393979,0.024593698018,0.025430268170,0.026264112928,0.027095241437,
	0.027923663294,0.028749388401,0.029572426870,0.030392788946,0.031210484958,
	0.032025525281,0.032837920310,0.033647680444,0.034454816071,0.035259337559,
	0.036061255249,0.036860579453,0.037657320447,0.038451488471,0.039243093728,
	0.040032146382,0.040818656556,0.041602634335,0.042384089762,0.043163032841,
	0.043939473532,0.044713421760,0.045484887405,0.046253880308,0.047020410270,
	0.047784487052,0.048546120374,0.049305319918,0.050062095323,0.050816456192,
	0.051568412086,0.052317972527,0.053065147000,0.053809944949,0.054552375780,
	0.055292448858,0.056030173514,0.056765559037,0.057498614679,0.058229349653,
	0.058957773137,0.059683894268,0.060407722146,0.061129265836,0.061848534363,
	0.062565536716,0.063280281847,0.063992778671,0.064703036067,0.065411062876,
	0.066116867905,0.066820459922,0.067521847660,0.068221039819,0.068918045058,
	0.069612872004,0.070305529247,0.070996025344,0.071684368813,0.072370568141,
	0.073054631776,0.073736568136,0.074416385599,0.075094092514,0.075769697192,
	0.076443207911,0.077114632914,0.077783980413,0.078451258583,0.079116475567,
	0.079779639474,0.080440758381,0.081099840329,0.081756893330,0.082411925359,
	0.083064944360,0.083715958246,0.084364974895,0.085012002153,0.085657047836,
	0.086300119725,0.086941225571,0.087580373092,0.088217569975,0.088852823876,
	0.089486142418,0.090117533194,0.090747003766,0.091374561664,0.092000214387,
	0.092623969404,0.093245834155,0.093865816045,0.094483922453,0.095100160725,
	0.095714538179,0.096327062101,0.096937739749,0.097546578350,0.098153585101,
	0.098758767171,0.099362131698,0.099963685793,0.100563436536,0.101161390978,
	0.101757556142,0.102351939022,0.102944546582,0.103535385761,0.104124463466,
	0.104711786577,0.105297361946,0.105881196398,0.106463296728,0.107043669704,
	0.107622322067,0.108199260530,0.108774491778,0.109348022470,0.109919859237,
	0.110490008682,0.111058477383,0.111625271889,0.112190398723,0.112753864384,
	0.113315675339,0.113875838035,0.114434358886,0.114991244286,0.115546500599,
	0.116100134164,0.116652151294,0.117202558277,0.117751361376,0.118298566826,
	0.118844180838,0.119388209597,0.119930659266,0.120471535977,0.121010845843,
	0.121548594948,0.122084789353,0.122619435094,0.123152538183,0.123684104605,
	0.124214140325,0.124742651279,0.125269643383,0.125795122525,0.126319094573,
	0.126841565368,0.127362540730,0.127882026452,0.128400028306,0.128916552040,
	0.129431603378,0.129945188021,0.130457311648,0.130967979913,0.131477198449,
	0.131984972864,0.132491308745,0.132996211655,0.133499687136,0.134001740707,
	0.134502377863,0.135001604078,0.135499424804,0.135995845472,0.136490871488,
	0.136984508238,0.137476761086,0.137967635374,0.138457136423,0.138945269532,
	0.139432039978,0.139917453017,0.140401513885,0.140884227794,0.141365599938,
	0.141845635488,0.142324339594,0.142801717388,0.143277773976,0.143752514449,
	0.144225943874,0.144698067298,0.145168889748,0.145638416231,0.146106651734,
	0.146573601222,0.147039269642,0.147503661921,0.147966782964,0.148428637658,
	0.148889230871,0.149348567449,0.149806652220,0.150263489992,0.150719085555,
	0.151173443677,0.151626569110,0.152078466584,0.152529140812,0.152978596486,
	0.153426838281,0.153873870853,0.154319698837,0.154764326853,0.155207759499,
	0.155650001356,0.156091056988,0.156530930938,0.156969627732,0.157407151877,
	0.157843507864,0.158278700164,0.158712733230,0.159145611498,0.159577339387,
	0.160007921295,0.160437361607,0.160865664685,0.161292834879,0.161718876517,
	0.162143793912,0.162567591360,0.162990273139,0.163411843508,0.163832306713,
	0.164251666980,0.164669928519,0.165087095522,0.165503172166,0.165918162611,
	0.166332070998,0.166744901455,0.167156658091,0.167567344999,0.167976966256,
	0.168385525923,0.168793028044,0.169199476646,0.169604875743,0.170009229330,
	0.170412541387,0.170814815878,0.171216056751,0.171616267940,0.172015453360,
	0.172413616914,0.172810762486,0.173206893946,0.173602015150,0.173996129936,
	0.174389242129,0.174781355536,0.175172473953,0.175562601156,0.175951740910,
	0.176339896962,0.176727073047,0.177113272882,0.177498500171,0.177882758603,
	0.178266051853,0.178648383580,0.179029757429,0.179410177030,0.179789646001,
	0.180168167942,0.180545746441,0.180922385071,0.181298087391,0.181672856946,
	0.182046697266,0.182419611868,0.182791604256,0.183162677917,0.183532836326,
	0.183902082946,0.184270421222,0.184637854589,0.185004386468,0.185370020263,
	0.185734759370,0.186098607166,0.186461567018,0.186823642279,0.187184836289,
	0.187545152374,0.187904593846,0.188263164006,0.188620866141,0.188977703525,
	0.189333679418,0.189688797068,0.190043059711,0.190396470570,0.190749032853,
	0.191100749757,0.191451624467,0.191801660155,0.192150859979,0.192499227087,
	0.192846764612,0.193193475676,0.193539363390,0.193884430849,0.194228681139,
	0.194572117332,0.194914742491,0.195256559662,0.195597571882,0.195937782177,
	0.196277193558,0.196615809027,0.196953631573,0.197290664171,0.197626909789,
	0.197962371379,0.198297051884,0.198630954234,0.198964081348,0.199296436134,
	0.199628021487,0.199958840292,0.200288895422,0.200618189740,0.200946726095,
	0.201274507327,0.201601536266,0.201927815726,0.202253348516,0.202578137429,
	0.202902185250,0.203225494752,0.203548068696,0.203869909836,0.204191020910,
	0.204511404649,0.204831063771,0.205150000986,0.205468218991,0.205785720473,
	0.206102508108,0.206418584563,0.206733952494,0.207048614545,0.207362573351,
	0.207675831538,0.207988391719,0.208300256498,0.208611428469,0.208921910216,
	0.209231704312,0.209540813320,0.209849239794,0.210156986278,0.210464055304,
	0.210770449397,0.211076171069,0.211381222825,0.211685607159,0.211989326555,
	0.212292383487,0.212594780420,0.212896519810,0.213197604102,0.213498035732,
	0.213797817127,0.214096950704,0.214395438870,0.214693284023,0.214990488553,
	0.215287054839,0.215582985251,0.215878282150,0.216172947888,0.216466984807,
	0.216760395242,0.217053181515,0.217345345943,0.217636890832,0.217927818479,
	0.218218131172,0.218507831191,0.218796920806,0.219085402279,0.219373277863,
	0.219660549801,0.219947220330,0.220233291675,0.220518766055,0.220803645679,
	0.221087932747,0.221371629453,0.221654737978,0.221937260500,0.222219199184,
	0.222500556188,0.222781333662,0.223061533749,0.223341158581,0.223620210282,
	0.223898690970,0.224176602753,0.224453947731,0.224730727996,0.225006945633,
	0.225282602716,0.225557701315,0.225832243487,0.226106231286,0.226379666755,
	0.226652551930,0.226924888839,0.227196679501,0.227467925930,0.227738630130,
	0.228008794097,0.228278419820,0.228547509281,0.228816064453,0.229084087303,
	0.229351579787,0.229618543858,0.229884981458,0.230150894522,0.230416284980,
	0.230681154751,0.230945505750,0.231209339881,0.231472659044,0.231735465128,
	0.231997760019,0.232259545593,0.232520823719,0.232781596258,0.233041865067,
	0.233301631992,0.233560898874,0.233819667546,0.234077939836,0.234335717561,
	0.234593002534,0.234849796561,0.235106101440,0.235361918962,0.235617250912,
	0.235872099066,0.236126465197,0.236380351067,0.236633758433,0.236886689047,
	0.237139144651,0.237391126982,0.237642637770,0.237893678739,0.238144251605,
	0.238394358079,0.238643999864,0.238893178657,0.239141896149,0.239390154023,
	0.239637953957,0.239885297622,0.240132186683,0.240378622797,0.240624607617,
	0.240870142788,0.241115229949,0.241359870732,0.241604066765,0.241847819667,
	0.242091131053,0.242334002530,0.242576435700,0.242818432158,0.243059993493,
	0.243301121290,0.243541817125,0.243782082568,0.244021919186,0.244261328537,
	0.244500312174,0.244738871645,0.244977008489,0.245214724243,0.245452020436,
	0.245688898592,0.245925360227,0.246161406853,0.246397039978,0.246632261100,
	0.246867071715,0.247101473310,0.247335467369,0.247569055370,0.247802238784,
	0.248035019076,0.248267397708,0.248499376134,0.248730955803,0.248962138159,
	0.249192924640,0.249423316678,0.249653315702,0.249882923132,0.250112140384,
	0.250340968871,0.250569409996,0.250797465159,0.251025135757,0.251252423177,
	0.251479328804,0.251705854017,0.251932000189,0.252157768688,0.252383160877,
	0.252608178114,0.252832821751,0.253057093137,0.253280993612,0.253504524514,
	0.253727687176,0.253950482923,0.254172913079,0.254394978959,0.254616681875,
	0.254838023134,0.255059004038,0.255279625884,0.255499889963,0.255719797563,
	0.255939349965,0.256158548446,0.256377394279,0.256595888730,0.256814033064,
	0.257031828536,0.257249276401,0.257466377905,0.257683134294,0.257899546804,
	0.258115616671,0.258331345123,0.258546733385,0.258761782677,0.258976494213,
	0.259190869205,0.259404908859,0.259618614375,0.259831986951,0.260045027779,
	0.260257738046,0.260470118936,0.260682171627,0.260893897294,0.261105297107,
	0.261316372230,0.261527123824,0.261737553046,0.261947661047,0.262157448976,
	0.262366917976,0.262576069185,0.262784903739,0.262993422767,0.263201627395,
	0.263409518745,0.263617097935,0.263824366078,0.264031324282,0.264237973652,
	0.264444315290,0.264650350290,0.264856079747,0.265061504746,0.265266626373,
	0.265471445707,0.265675963824,0.265880181796,0.266084100689,0.266287721568,
	0.266491045492,0.266694073517,0.266896806693,0.267099246069,0.267301392687,
	0.267503247587,0.267704811806,0.267906086373,0.268107072318,0.268307770664,
	0.268508182431,0.268708308635,0.268908150288,0.269107708398,0.269306983971,
	0.269505978007,0.269704691503,0.269903125452,0.270101280843,0.270299158663,
	0.270496759893,0.270694085511,0.270891136492,0.271087913808,0.271284418424,
	0.271480651304,0.271676613409,0.271872305694,0.272067729112,0.272262884613,
	0.272457773141,0.272652395639,0.272846753044,0.273040846291,0.273234676312,
	0.273428244034,0.273621550382,0.273814596275,0.274007382632,0.274199910366,
	0.274392180387,0.274584193602,0.274775950914,0.274967453224,0.275158701427,
	0.275349696418,0.275540439086,0.275730930317,0.275921170994,0.276111161998,
	0.276300904205,0.276490398488,0.276679645716,0.276868646757,0.277057402473,
	0.277245913725,0.277434181369,0.277622206259,0.277809989246,0.277997531176,
	0.278184832893,0.278371895239,0.278558719050,0.278745305161,0.278931654404,
	0.279117767606,0.279303645593,0.279489289186,0.279674699205,0.279859876464,
	0.280044821777,0.280229535954,0.280414019800,0.280598274119,0.280782299712,
	0.280966097376,0.281149667905,0.281333012092,0.281516130724,0.281699024587,
	0.281881694464,0.282064141134,0.282246365373,0.282428367957,0.282610149654,
	0.282791711235,0.282973053462,0.283154177099,0.283335082905,0.283515771636,
	0.283696244046,0.283876500885,0.284056542902,0.284236370842,0.284415985447,
	0.284595387456,0.284774577606,0.284953556632,0.285132325264,0.285310884231,
	0.285489234259,0.285667376070,0.285845310385,0.286023037922,0.286200559395,
	0.286377875516,0.286554986996,0.286731894540,0.286908598854,0.287085100639,
	0.287261400593,0.287437499413,0.287613397792,0.287789096423,0.287964595992,
	0.288139897186,0.288315000689,0.288489907181,0.288664617340,0.288839131843,
	0.289013451361,0.289187576566,0.289361508126,0.289535246706,0.289708792970,
	0.289882147578,0.290055311188,0.290228284455,0.290401068034,0.290573662575,
	0.290746068725,0.290918287132,0.291090318437,0.291262163284,0.291433822309,
	0.291605296149,0.291776585439,0.291947690809,0.292118612889,0.292289352305,
	0.292459909683,0.292630285643,0.292800480806,0.292970495789,0.293140331207,
	0.293309987674,0.293479465799,0.293648766190,0.293817889455,0.293986836195,
	0.294155607014,0.294324202510,0.294492623279,0.294660869918,0.294828943017,
	0.294996843167,0.295164570957,0.295332126973,0.295499511797,0.295666726011,
	0.295833770195,0.296000644926,0.296167350779,0.296333888326,0.296500258138,
	0.296666460784,0.296832496831,0.296998366841,0.297164071379,0.297329611003,
	0.297494986272,0.297660197742,0.297825245966,0.297990131497,0.298154854883,
	0.298319416673,0.298483817413,0.298648057645,0.298812137912,0.298976058752,
	0.299139820704,0.299303424303,0.299466870082,0.299630158572,0.299793290305,
	0.299956265806,0.300119085601,0.300281750215,0.300444260168,0.300606615981,
	0.300768818171,0.300930867254,0.301092763744,0.301254508153,0.301416100991,
	0.301577542767,0.301738833986,0.301899975152,0.302060966769,0.302221809338,
	0.302382503356,0.302543049320,0.302703447727,0.302863699069,0.303023803837,
	0.303183762521,0.303343575609,0.303503243586,0.303662766937,0.303822146144,
	0.303981381688,0.304140474046,0.304299423697,0.304458231115,0.304616896774,
	0.304775421144,0.304933804697,0.305092047900,0.305250151220,0.305408115121,
	0.305565940066,0.305723626516,0.305881174930,0.306038585767,0.306195859483,
	0.306352996531,0.306509997365,0.306666862435,0.306823592191,0.306980187080,
	0.307136647549,0.307292974041,0.307449166999,0.307605226864,0.307761154076,
	0.307916949072,0.308072612288,0.308228144160,0.308383545118,0.308538815596,
	0.308693956022,0.308848966825,0.309003848430,0.309158601264,0.309313225749,
	0.309467722306,0.309622091357,0.309776333319,0.309930448609,0.310084437644,
	0.310238300837,0.310392038600,0.310545651344,0.310699139479,0.310852503412,
	0.311005743550,0.311158860297,0.311311854057,0.311464725232,0.311617474221,
	0.311770101424,0.311922607238,0.312074992059,0.312227256281,0.312379400297,
	0.312531424499,0.312683329277,0.312835115018,0.312986782111,0.313138330940,
	0.313289761891,0.313441075346,0.313592271686,0.313743351292,0.313894314542,
	0.314045161813,0.314195893480,0.314346509919,0.314497011503,0.314647398602,
	0.314797671587,0.314947830827,0.315097876690,0.315247809541,0.315397629746,
	0.315547337667,0.315696933668,0.315846418108,0.315995791346,0.316145053742,
	0.316294205652,0.316443247430,0.316592179432,0.316741002010,0.316889715516,
	0.317038320299,0.317186816708,0.317335205092,0.317483485796,0.317631659166,
	0.317779725544,0.317927685274,0.318075538697,0.318223286153,0.318370927980,
	0.318518464516,0.318665896096,0.318813223057,0.318960445731,0.319107564451,
	0.319254579548,0.319401491353,0.319548300193,0.319695006397,0.319841610291,
	0.319988112199,0.320134512447,0.320280811356,0.320427009248,0.320573106444,
	0.320719103262,0.320865000021,0.321010797037,0.321156494627,0.321302093103,
	0.321447592781,0.321592993972,0.321738296986,0.321883502134,0.322028609725,
	0.322173620066,0.322318533463,0.322463350221,0.322608070646,0.322752695039,
	0.322897223703,0.323041656939,0.323185995046,0.323330238323,0.323474387066,
	0.323618441574,0.323762402140,0.323906269060,0.324050042626,0.324193723130,
	0.324337310863,0.324480806115,0.324624209174,0.324767520329,0.324910739867,
	0.325053868072,0.325196905229,0.325339851623,0.325482707534,0.325625473245,
	0.325768149036,0.325910735186,0.326053231974,0.326195639677,0.326337958571,
	0.326480188932,0.326622331033,0.326764385148,0.326906351548,0.327048230506,
	0.327190022292,0.327331727174,0.327473345420,0.327614877299,0.327756323076,
	0.327897683016,0.328038957384,0.328180146443,0.328321250455,0.328462269682,
	0.328603204384,0.328744054820,0.328884821249,0.329025503929,0.329166103116,
	0.329306619065,0.329447052032,0.329587402269,0.329727670031,0.329867855568,
	0.330007959132,0.330147980973,0.330287921339,0.330427780479,0.330567558641,
	0.330707256070,0.330846873012,0.330986409712,0.331125866413,0.331265243358,
	0.331404540789,0.331543758947,0.331682898071,0.331821958402,0.331960940176,
	0.332099843633,0.332238669008,0.332377416537,0.332516086454,0.332654678995,
	0.332793194391,0.332931632876,0.333069994679,0.333208280033,0.333346489167,
	0.333484622309,0.333622679688,0.333760661530,0.333898568062,0.334036399510,
	0.334174156097,0.334311838049,0.334449445588,0.334586978935,0.334724438314,
	0.334861823943,0.334999136043,0.335136374832,0.335273540530,0.335410633353,
	0.335547653517,0.335684601239,0.335821476733,0.335958280213,0.336095011893,
	0.336231671986,0.336368260703,0.336504778255,0.336641224853,0.336777600706,
	0.336913906022,0.337050141009,0.337186305876,0.337322400827,0.337458426070,
	0.337594381808,0.337730268245,0.337866085586,0.338001834033,0.338137513787,
	0.338273125050,0.338408668023,0.338544142904,0.338679549894,0.338814889189,
	0.338950160988,0.339085365487,0.339220502883,0.339355573371,0.339490577144,
	0.339625514398,0.339760385325,0.339895190119,0.340029928969,0.340164602069,
	0.340299209607,0.340433751774,0.340568228759,0.340702640749,0.340836987933,
	0.340971270498,0.341105488628,0.341239642511,0.341373732331,0.341507758272,
	0.341641720518,0.341775619250,0.341909454653,0.342043226906,0.342176936191,
	0.342310582688,0.342444166577,0.342577688035,0.342711147242,0.342844544375,
	0.342977879611,0.343111153126,0.343244365095,0.343377515694,0.343510605097,
	0.343643633477,0.343776601007,0.343909507861,0.344042354209,0.344175140222,
	0.344307866072,0.344440531928,0.344573137959,0.344705684334,0.344838171221,
	0.344970598787,0.345102967199,0.345235276624,0.345367527226,0.345499719171,
	0.345631852624,0.345763927747,0.345895944704,0.346027903657,0.346159804769,
	0.346291648201,0.346423434113,0.346555162666,0.346686834020,0.346818448333,
	0.346950005764,0.347081506470,0.347212950609,0.347344338338,0.347475669813,
	0.347606945189,0.347738164621,0.347869328264,0.348000436272,0.348131488797,
	0.348262485993,0.348393428012,0.348524315005,0.348655147123,0.348785924517,
	0.348916647337,0.349047315732,0.349177929851,0.349308489843,0.349438995855,
	0.349569448034,0.349699846528,0.349830191481,0.349960483041,0.350090721351,
	0.350220906557,0.350351038803,0.350481118231,0.350611144986,0.350741119209,
	0.350871041043,0.351000910628,0.351130728106,0.351260493617,0.351390207302,
	0.351519869298,0.351649479746,0.351779038784,0.351908546548,0.352038003178,
	0.352167408809,0.352296763578,0.352426067621,0.352555321073,0.352684524069,
	0.352813676743,0.352942779230,0.353071831662,0.353200834172,0.353329786893,
	0.353458689957,0.353587543495,0.353716347639,0.353845102518,0.353973808262,
	0.354102465002,0.354231072866,0.354359631983,0.354488142481,0.354616604488,
	0.354745018130,0.354873383535,0.355001700828,0.355129970137,0.355258191585,
	0.355386365297,0.355514491400,0.355642570015,0.355770601267,0.355898585279,
	0.356026522173,0.356154412072,0.356282255097,0.356410051370,0.356537801011,
	0.356665504141,0.356793160880,0.356920771347,0.357048335662,0.357175853943,
	0.357303326308,0.357430752875,0.357558133762,0.357685469085,0.357812758961,
	0.357940003506,0.358067202836,0.358194357066,0.358321466311,0.358448530684,
	0.358575550301,0.358702525275,0.358829455719,0.358956341745,0.359083183466,
	0.359209980994,0.359336734441,0.359463443917,0.359590109534,0.359716731401,
	0.359843309628,0.359969844326,0.360096335602,0.360222783567,0.360349188328,
	0.360475549992,0.360601868669,0.360728144463,0.360854377484,0.360980567836,
	0.361106715626,0.361232820960,0.361358883942,0.361484904678,0.361610883271,
	0.361736819826,0.361862714447,0.361988567237,0.362114378299,0.362240147735,
	0.362365875648,0.362491562139,0.362617207310,0.362742811261,0.362868374095,
	0.362993895910,0.363119376807,0.363244816886,0.363370216246,0.363495574985,
	0.363620893203,0.363746170997,0.363871408465,0.363996605705,0.364121762813,
	0.364246879887,0.364371957023,0.364496994317,0.364621991865,0.364746949761,
	0.364871868102,0.364996746981,0.365121586494,0.365246386733,0.365371147793,
	0.365495869767,0.365620552748,0.365745196828,0.365869802100,0.365994368656,
	0.366118896587,0.366243385985,0.366367836941,0.366492249545,0.366616623887,
	0.366740960058,0.366865258147,0.366989518243,0.367113740436,0.367237924814,
	0.367362071465,0.367486180478,0.367610251940,0.367734285939,0.367858282561,
	0.367982241894,0.368106164024,0.368230049036,0.368353897018,0.368477708054,
	0.368601482229,0.368725219628,0.368848920337,0.368972584439,0.369096212018,
	0.369219803158,0.369343357942,0.369466876454,0.369590358776,0.369713804990,
	0.369837215179,0.369960589424,0.370083927808,0.370207230411,0.370330497314,
	0.370453728599,0.370576924345,0.370700084632,0.370823209541,0.370946299151,
	0.371069353541,0.371192372789,0.371315356976,0.371438306179,0.371561220476,
	0.371684099945,0.371806944663,0.371929754709,0.372052530158,0.372175271088,
	0.372297977574,0.372420649694,0.372543287522,0.372665891135,0.372788460607,
	0.372910996015,0.373033497432,0.373155964933,0.373278398593,0.373400798485,
	0.373523164682,0.373645497260,0.373767796290,0.373890061845,0.374012293999,
	0.374134492823,0.374256658389,0.374378790770,0.374500890038,0.374622956262,
	0.374744989515,0.374866989868,0.374988957390,0.375110892153,0.375232794226,
	0.375354663678,0.375476500581,0.375598305002,0.375720077012,0.375841816678,
	0.375963524069,0.376085199254,0.376206842301,0.376328453277,0.376450032250,
	0.376571579288,0.376693094457,0.376814577824,0.376936029457,0.377057449421,
	0.377178837782,0.377300194606,0.377421519959,0.377542813907,0.377664076514,
	0.377785307846,0.377906507966,0.378027676941,0.378148814833,0.378269921707,
	0.378390997627,0.378512042656,0.378633056857,0.378754040294,0.378874993030,
	0.378995915127,0.379116806647,0.379237667653,0.379358498206,0.379479298369,
	0.379600068203,0.379720807769,0.379841517128,0.379962196342,0.380082845470,
	0.380203464573,0.380324053712,0.380444612946,0.380565142336,0.380685641940,
	0.380806111818,0.380926552029,0.381046962633,0.381167343687,0.381287695250,
	0.381408017381,0.381528310138,0.381648573578,0.381768807759,0.381889012739,
	0.382009188575,0.382129335323,0.382249453041,0.382369541786,0.382489601613,
	0.382609632579,0.382729634740,0.382849608152,0.382969552870,0.383089468951,
	0.383209356448,0.383329215417,0.383449045913,0.383568847990,0.383688621704,
	0.383808367108,0.383928084255,0.384047773201,0.384167433999,0.384287066702,
	0.384406671363,0.384526248035,0.384645796772,0.384765317626,0.384884810650,
	0.385004275895,0.385123713415,0.385243123260,0.385362505484,0.385481860136,
	0.385601187269,0.385720486934,0.385839759182,0.385959004064,0.386078221630,
	0.386197411931,0.386316575018,0.386435710939,0.386554819746,0.386673901487,
	0.386792956213,0.386911983974,0.387030984817,0.387149958792,0.387268905949,
	0.387387826335,0.387506720000,0.387625586991,0.387744427357,0.387863241146,
	0.387982028406,0.388100789183,0.388219523527,0.388338231484,0.388456913101,
	0.388575568425,0.388694197503,0.388812800382,0.388931377108,0.389049927728,
	0.389168452287,0.389286950832,0.389405423408,0.389523870062,0.389642290838,
	0.389760685782,0.389879054938,0.389997398354,0.390115716071,0.390234008137,
	0.390352274595,0.390470515489,0.390588730864,0.390706920764,0.390825085232,
	0.390943224313,0.391061338049,0.391179426485,0.391297489664,0.391415527629,
	0.391533540422,0.391651528087,0.391769490666,0.391887428201,0.392005340736,
	0.392123228312,0.392241090971,0.392358928756,0.392476741708,0.392594529868,
	0.392712293278,0.392830031979,0.392947746013,0.393065435421,0.393183100242,
	0.393300740519,0.393418356292,0.393535947601,0.393653514486,0.393771056987,
	0.393888575145,0.394006069000,0.394123538591,0.394240983957,0.394358405138,
	0.394475802174,0.394593175104,0.394710523966,0.394827848800,0.394945149643,
	0.395062426536,0.395179679516,0.395296908621,0.395414113891,0.395531295362,
	0.395648453073,0.395765587061,0.395882697365,0.395999784022,0.396116847068,
	0.396233886542,0.396350902481,0.396467894921,0.396584863899,0.396701809453,
	0.396818731618,0.396935630431,0.397052505929,0.397169358148,0.397286187123,
	0.397402992891,0.397519775487,0.397636534948,0.397753271309,0.397869984605,
	0.397986674871,0.398103342143,0.398219986456,0.398336607845,0.398453206345,
	0.398569781989,0.398686334814,0.398802864853,0.398919372141,0.399035856712,
	0.399152318599,0.399268757838,0.399385174461,0.399501568503,0.399617939997,
	0.399734288976,0.399850615475,0.399966919526,0.400083201162,0.400199460417,
	0.400315697323,0.400431911913,0.400548104220,0.400664274276,0.400780422114,
	0.400896547766,0.401012651264,0.401128732641,0.401244791928,0.401360829157,
	0.401476844361,0.401592837570,0.401708808816,0.401824758131,0.401940685545,
	0.402056591091,0.402172474799,0.402288336701,0.402404176826,0.402519995207,
	0.402635791872,0.402751566854,0.402867320183,0.402983051888,0.403098762000,
	0.403214450550,0.403330117567,0.403445763080,0.403561387121,0.403676989718,
	0.403792570902,0.403908130701,0.404023669146,0.404139186264,0.404254682087,
	0.404370156642,0.404485609958,0.404601042065,0.404716452991,0.404831842766,
	0.404947211416,0.405062558972,0.405177885461,0.405293190912,0.405408475352,
	0.405523738810,0.405638981314,0.405754202892,0.405869403571,0.405984583380,
	0.406099742345,0.406214880494,0.406329997856,0.406445094456,0.406560170322,
	0.406675225481,0.406790259960,0.406905273787,0.407020266988,0.407135239589,
	0.407250191618,0.407365123101,0.407480034063,0.407594924533,0.407709794535,
	0.407824644097,0.407939473244,0.408054282002,0.408169070397,0.408283838454,
	0.408398586201,0.408513313661,0.408628020862,0.408742707827,0.408857374583,
	0.408972021155,0.409086647568,0.409201253847,0.409315840017,0.409430406104,
	0.409544952131,0.409659478123,0.409773984106,0.409888470104,0.410002936140,
	0.410117382241,0.410231808430,0.410346214731,0.410460601168,0.410574967766,
	0.410689314548,0.410803641539,0.410917948762,0.411032236240,0.411146503999,
	0.411260752060,0.411374980448,0.411489189186,0.411603378297,0.411717547805,
	0.411831697732,0.411945828103,0.412059938939,0.412174030263,0.412288102100,
	0.412402154470,0.412516187398,0.412630200905,0.412744195014,0.412858169748,
	0.412972125129,0.413086061179,0.413199977920,0.413313875375,0.413427753566,
	0.413541612514,0.413655452241,0.413769272770,0.413883074122,0.413996856319,
	0.414110619382,0.414224363333,0.414338088194,0.414451793985,0.414565480728,
	0.414679148444,0.414792797155,0.414906426882,0.415020037644,0.415133629465,
	0.415247202364,0.415360756361,0.415474291479,0.415587807737,0.415701305157,
	0.415814783758,0.415928243561,0.416041684586,0.416155106854,0.416268510385,
	0.416381895199,0.416495261317,0.416608608757,0.416721937541,0.416835247688,
	0.416948539217,0.417061812150,0.417175066504,0.417288302301,0.417401519559,
	0.417514718298,0.417627898537,0.417741060296,0.417854203594,0.417967328450,
	0.418080434883,0.418193522913,0.418306592558,0.418419643837,0.418532676770,
	0.418645691375,0.418758687670,0.418871665675,0.418984625408,0.419097566888,
	0.419210490133,0.419323395162,0.419436281993,0.419549150644,0.419662001133,
	0.419774833479,0.419887647700,0.420000443814,0.420113221839,0.420225981793,
	0.420338723693,0.420451447558,0.420564153406,0.420676841253,0.420789511118,
	0.420902163018,0.421014796970,0.421127412993,0.421240011104,0.421352591319,
	0.421465153656,0.421577698133,0.421690224766,0.421802733573,0.421915224571,
	0.422027697776,0.422140153206,0.422252590877,0.422365010806,0.422477413011,
	0.422589797507,0.422702164311,0.422814513440,0.422926844911,0.423039158740,
	0.423151454943,0.423263733536,0.423375994537,0.423488237961,0.423600463824,
	0.423712672143,0.423824862933,0.423937036212,0.424049191993,0.424161330295,
	0.424273451132,0.424385554520,0.424497640475,0.424609709012,0.424721760148,
	0.424833793898,0.424945810278,0.425057809303,0.425169790988,0.425281755348,
	0.425393702400,0.425505632159,0.425617544639,0.425729439856,0.425841317825,
	0.425953178561,0.426065022080,0.426176848395,0.426288657523,0.426400449477,
	0.426512224273,0.426623981926,0.426735722450,0.426847445859,0.426959152170,
	0.427070841395,0.427182513551,0.427294168650,0.427405806708,0.427517427739,
	0.427629031757,0.427740618777,0.427852188813,0.427963741879,0.428075277989,
	0.428186797157,0.428298299398,0.428409784725,0.428521253153,0.428632704694,
	0.428744139364,0.428855557176,0.428966958143,0.429078342280,0.429189709600,
	0.429301060117,0.429412393844,0.429523710795,0.429635010984,0.429746294423,
	0.429857561127,0.429968811108,0.430080044380,0.430191260956,0.430302460850,
	0.430413644075,0.430524810643,0.430635960568,0.430747093863,0.430858210541,
	0.430969310615,0.431080394098,0.431191461003,0.431302511342,0.431413545129,
	0.431524562376,0.431635563096,0.431746547301,0.431857515005,0.431968466219,
	0.432079400957,0.432190319230,0.432301221052,0.432412106435,0.432522975391,
	0.432633827932,0.432744664071,0.432855483820,0.432966287191,0.433077074197,
	0.433187844849,0.433298599160,0.433409337142,0.433520058806,0.433630764165,
	0.433741453231,0.433852126016,0.433962782531,0.434073422788,0.434184046799,
	0.434294654576,0.434405246131,0.434515821475,0.434626380620,0.434736923577,
	0.434847450358,0.434957960975,0.435068455438,0.435178933761,0.435289395953,
	0.435399842026,0.435510271992,0.435620685861,0.435731083646,0.435841465357,
	0.435951831006,0.436062180603,0.436172514160,0.436282831688,0.436393133198,
	0.436503418700,0.436613688207,0.436723941729,0.436834179276,0.436944400859,
	0.437054606491,0.437164796180,0.437274969938,0.437385127776,0.437495269705,
	0.437605395734,0.437715505875,0.437825600138,0.437935678534,0.438045741074,
	0.438155787767,0.438265818624,0.438375833656,0.438485832873,0.438595816286,
	0.438705783904,0.438815735738,0.438925671798,0.439035592095,0.439145496638,
	0.439255385439,0.439365258506,0.439475115850,0.439584957481,0.439694783409,
	0.439804593644,0.439914388196,0.440024167075,0.440133930291,0.440243677854,
	0.440353409773,0.440463126058,0.440572826720,0.440682511767,0.440792181210,
	0.440901835058,0.441011473321,0.441121096008,0.441230703130,0.441340294695,
	0.441449870713,0.441559431193,0.441668976146,0.441778505580,0.441888019505,
	0.441997517931,0.442107000866,0.442216468320,0.442325920302,0.442435356821,
	0.442544777888,0.442654183510,0.442763573697,0.442872948458,0.442982307803,
	0.443091651740,0.443200980278,0.443310293427,0.443419591195,0.443528873592,
	0.443638140626,0.443747392306,0.443856628641,0.443965849641,0.444075055313,
	0.444184245667,0.444293420711,0.444402580454,0.444511724905,0.444620854073,
	0.444729967966,0.444839066592,0.444948149961,0.445057218081,0.445166270961,
	0.445275308609,0.445384331033,0.445493338242,0.445602330245,0.445711307050,
	0.445820268665,0.445929215099,0.446038146360,0.446147062456,0.446255963396,
	0.446364849188,0.446473719839,0.446582575360,0.446691415757,0.446800241038,
	0.446909051213,0.447017846288,0.447126626273,0.447235391174,0.447344141001,
	0.447452875761,0.447561595462,0.447670300112,0.447778989720,0.447887664292,
	0.447996323837,0.448104968363,0.448213597878,0.448322212389,0.448430811904,
	0.448539396431,0.448647965978,0.448756520552,0.448865060162,0.448973584814,
	0.449082094517,0.449190589278,0.449299069105,0.449407534005,0.449515983986,
	0.449624419055,0.449732839221,0.449841244489,0.449949634869,0.450058010367,
	0.450166370990,0.450274716747,0.450383047645,0.450491363690,0.450599664891,
	0.450707951254,0.450816222787,0.450924479497,0.451032721391,0.451140948477,
	0.451249160762,0.451357358253,0.451465540957,0.451573708881,0.451681862033,
	0.451790000419,0.451898124047,0.452006232923,0.452114327055,0.452222406450,
	0.452330471114,0.452438521055,0.452546556279,0.452654576794,0.452762582607,
	0.452870573724,0.452978550152,0.453086511898,0.453194458968,0.453302391371,
	0.453410309112,0.453518212198,0.453626100636,0.453733974433,0.453841833595,
	0.453949678129,0.454057508042,0.454165323341
	}
};

double always_inline copicatrecord_2_negclip(double x) {
    double f = fabs(x);
    f = f * copicatrecord_2_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicatrecord_2_neg_table.data[0];
    } else if (i >= copicatrecord_2_neg_table.size-1) {
        f = copicatrecord_2_neg_table.data[copicatrecord_2_neg_table.size-1];
    } else {
    f -= i;
    f = copicatrecord_2_neg_table.data[i]*(1-f) + copicatrecord_2_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

