/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.hr;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "falklandsko standardno vrijeme",
               "FIST",
               "falklandsko ljetno vrijeme",
               "FIST",
               "falklandsko vrijeme",
               "FIT",
            };
        final String[] Cape_Verde = new String[] {
               "standardno vrijeme Zelenortskog oto\u010dja",
               "CVST",
               "ljetno vrijeme Zelenortskog oto\u010dja",
               "CVST",
               "vrijeme Zelenortskog oto\u010dja",
               "CVT",
            };
        final String[] GMT = new String[] {
               "univerzalno vrijeme",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "vrijeme Ponapea",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Omsko standardno vrijeme",
               "OST",
               "Omsko ljetno vrijeme",
               "OST",
               "Omsko vrijeme",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "vrijeme Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsko standardno vrijeme",
               "HAST",
               "havajsko-aleutsko ljetno vrijeme",
               "HADT",
               "havajsko-aleutsko vrijeme",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinsko standardno vrijeme",
               "SST",
               "Sahalinsko ljetno vrijeme",
               "SST",
               "Sahalinsko vrijeme",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "jakutsko standardno vrijeme",
               "YST",
               "jakutsko ljetno vrijeme",
               "YST",
               "jakutsko vrijeme",
               "YT",
            };
        final String[] Gambier = new String[] {
               "vrijeme Gambiera",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Maldives = new String[] {
               "vrijeme Maldiva",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Truk = new String[] {
               "vrijeme Truka",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "japansko standardno vrijeme",
               "JST",
               "japansko ljetno vrijeme",
               "JDT",
               "japansko vrijeme",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "vladivosto\u010dko standardno vrijeme",
               "VST",
               "vladivosto\u010dko ljetno vrijeme",
               "VST",
               "vladivosto\u010dko vrijeme",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "zapadnoeuropsko standardno vrijeme",
               "WET",
               "zapadnoeuropsko ljetno vrijeme",
               "WEST",
               "zapadnoeuropsko vrijeme",
               "WET",
            };
        final String[] Marquesas = new String[] {
               "vrijeme Marquesasa",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Wake = new String[] {
               "vrijeme Otoka Wake",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Hovd = new String[] {
               "Hovdsko standardno vrijeme",
               "HST",
               "Hovdsko ljetno vrijeme",
               "HST",
               "Hovdsko vrijeme",
               "HT",
            };
        final String[] Tokelau = new String[] {
               "vrijeme Tokelau",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "vrijeme Gilbertovih Otoka",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Mongolia = new String[] {
               "ulan-batorsko standardno vrijeme",
               "UBST",
               "ulan-batorsko ljetno vrijeme",
               "UBST",
               "ulan-batorsko vrijeme",
               "UBT",
            };
        final String[] Palau = new String[] {
               "vrijeme Palaua",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "standardno vrijeme Nove Kaledonije",
               "NCST",
               "ljetno vrijeme Nove Kaledonije",
               "NCST",
               "vrijeme Nove Kaledonije",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "vrijeme Naurua",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "pacifi\u010dko standardno vrijeme",
               "PST",
               "pacifi\u010dko ljetno vrijeme",
               "PDT",
               "pacifi\u010dko vrijeme",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "zapadno-argentinsko standardno vrijeme",
               "WAST",
               "zapadno-argentinsko ljetno vrijeme",
               "WAST",
               "zapadno-argentinsko vrijeme",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "vrijeme Galapagosa",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Christmas = new String[] {
               "vrijeme Bo\u017ei\u0107nog Otoka",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "volgogradsko standardno vrijeme",
               "VST",
               "volgogradsko ljetno vrijeme",
               "VST",
               "volgogradsko vrijeme",
               "VT",
            };
        final String[] Korea = new String[] {
               "korejsko standardno vrijeme",
               "KST",
               "korejsko ljetno vrijeme",
               "KDT",
               "korejsko vrijeme",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "standardno vrijeme Vanuatu",
               "VST",
               "ljetno vrijeme Vanuatu",
               "VST",
               "vrijeme Vanuatu",
               "VT",
            };
        final String[] Argentina = new String[] {
               "argentinsko standardno vrijeme",
               "AST",
               "argentinsko ljetno vrijeme",
               "AST",
               "argentinsko vrijeme",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "standardno vrijeme otoka Lord Howe",
               "LHST",
               "ljetno vrijeme otoka Lord Howe",
               "LHDT",
               "vrijeme otoka Lord Howe",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "vrijeme Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Arabian = new String[] {
               "arapsko standardno vrijeme",
               "AST",
               "arapsko ljetno vrijeme",
               "ADT",
               "arapsko vrijeme",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "isto\u010dno australsko standardno vrijeme",
               "AEST",
               "isto\u010dno australsko ljetno vrijeme",
               "AEDT",
               "isto\u010dno australsko vrijeme",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsko standardno vrijeme",
               "IST",
               "Irkutsko ljetno vrijeme",
               "IST",
               "Irkutsko vrijeme",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "standardno vrijeme Mauricijusa",
               "MST",
               "ljetno vrijeme Mauricijusa",
               "MST",
               "vrijeme Mauricijusa",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "vrijeme Indijskog oceana",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsansko standardno vrijeme",
               "CST",
               "Choibalsansko ljetno vrijeme",
               "CST",
               "Choibalsansko vrijeme",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "isto\u010dno standardno vrijeme",
               "EST",
               "isto\u010dno ljetno vrijeme",
               "EDT",
               "isto\u010dno vrijeme",
               "ET",
            };
        final String[] Australia_CentralWestern = new String[] {
               "australsko sredi\u0161nje zapadno standardno vrijeme",
               "ACWST",
               "australsko sredi\u0161nje zapadno ljetno vrijeme",
               "ACWDT",
               "australsko sredi\u0161nje zapadno vrijeme",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "zapadno australsko standardno vrijeme",
               "AWST",
               "zapadno australsko ljetno vrijeme",
               "AWDT",
               "zapadno australsko vrijeme",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsko standardno vrijeme",
               "KST",
               "krasnojarsko ljetno vrijeme",
               "KST",
               "krasnojarsko vrijeme",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "isto\u010dnoindonezijsko vrijeme",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Pitcairn = new String[] {
               "vrijeme Pitcairna",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Noronha = new String[] {
               "standardno vrijeme prema gradu Fernando de Noronha",
               "FNST",
               "ljetno vrijeme prema gradu Fernando de Noronha",
               "FNST",
               "vrijeme prema gradu Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsko standardno vrijeme",
               "NST",
               "novosibirsko ljetno vrijeme",
               "NST",
               "novosibirsko vrijeme",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "planinsko standardno vrijeme",
               "MST",
               "planinsko ljetno vrijeme",
               "MDT",
               "planinsko vrijeme",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "vrijeme Otoka Norfolk",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "vrijeme Niuea",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "vrijeme Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "alja\u0161ko standardno vrijeme",
               "AKST",
               "alja\u0161ko ljetno vrijeme",
               "AKDT",
               "alja\u0161ko vrijeme",
               "AKT",
            };
        final String[] Marshall_Islands = new String[] {
               "vrijeme Mar\u0161alovih Otoka",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "sredi\u0161nje australsko standardno vrijeme",
               "ACST",
               "sredi\u0161nje australsko ljetno vrijeme",
               "ACDT",
               "sredi\u0161nje australsko vrijeme",
               "CAT",
            };
        final String[] Azores = new String[] {
               "azorsko standardno vrijeme",
               "AST",
               "azorsko ljetno vrijeme",
               "AST",
               "azorsko vrijeme",
               "AT",
            };
        final String[] Reunion = new String[] {
               "vrijeme Reuniona",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "indokinesko vrijeme",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Magadan = new String[] {
               "magadanska standardno vrijeme",
               "MST",
               "magadansko ljetno vrijeme",
               "MST",
               "magadanska vrijeme",
               "MT",
            };
        final String[] Chatham = new String[] {
               "standardno vrijeme Chathama",
               "CST",
               "ljetno vrijeme Chathama",
               "CDT",
               "vrijeme Chathama",
               "CT",
            };
        final String[] Davis = new String[] {
               "vrijeme Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Africa_Western = new String[] {
               "Zapadna Afrika standardno vrijeme",
               "WAST",
               "Zapadna Afrika ljetno vrijeme",
               "WAST",
               "Zapadna Afrika vrijeme",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "moskovsko standardno vrijeme",
               "MST",
               "moskovsko ljetno vrijeme",
               "MST",
               "moskovsko vrijeme",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "vrijeme Papue Nove Gvineje",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dno-kazahstansko vrijeme",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "standardno vrijeme Novog Zelanda",
               "NZST",
               "ljetno vrijeme Novog Zelanda",
               "NZDT",
               "vrijeme Novog Zelanda",
               "NZT",
            };
        final String[] Brasilia = new String[] {
               "brazilijsko standardno vrijeme",
               "BST",
               "brazilijsko ljetno vrijeme",
               "BST",
               "brazilijsko vrijeme",
               "BT",
            };
        final String[] Cocos = new String[] {
               "vrijeme Kokosovih Otoka",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Indonesia_Western = new String[] {
               "zapadnoindonezijsko vrijeme",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Phoenix_Islands = new String[] {
               "vrijeme Otoka Phoenix",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "sej\u0161elsko vrijeme",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "sredi\u0161nja Afrika vrijeme",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "standardno vrijeme Uskr\u0161njih Otoka",
               "EIST",
               "ljetno vrijeme Uskr\u0161njih Otoka",
               "EIST",
               "vrijeme Uskr\u0161njih Otoka",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "vrijeme Ju\u017ene D\u017eord\u017eije",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "srednjoindonezijsko vrijeme",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Chamorro = new String[] {
               "vrijeme Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsko standardno vrijeme",
               "NST",
               "newfoundlandsko ljetno vrijeme",
               "NDT",
               "newfoundlandsko vrijeme",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "vrijeme Otoka Line",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "standardno vrijeme Cookovih Otoka",
               "CIST",
               "poluljetno vrijeme Cookovih Otoka",
               "CIHST",
               "vrijeme Cookovih Otoka",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "sredi\u0161nje standardno vrijeme",
               "CST",
               "sredi\u0161nje ljetno vrijeme",
               "CDT",
               "sredi\u0161nje vrijeme",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "isto\u010dna Afrika vrijeme",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Yekaterinburg = new String[] {
               "ekaterinbur\u0161ko standardno vrijeme",
               "YST",
               "ekaterinbur\u0161ko ljetno vrijeme",
               "YST",
               "ekaterinbur\u0161ko vrijeme",
               "YT",
            };
        final String[] China = new String[] {
               "kinesko standardno vrijeme",
               "CST",
               "kinesko ljetno vrijeme",
               "CDT",
               "kinesko vrijeme",
               "CT",
            };
        final String[] Samoa = new String[] {
               "samoansko vrijeme",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "standardno vrijeme Tonga",
               "TST",
               "ljetno vrijeme Tonga",
               "TST",
               "vrijeme Tonga",
               "TT",
            };
        final String[] Solomon = new String[] {
               "vrijeme Solomonovih otoka",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017ena Afrika vrijeme",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "vrijeme prema gradu Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "ju\u017eno francusko i antarkti\u010dko vrijeme",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vrijeme",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "izraelsko standardno vrijeme",
               "IST",
               "izraelsko ljetno vrijeme",
               "IDT",
               "izraelsko vrijeme",
               "IT",
            };
        final String[] Tahiti = new String[] {
               "vrijeme Tahitija",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "vrijeme Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Fiji = new String[] {
               "standardno vrijeme Fid\u017eija",
               "FST",
               "ljetno vrijeme Fid\u017eija",
               "FST",
               "vrijeme Fid\u017eija",
               "FT",
            };
        final String[] Rothera = new String[] {
               "vrijeme Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "srednjoeuropsko standardno vrijeme",
               "CET",
               "srednjoeuropsko ljetno vrijeme",
               "CEST",
               "srednjoeuropsko vrijeme",
               "CET",
            };
        final String[] India = new String[] {
               "indijsko vrijeme",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "vrijeme Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "vrijeme Otoka Wallis i Futuna",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "vrijeme Tuvalu",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Europe_Eastern = new String[] {
               "isto\u010dnoeuropsko standardno vrijeme",
               "EET",
               "isto\u010dnoeuropsko ljetno vrijeme",
               "EEST",
               "isto\u010dnoeuropsko vrijeme",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "atlantsko standardno vrijeme",
               "AST",
               "atlantsko dnevno vrijeme",
               "ADT",
               "atlantsko vrijeme",
               "AT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Bangkok", Indochina },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Europe/Rome", Europe_Central },
            { "Atlantic/Stanley", Falkland },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "Pacific/Wallis", Wallis },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Europe/Podgorica", Europe_Central },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Wake", Wake },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Barbados", Atlantic },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Urumqi", China },
            { "America/Louisville", America_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Pacific/Noumea", New_Caledonia },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
