/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.



*/

/* (C) COPYRIGHT International Business Machines Corp. 2015 */

#define _GNU_SOURCE
#include <errno.h>
#include <grp.h>
#include <pthread.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <time.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/types.h>

#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "trace.h"

pthread_mutex_t  tlmtx = PTHREAD_MUTEX_INITIALIZER;
struct trace_handle_t trace;

static const char *ock_err_msg[] = {
"Malloc Failed",			/*ERR_HOST_MEMORY*/
"Slot Invalid",				/*ERR_SLOT_ID_INVALID*/
"General Error",			/*ERR_GENERAL_ERROR*/
"Function Failed",			/*ERR_FUNCTION_FAILED*/
"Bad Arguments",			/*ERR_ARGUMENTS_BAD*/
"No Event",				/*ERR_NO_EVENT */
"Attribute Read Only",			/*ERR_ATTRIBUTE_READ_ONLY*/
"Attribute Sensitive",			/*ERR_ATTRIBUTE_SENSITIVE*/
"Attribute Type Invalid",		/*ERR_ATTRIBUTE_TYPE_INVALID*/
"Attribute Value Invalid",		/*ERR_ATTRIBUTE_VALUE_INVALID*/
"Data Invalid",				/*ERR_DATA_INVALID */
"Data Length out of Range",		/*ERR_DATA_LEN_RANGE*/
"Device Error",				/*ERR_DEVICE_ERROR*/
"Device does not have Sufficient Memory",	/*ERR_DEVICE_MEMORY*/
"Device Removed",			/*ERR_DEVICE_REMOVED*/
"Encrypted Data Invalid",		/*ERR_ENCRYPTED_DATA_INVALID */
"Encrypted Data Length out of Range",	/*ERR_ENCRYPTED_DATA_LEN_RANGE*/
"Function Cancelled",			/*ERR_FUNCTION_CANCELED*/
"Function Not Parallel",		/*ERR_FUNCTION_NOT_PARALLEL*/
"Function Not Supported",		/*ERR_FUNCTION_NOT_SUPPORTED*/
"Key Changed",				/*ERR_KEY_CHANGED */
"Key Function Not Permitted",		/*ERR_KEY_FUNCTION_NOT_PERMITTED*/
"Key Handle Invalid",			/*ERR_KEY_HANDLE_INVALID*/
"Key Indigestible",			/*ERR_KEY_INDIGESTIBLE*/
"Key Needed",				/*ERR_KEY_NEEDED*/
"Key Not Needed",			/*ERR_KEY_NOT_NEEDED */
"Key Not Wrappable",			/*ERR_KEY_NOT_WRAPPABLE*/
"Key Size out of Range",		/*ERR_KEY_SIZE_RANGE*/
"Key Type Inconsistent",		/*ERR_KEY_TYPE_INCONSISTENT*/
"Key Unextractable",			/*ERR_KEY_UNEXTRACTABLE*/
"Mechanism Invalid",			/*ERR_MECHANISM_INVALID */
"Mechanism Param Invalid",		/*ERR_MECHANISM_PARAM_INVALID*/
"Object Handle Invalid",		/*ERR_OBJECT_HANDLE_INVALID*/
"Operation Active",			/*ERR_OPERATION_ACTIVE*/
"Operation Not Initialized",		/*ERR_OPERATION_NOT_INITIALIZED*/
"Pin Incorrect",			/*ERR_PIN_INCORRECT */
"Pin Invalid",				/*ERR_PIN_INVALID*/
"Pin Length out of Range",		/*ERR_PIN_LEN_RANGE*/
"Pin Expired",				/*ERR_PIN_EXPIRED*/
"Pin Locked",				/*ERR_PIN_LOCKED*/
"Session Closed",			/*ERR_SESSION_CLOSED */
"Session Count",			/*ERR_SESSION_COUNT*/
"Session Handle Invalid",		/*ERR_SESSION_HANDLE_INVALID*/
"Parallel Session Not Supported",	/*ERR_SESSION_PARALLEL_NOT_SUPPORTED*/
"Session Read Only",			/*ERR_SESSION_READ_ONLY*/
"Session Exists",			/*ERR_SESSION_EXISTS */
"Session Read only Exists",		/*ERR_SESSION_READ_ONLY_EXISTS*/
"Session Read Write Exists",		/*ERR_SESSION_READ_WRITE_SO_EXISTS*/
"Signature Invalid",			/*ERR_SIGNATURE_INVALID*/
"Signature Length out of Range",	/*ERR_SIGNATURE_LEN_RANGE*/
"Template Incomplete",			/*ERR_TEMPLATE_INCOMPLETE */
"Template Inconsistent",		/*ERR_TEMPLATE_INCONSISTENT*/
"Token Not Present",			/*ERR_TOKEN_NOT_PRESENT*/
"Token Not Recognized",			/*ERR_TOKEN_NOT_RECOGNIZED*/
"Token Write Protected",		/*ERR_TOKEN_WRITE_PROTECTED*/
"Unwrapping Key Handle Invalid",	/*ERR_UNWRAPPING_KEY_HANDLE_INVALID*/
"Unwrapping Key Size Range Invalid",	/*ERR_UNWRAPPING_KEY_SIZE_RANGE*/
"Unwrapping Key Type Inconsistent",	/*ERR_UNWRAPPING_KEY_TYPE_INCONSISTENT*/
"User Already Logged In",		/*ERR_USER_ALREADY_LOGGED_IN*/
"User Not Logged In",			/*ERR_USER_NOT_LOGGED_IN*/
"User PIN Not Initialized",		/*ERR_USER_PIN_NOT_INITIALIZED */
"User Type Invalid",			/*ERR_USER_TYPE_INVALID*/
"Another User Already Logged In",	/*ERR_USER_ANOTHER_ALREADY_LOGGED_IN*/
"Too Many User Types",			/*ERR_USER_TOO_MANY_TYPES*/
"Wrapped Key Invalid", 			/*ERR_WRAPPED_KEY_INVALID*/
"Wrapped Key Length Invalid",		/*ERR_WRAPPED_KEY_LEN_RANGE*/
"Wrapping Key Handle Invalid",		/*ERR_WRAPPING_KEY_HANDLE_INVALID*/
"Wrapping Key Size out of Range",	/*ERR_WRAPPING_KEY_SIZE_RANGE*/
"Wrapping Key Type Inconsistent",	/*ERR_WRAPPING_KEY_TYPE_INCONSISTENT*/
"Random Seed Not Supported",		/*ERR_RANDOM_SEED_NOT_SUPPORTED*/
"Domain Parameter Invalid",		/*ERR_DOMAIN_PARAMS_INVALID*/
"Buffer Too Small",			/*ERR_BUFFER_TOO_SMALL */
"Saved State Invalid",			/*ERR_SAVED_STATE_INVALID*/
"Information Sensitive",		/*ERR_INFORMATION_SENSITIVE*/
"State Unsaveable",			/*ERR_STATE_UNSAVEABLE*/
"API not initialized",			/*ERR_CRYPTOKI_NOT_INITIALIZED*/
"API already Initialized",		/*ERR_CRYPTOKI_ALREADY_INITIALIZED*/
"Mutex Invalid",			/*ERR_MUTEX_BAD*/
"Mutex was not locked",			/*ERR_MUTEX_NOT_LOCKED*/
"Unknown error",			/*ERR_MAX*/
};

void set_trace(struct trace_handle_t t_handle)
{
	trace.fd = t_handle.fd;
	trace.level = t_handle.level;
}

void trace_finalize(void)
{
	if (trace.fd)
		close(trace.fd);
	trace.fd = -1;
	trace.level = 0;
}

CK_RV trace_initialize(void)
{
	char *opt = NULL;
	char *end;
	long int num;
	struct group *grp;
	char tracefile[PATH_MAX];

	/* initialize the trace values */
	trace.level = 0;
	trace.fd = -1;

	opt = getenv("OPENCRYPTOKI_TRACE_LEVEL");
	if (!opt)
		return(CKR_FUNCTION_FAILED);

	num = strtol(opt, &end, 10);
	if (*end) {
		OCK_SYSLOG(LOG_WARNING, "OPENCRYPTOKI_TRACE_LEVEL '%s' is "
			   "invalid. Tracing disabled.", opt);
		return(CKR_FUNCTION_FAILED);
	}

	switch(num) {
	case TRACE_LEVEL_NONE:
		return CKR_OK;
	case TRACE_LEVEL_ERROR:
	case TRACE_LEVEL_WARNING:
	case TRACE_LEVEL_INFO:
	case TRACE_LEVEL_DEVEL:
#ifdef DEBUG
	case TRACE_LEVEL_DEBUG:
#endif
		trace.level = num;
		break;
	default :
		OCK_SYSLOG(LOG_WARNING, "Trace level %ld is out of range. "
			   "Tracing disabled.", num);
		return(CKR_FUNCTION_FAILED);
	}

	grp = getgrnam("pkcs11");
	if (grp == NULL) {
		OCK_SYSLOG(LOG_ERR, "getgrnam(pkcs11) failed: %s."
			   "Tracing is disabled.\n", strerror(errno));
		goto error;
	}

	/* open trace file */
	snprintf(tracefile, sizeof(tracefile), "/%s/%s.%d", OCK_LOGDIR,
		 "trace", getpid());

	trace.fd = open(tracefile, O_RDWR|O_APPEND|O_CREAT,
			S_IRUSR|S_IWUSR|S_IRGRP);

	if (trace.fd < 0) {
		OCK_SYSLOG(LOG_WARNING,
			   "open(%s) failed: %s. Tracing disabled.\n",
			   tracefile, strerror(errno));
		goto error;
	}

	/* set pkcs11 group permission on tracefile */
	if (fchown(trace.fd, -1, grp->gr_gid) == -1) {
		OCK_SYSLOG(LOG_ERR, "fchown(%s,-1,pkcs11) failed: %s."
			   "Tracing is disabled.\n",
			   tracefile, strerror(errno));
		goto error;
	}

	return(CKR_OK);

error:
	trace.level = 0;
	trace.fd = -1;
	return(CKR_FUNCTION_FAILED);
}

void ock_traceit(trace_level_t level, const char *fmt, ...)
{
	va_list ap;
	time_t t;
	struct tm *tm;
	char buf[1024];
	char *pbuf;
	int buflen, len;

	if (trace.fd < 0)
		return;

	if (level <= trace.level) {
		pbuf = buf;
		buflen = sizeof(buf);

		/* add the current time */
		t = time(0);
		tm = localtime(&t);
		len = strftime(pbuf, buflen, "%m/%d/%Y %H:%M:%S ", tm);
		pbuf +=len;
		buflen -= len;
		/* add the current time */

		/* add the format */
		va_start(ap, fmt);
		vsnprintf(pbuf, buflen, fmt, ap);
		va_end(ap);

		/* serialize appends to the file */
		pthread_mutex_lock(&tlmtx);
		write(trace.fd, buf, strlen(buf));
		pthread_mutex_unlock(&tlmtx);
	}
}

const char *ock_err(int num)
{
	if ( num < 0 || num > ERR_MAX)
		num = ERR_MAX;

	return ock_err_msg[num];
}
