/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#ifndef UFO_H
#define UFO_H

#include "Vector.h"
#include "Game.h"

enum UfoPilotStateType{
	UFO_SEEKPLAYER,
	UFO_SEARCH,
	UFO_POTTER
};


class Ufo {
public: 
	Ufo();
	~Ufo();
	void Physics();
	void Collide();
	void Pilot();
	Ufo* Nearest();
	void TriggerShield();
	void StartSound();
	void StopSound();
	void Die();
	void Live();
	void Explode();
	int Hurt(float pain);
	Game* game;

	Vector s;
	Vector v;
	Vector a;
	float thrust;

	float bear; //RADIANS!
	float bearv;
	float beara;
	float spawneffect;
	float maxspawneffect;
	float collideradius;
	float collideradius2;
	float sniffradius;
	float hp;

	float thinkwait;

	UfoPilotStateType pilotstate;

	int alive;

	int soundid;
};

#endif
