/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.data.transformers.PercentOfTotalGroupingAttributeTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.sql.SQLGroupingQueryGenerator;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.DataEditorFeatures;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.utils.CommonUtils;

public class GroupingResultsContainer
implements IResultSetContainer {
    private static final Log log = Log.getLog(GroupingResultsContainer.class);
    public static final String FUNCTION_COUNT = "COUNT";
    private final IResultSetPresentation presentation;
    private final GroupingDataContainer dataContainer;
    private final ResultSetViewer groupingViewer;
    private final List<SQLGroupingAttribute> groupAttributes = new ArrayList<SQLGroupingAttribute>();
    private final List<String> groupFunctions = new ArrayList<String>();
    private final AtomicReference<DBDDataFilter> currentFiler = new AtomicReference();

    public GroupingResultsContainer(Composite parent, IResultSetPresentation presentation) {
        this.presentation = presentation;
        this.dataContainer = new GroupingDataContainer(presentation.getController());
        this.groupingViewer = new ResultSetViewer(parent, presentation.getController().getSite(), this){

            @Override
            public void refreshWithFilter(DBDDataFilter filter) {
                GroupingResultsContainer.this.currentFiler.set(filter);
                super.refreshWithFilter(filter);
            }
        };
        this.initDefaultSettings();
    }

    private String getDefaultFunction() {
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        return "COUNT(" + (dataSource == null ? "*" : dataSource.getSQLDialect().getDefaultGroupAttribute()) + ")";
    }

    private void initDefaultSettings() {
        this.groupAttributes.clear();
        this.groupFunctions.clear();
        this.addGroupingFunctions(Collections.singletonList(this.getDefaultFunction()));
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.presentation;
    }

    public List<SQLGroupingAttribute> getGroupAttributes() {
        return this.groupAttributes;
    }

    public List<String> getGroupFunctions() {
        return this.groupFunctions;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer().getProject();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.presentation.getController().getExecutionContext();
    }

    @Override
    @NotNull
    public IResultSetController getResultSetController() {
        return this.groupingViewer;
    }

    @Override
    @NotNull
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new GroupingResultsDecorator(this);
    }

    @Override
    @Nullable
    public IResultSetContainer getParentContainer() {
        return this.presentation.getController().getContainer();
    }

    void clearGroupingAttributes() {
        this.groupAttributes.clear();
    }

    void addGroupingAttributes(List<SQLGroupingAttribute> attributes) {
        for (SQLGroupingAttribute attr : attributes) {
            if (this.groupAttributes.contains(attr)) continue;
            this.groupAttributes.add(attr);
        }
    }

    public boolean removeGroupingAttribute(List<SQLGroupingAttribute> attributes) {
        boolean changed = false;
        for (SQLGroupingAttribute attr : attributes) {
            if (!this.groupAttributes.contains(attr)) continue;
            this.groupAttributes.remove(attr);
            changed = true;
        }
        if (changed) {
            this.resetDataFilters();
        }
        return changed;
    }

    public void addGroupingFunctions(List<String> functions) {
        for (String func : functions) {
            DBPDataSource dataSource = this.getDataContainer().getDataSource();
            if (dataSource == null || this.groupFunctions.contains(func = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)func))) continue;
            this.groupFunctions.add(func);
        }
    }

    public boolean removeGroupingFunction(List<String> attributes) {
        boolean changed = false;
        DBPDataSource dataSource = this.getDataContainer().getDataSource();
        if (dataSource != null) {
            for (String func : attributes) {
                if (!this.groupFunctions.contains(func = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)func))) continue;
                this.groupFunctions.remove(func);
                changed = true;
            }
        }
        return changed;
    }

    public void clearGrouping() {
        this.initDefaultSettings();
        this.groupingViewer.clearData(true);
        this.groupingViewer.clearDataFilter(false);
        this.groupingViewer.resetHistory();
        this.dataContainer.setGroupingQuery(null);
        this.dataContainer.setGroupingAttributes(null);
        this.dataContainer.removeAttributeTransformer();
        if (!(this.groupingViewer.getActivePresentation() instanceof EmptyPresentation)) {
            this.groupingViewer.showEmptyPresentation();
        }
    }

    public void rebuildGrouping() throws DBException {
        if (this.groupAttributes.isEmpty() || this.groupFunctions.isEmpty()) {
            this.groupingViewer.showEmptyPresentation();
            return;
        }
        DBCStatistics statistics = this.presentation.getController().getModel().getStatistics();
        if (statistics == null) {
            throw new DBException("No main query - can't perform grouping");
        }
        DBSDataContainer dbsDataContainer = this.presentation.getController().getDataContainer();
        boolean isCustomQuery = !(dbsDataContainer instanceof DBSEntity);
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        if (dataSource == null) {
            throw new DBException("No active datasource");
        }
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dialect, this.presentation.getController().getPreferenceStore());
        String queryText = statistics.getQueryText();
        boolean isShowDuplicatesOnly = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        DBDDataFilter dataFilter = this.getDataFilter();
        SQLGroupingQueryGenerator groupingQueryGenerator = new SQLGroupingQueryGenerator(dataSource, dbsDataContainer, dialect, syntaxManager, this.groupAttributes, this.getGroupFunctionsWithExtraColumns(dataSource), isShowDuplicatesOnly);
        this.dataContainer.setGroupingQuery(groupingQueryGenerator.generateGroupingQuery(queryText));
        this.dataContainer.setGroupingAttributes((SQLGroupingAttribute[])this.groupAttributes.toArray(SQLGroupingAttribute[]::new));
        boolean isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equalsIgnoreCase(this.getDefaultFunction());
        String defaultSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
        if (!CommonUtils.isEmpty((String)defaultSorting) && isDefaultGrouping) {
            String[] funcAliases = groupingQueryGenerator.getFuncAliases();
            dataFilter.setOrder(funcAliases[funcAliases.length - 1] + " " + defaultSorting);
        }
        DataEditorFeatures.RESULT_SET_PANEL_GROUPING.use(Map.of("custom", isCustomQuery, "default", isDefaultGrouping, "dups", isShowDuplicatesOnly));
        this.groupingViewer.setDataFilter(dataFilter, true);
    }

    @NotNull
    private DBDDataFilter getDataFilter() {
        return this.presentation.getController().getModel().isMetadataChanged() ? new DBDDataFilter() : new DBDDataFilter(this.groupingViewer.getModel().getDataFilter());
    }

    void setGrouping(List<SQLGroupingAttribute> attributes, List<String> functions) {
        this.groupAttributes.clear();
        this.addGroupingAttributes(attributes);
        this.groupFunctions.clear();
        this.addGroupingFunctions(functions);
        this.resetDataFilters();
    }

    private List<String> getGroupFunctionsWithExtraColumns(@NotNull DBPDataSource dataSource) {
        boolean isShowTotalPercentColumn = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showPercentOfTotal");
        return isShowTotalPercentColumn ? this.addPercentageColumn() : this.getGroupFunctions();
    }

    private List<String> addPercentageColumn() {
        ArrayList<String> allGroupFunctions = new ArrayList<String>(this.getGroupFunctions());
        String function = this.getDefaultFunction();
        allGroupFunctions.add(function);
        int percentFunctionOrderInStatement = this.getGroupAttributes().size() + allGroupFunctions.size() - 1;
        this.dataContainer.setAttributeTransformer(percentFunctionOrderInStatement, (DBDAttributeTransformer)new PercentOfTotalGroupingAttributeTransformer(this::getTotalRowCount));
        return allGroupFunctions;
    }

    private long getTotalRowCount(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DBUtils.readRowCount((DBRProgressMonitor)monitor, (DBCExecutionContext)this.groupingViewer.getExecutionContext(), (DBSDataContainer)this.presentation.getController().getDataContainer(), (DBDDataFilter)this.filterExcludingGroupingColumns(), (Object)this.groupingViewer);
    }

    @Nullable
    private DBDDataFilter filterExcludingGroupingColumns() {
        DBDDataFilter dataFilter = this.currentFiler.get();
        if (dataFilter == null) {
            return null;
        }
        List<DBDAttributeConstraint> attributeConstraints = this.groupAttributes.stream().map(ga -> {
            String string;
            if (ga instanceof SQLGroupingAttribute.BoundAttribute) {
                SQLGroupingAttribute.BoundAttribute boundAttribute = (SQLGroupingAttribute.BoundAttribute)ga;
                string = boundAttribute.getBindingName();
            } else {
                string = ga.getDisplayName();
            }
            return string;
        }).map(arg_0 -> ((DBDDataFilter)dataFilter).getConstraint(arg_0)).filter(Objects::nonNull).toList();
        DBDDataFilter newFilter = new DBDDataFilter(attributeConstraints);
        newFilter.setWhere(dataFilter.getWhere());
        return newFilter;
    }

    private void resetDataFilters() {
        this.groupingViewer.getModel().createDataFilter();
    }
}

