/*
 *
 * Copyright (c) 2011-2016 The University of Waikato, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This file is part of libprotoident.
 *
 * This code has been developed by the University of Waikato WAND
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libprotoident is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * libprotoident is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <string.h>

#include "libprotoident.h"
#include "proto_manager.h"
#include "proto_common.h"

/* Custom version of RTCP used by Alibaba cloud for streaming */

static inline bool match_artcp_payload(uint32_t payload, uint32_t len) {
        if (len == 0)
                return true;
        if (MATCH(payload, 0x83, 0xcc, 0x00, ANY))
                return true;
        return false;
}


static inline bool match_artcp(lpi_data_t *data, lpi_module_t *mod UNUSED) {


        if (data->server_port == 1106 || data->client_port == 1106) {

        	if (!match_artcp_payload(data->payload[0],
                                data->payload_len[0]))
                        return false;
                if (!match_artcp_payload(data->payload[1],
                                data->payload_len[1]))
                        return false;
                return true;
        }
        return false;

}

static lpi_module_t lpi_artcp = {
	LPI_PROTO_UDP_ARTCP,
	LPI_CATEGORY_STREAMING,
	"ARTCP",
	200,
	match_artcp
};

void register_artcp(LPIModuleMap *mod_map) {
	register_protocol(&lpi_artcp, mod_map);
}

