/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PList
extends PAbstract {
    private PAbstract head;
    private PAbstract tail;
    private int size;

    PList() {
        this.emptyList();
    }

    public void emptyList() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public void add(PAbstract cur) {
        if (this.tail == null) {
            this.head = this.tail = cur;
            this.size = 1;
        } else {
            this.tail.setNext(cur);
            this.tail = cur;
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public PAbstract elementAt(int i) {
        int n = 0;
        for (PAbstract cur = this.head; cur != null; cur = cur.getNext()) {
            if (n == i) {
                return cur;
            }
            ++n;
        }
        return null;
    }

    public PAbstract elementNamed(String s) {
        for (PAbstract cur = this.head; cur != null; cur = cur.getNext()) {
            if (!cur.getName().equals(s)) continue;
            return cur;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer(super.toString() + "{");
        for (PAbstract cur = this.head; cur != null; cur = cur.getNext()) {
            ret.append(cur.toString());
            if (cur.getNext() == null) continue;
            ret.append(", ");
        }
        ret.append("} ");
        return ret.toString();
    }

    private boolean hasFew() {
        return this.head == this.tail;
    }

    @Override
    public boolean draw(PDisplayStyle p, int drawStyle) {
        if (!this.hasFew()) {
            super.draw(p, drawStyle);
            p.drawString("{");
        }
        if (drawStyle == 1) {
            p.addIndent(1);
            for (PAbstract cur = this.head; cur != null; cur = cur.getNext()) {
                cur.draw(p);
                if (cur.getNext() == null) continue;
                p.newRow();
            }
            p.addIndent(-1);
        } else {
            for (PAbstract cur = this.head; cur != null; cur = cur.getNext()) {
                if (cur.draw(p)) continue;
                return false;
            }
        }
        if (!this.hasFew()) {
            p.drawString("}");
        }
        return true;
    }
}

