/*
 * Copyright (C) 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This code is derived in parts from the code distribution provided with
 * https://github.com/jedisct1/libsodium.git
 *
 * That code is released under ISC License
 *
 * Copyright (c) 2013-2023 - 2025
 * Frank Denis <j at pureftpd dot org>
 */

#ifndef CONSTANTS_H
#define CONSTANTS_H

#include "ext_headers_internal.h"

#ifdef __cplusplus
extern "C" {
#endif

/* sqrt(-1) */
LC_FIPS_RODATA_SECTION
static const fe25519 fe25519_sqrtm1 = { 1718705420411056, 234908883556509,
					2233514472574048, 2117202627021982,
					765476049583133 };

/* sqrt(-486664) */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_sqrtam2 = { 1693982333959686, 608509411481997,
					 2235573344831311, 947681270984193,
					 266558006233600 };

/* 37095705934669439343138083508754565189542113879843219016388785533085940283555 */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_d = { 929955233495203, 466365720129213,
				   1662059464998953, 2033849074728123,
				   1442794654840575 };

/* 2 * d =
 * 16295367250680780974490674513165176452449235426866156013048779062215315747161
 */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_d2 = { 1859910466990425, 932731440258426,
				    1072319116312658, 1815898335770999,
				    633789495995903 };

/* A = 486662 */
#define ed25519_A_32 486662
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_A = { ed25519_A_32, 0, 0, 0, 0 };

/* sqrt(ad - 1) with a = -1 (mod p) */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_sqrtadm1 = { 2241493124984347, 425987919032274,
					  2207028919301688, 1220490630685848,
					  974799131293748 };

/* 1 / sqrt(a - d) */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_invsqrtamd = { 278908739862762, 821645201101625,
					    8113234426968, 1777959178193151,
					    2118520810568447 };

/* 1 - d ^ 2 */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_onemsqd = { 1136626929484150, 1998550399581263,
					 496427632559748, 118527312129759,
					 45110755273534 };

/* (d - 1) ^ 2 */
LC_FIPS_RODATA_SECTION
static const fe25519 ed25519_sqdmone = { 1507062230895904, 1572317787530805,
					 683053064812840, 317374165784489,
					 1572899562415810 };

#ifdef __cplusplus
}
#endif

#endif /* CONSTANTS_H */
