/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveQName
extends SystemFunctionCall
implements Callable {
    @Override
    public QNameValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        NodeInfo element = (NodeInfo)this.argument[1].evaluateItem(context);
        return this.resolveQName(arg0, element, context);
    }

    @Override
    public ZeroOrOne<QNameValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new ZeroOrOne<QNameValue>(this.resolveQName((AtomicValue)arguments[0].head(), (NodeInfo)arguments[1].head(), context));
    }

    private QNameValue resolveQName(AtomicValue qname, NodeInfo element, XPathContext context) throws XPathException {
        StructuredQName qName;
        if (qname == null) {
            return null;
        }
        CharSequence lexicalQName = qname.getStringValueCS();
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, true, false, resolver);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        return new QNameValue(qName, BuiltInAtomicType.QNAME);
    }
}

