/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TinyBuilderMonitor
extends BuilderMonitor {
    private TinyBuilder builder;
    private int mark = -1;
    private int markedNodeNr = -1;
    private int markedAttribute = -1;
    private int markedNamespace = -1;

    public TinyBuilderMonitor(TinyBuilder builder) {
        super(builder);
        this.builder = builder;
    }

    public void markNextNode(int nodeKind) {
        this.mark = nodeKind;
    }

    public void markAttributeNode(NodeInfo origin) {
        int[] atts = this.builder.getTree().getAttributeNameCodeArray();
        int used = this.builder.getTree().getNumberOfAttributes();
        int fp = origin.getFingerprint();
        for (int i = used - 1; i >= 0; --i) {
            if ((atts[i] & 0xFFFFF) != fp) continue;
            this.markedAttribute = i;
            return;
        }
        throw new IllegalStateException("Selected attribute not found");
    }

    public void markNamespaceNode(NodeInfo origin) {
        NamespaceBinding[] atts = this.builder.getTree().getNamespaceBindings();
        int used = this.builder.getTree().getNumberOfNamespaces();
        String local = origin.getLocalPart();
        for (int i = used - 1; i >= 0; --i) {
            if (!atts[i].getPrefix().equals(local)) continue;
            this.markedNamespace = i;
            return;
        }
        throw new IllegalStateException("Selected namespace not found");
    }

    public void startDocument(int properties) throws XPathException {
        if (this.mark == 9) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.mark == 1) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mark == 3) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mark == 8) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.comment(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.mark == 7) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.processingInstruction(target, data, locationId, properties);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.mark == 2) {
            this.markedAttribute = this.builder.getTree().getNumberOfAttributes();
        }
        this.mark = -1;
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.mark == 13) {
            this.markedNamespace = this.builder.getTree().getNumberOfNamespaces();
        }
        this.mark = -1;
        super.namespace(namespaceBinding, properties);
    }

    public NodeInfo getMarkedNode() {
        if (this.markedNodeNr != -1) {
            return this.builder.getTree().getNode(this.markedNodeNr);
        }
        if (this.markedAttribute != -1) {
            return this.builder.getTree().getAttributeNode(this.markedAttribute);
        }
        if (this.markedNamespace != -1) {
            NamespaceBinding nscode = this.builder.getTree().namespaceBinding[this.markedNamespace];
            NamePool pool = this.builder.getConfiguration().getNamePool();
            String prefix = nscode.getPrefix();
            TinyNodeImpl parent = this.builder.getTree().getNode(this.builder.getTree().namespaceParent[this.markedNamespace]);
            NameTest test = new NameTest(13, "", prefix, pool);
            AxisIterator iter = parent.iterateAxis((byte)8, test);
            return iter.next();
        }
        return null;
    }
}

