/**************************************************************************
    Lightspark, a free flash player implementation

    Copyright (C) 2009-2013  Alessandro Pignotti (a.pignotti@sssup.it)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

#ifndef SCRIPTING_FLASH_UI_KEYCODES_H
#define SCRIPTING_FLASH_UI_KEYCODES_H 1

#include <SDL2/SDL_keycode.h>

namespace lightspark {


enum AS3KeyCode {
	AS3KEYCODE_A = 65, 
	AS3KEYCODE_ALTERNATE = 18, 
	AS3KEYCODE_AUDIO = 0x01000017, 
	AS3KEYCODE_B = 66, 
	AS3KEYCODE_BACK = 0x01000016, 
	AS3KEYCODE_BACKQUOTE = 192, 
	AS3KEYCODE_BACKSLASH = 220, 
	AS3KEYCODE_BACKSPACE = 8, 
	AS3KEYCODE_BLUE = 0x01000003, 
	AS3KEYCODE_C = 67, 
	AS3KEYCODE_CAPS_LOCK = 20, 
	AS3KEYCODE_CHANNEL_DOWN = 0x01000005, 
	AS3KEYCODE_CHANNEL_UP = 0x01000004, 
	AS3KEYCODE_COMMA = 188, 
	AS3KEYCODE_COMMAND = 15, 
	AS3KEYCODE_CONTROL = 17, 
	AS3KEYCODE_D = 68, 
	AS3KEYCODE_DELETE = 46, 
	AS3KEYCODE_DOWN = 40, 
	AS3KEYCODE_DVR = 0x01000019, 
	AS3KEYCODE_E = 69, 
	AS3KEYCODE_END = 35, 
	AS3KEYCODE_ENTER = 13, 
	AS3KEYCODE_EQUAL = 187, 
	AS3KEYCODE_ESCAPE = 27, 
	AS3KEYCODE_EXIT = 0x01000015, 
	AS3KEYCODE_F = 70, 
	AS3KEYCODE_F1 = 112, 
	AS3KEYCODE_F10 = 121, 
	AS3KEYCODE_F11 = 122, 
	AS3KEYCODE_F12 = 123, 
	AS3KEYCODE_F13 = 124, 
	AS3KEYCODE_F14 = 125, 
	AS3KEYCODE_F15 = 126, 
	AS3KEYCODE_F2 = 113, 
	AS3KEYCODE_F3 = 114, 
	AS3KEYCODE_F4 = 115, 
	AS3KEYCODE_F5 = 116, 
	AS3KEYCODE_F6 = 117, 
	AS3KEYCODE_F7 = 118, 
	AS3KEYCODE_F8 = 119, 
	AS3KEYCODE_F9 = 120, 
	AS3KEYCODE_FAST_FORWARD = 0x0100000A, 
	AS3KEYCODE_G = 71, 
	AS3KEYCODE_GREEN = 0x01000001, 
	AS3KEYCODE_GUIDE = 0x01000014, 
	AS3KEYCODE_H = 72, 
	AS3KEYCODE_HELP = 0x0100001D, 
	AS3KEYCODE_HOME = 36, 
	AS3KEYCODE_I = 73, 
	AS3KEYCODE_INFO = 0x01000013, 
	AS3KEYCODE_INPUT = 0x0100001B, 
	AS3KEYCODE_INSERT = 45, 
	AS3KEYCODE_J = 74, 
	AS3KEYCODE_K = 75, 
	AS3KEYCODE_L = 76, 
	AS3KEYCODE_LAST = 0x01000011, 
	AS3KEYCODE_LEFT = 37, 
	AS3KEYCODE_LEFTBRACKET = 219, 
	AS3KEYCODE_LIVE = 0x01000010, 
	AS3KEYCODE_M = 77, 
	AS3KEYCODE_MASTER_SHELL = 0x0100001E, 
	AS3KEYCODE_MENU = 0x01000012, 
	AS3KEYCODE_MINUS = 189, 
	AS3KEYCODE_N = 78, 
	AS3KEYCODE_NEXT = 0x0100000E, 
	AS3KEYCODE_NUMBER_0 = 48, 
	AS3KEYCODE_NUMBER_1 = 49, 
	AS3KEYCODE_NUMBER_2 = 50, 
	AS3KEYCODE_NUMBER_3 = 51, 
	AS3KEYCODE_NUMBER_4 = 52, 
	AS3KEYCODE_NUMBER_5 = 53, 
	AS3KEYCODE_NUMBER_6 = 54, 
	AS3KEYCODE_NUMBER_7 = 55, 
	AS3KEYCODE_NUMBER_8 = 56, 
	AS3KEYCODE_NUMBER_9 = 57, 
	AS3KEYCODE_NUMPAD = 21, 
	AS3KEYCODE_NUMPAD_0 = 96, 
	AS3KEYCODE_NUMPAD_1 = 97, 
	AS3KEYCODE_NUMPAD_2 = 98, 
	AS3KEYCODE_NUMPAD_3 = 99, 
	AS3KEYCODE_NUMPAD_4 = 100, 
	AS3KEYCODE_NUMPAD_5 = 101, 
	AS3KEYCODE_NUMPAD_6 = 102, 
	AS3KEYCODE_NUMPAD_7 = 103, 
	AS3KEYCODE_NUMPAD_8 = 104, 
	AS3KEYCODE_NUMPAD_9 = 105, 
	AS3KEYCODE_NUMPAD_ADD = 107, 
	AS3KEYCODE_NUMPAD_DECIMAL = 110, 
	AS3KEYCODE_NUMPAD_DIVIDE = 111, 
	AS3KEYCODE_NUMPAD_ENTER = 108, 
	AS3KEYCODE_NUMPAD_MULTIPLY = 106, 
	AS3KEYCODE_NUMPAD_SUBTRACT = 109, 
	AS3KEYCODE_O = 79, 
	AS3KEYCODE_P = 80, 
	AS3KEYCODE_PAGE_DOWN = 34, 
	AS3KEYCODE_PAGE_UP = 33, 
	AS3KEYCODE_PAUSE = 0x01000008, 
	AS3KEYCODE_PERIOD = 190, 
	AS3KEYCODE_PLAY = 0x01000007, 
	AS3KEYCODE_PREVIOUS = 0x0100000F, 
	AS3KEYCODE_Q = 81, 
	AS3KEYCODE_QUOTE = 222, 
	AS3KEYCODE_R = 82, 
	AS3KEYCODE_RECORD = 0x01000006, 
	AS3KEYCODE_RED = 0x01000000, 
	AS3KEYCODE_REWIND = 0x0100000B, 
	AS3KEYCODE_RIGHT = 39, 
	AS3KEYCODE_RIGHTBRACKET = 221, 
	AS3KEYCODE_S = 83, 
	AS3KEYCODE_SEARCH = 0x0100001F, 
	AS3KEYCODE_SEMICOLON = 186, 
	AS3KEYCODE_SETUP = 0x0100001C, 
	AS3KEYCODE_SHIFT = 16, 
	AS3KEYCODE_SKIP_BACKWARD = 0x0100000D, 
	AS3KEYCODE_SKIP_FORWARD = 0x0100000C, 
	AS3KEYCODE_SLASH = 191, 
	AS3KEYCODE_SPACE = 32, 
	AS3KEYCODE_STOP = 0x01000009, 
	AS3KEYCODE_SUBTITLE = 0x01000018, 
	AS3KEYCODE_T = 84, 
	AS3KEYCODE_TAB = 9, 
	AS3KEYCODE_U = 85, 
	AS3KEYCODE_UP = 38, 
	AS3KEYCODE_V = 86, 
	AS3KEYCODE_VOD = 0x0100001A, 
	AS3KEYCODE_W = 87, 
	AS3KEYCODE_X = 88, 
	AS3KEYCODE_Y = 89, 
	AS3KEYCODE_YELLOW = 0x01000002, 
	AS3KEYCODE_Z = 90, 
	AS3KEYCODE_UNKNOWN = 0
};

}
#endif /* SCRIPTING_FLASH_UI_KEYCODES_H */
