/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { global } from './global';
export function getNativeRequestAnimationFrame() {
    let nativeRequestAnimationFrame = global['requestAnimationFrame'];
    let nativeCancelAnimationFrame = global['cancelAnimationFrame'];
    if (typeof Zone !== 'undefined' && nativeRequestAnimationFrame && nativeCancelAnimationFrame) {
        // use unpatched version of requestAnimationFrame(native delegate) if possible
        // to avoid another Change detection
        const unpatchedRequestAnimationFrame = nativeRequestAnimationFrame[Zone.__symbol__('OriginalDelegate')];
        if (unpatchedRequestAnimationFrame) {
            nativeRequestAnimationFrame = unpatchedRequestAnimationFrame;
        }
        const unpatchedCancelAnimationFrame = nativeCancelAnimationFrame[Zone.__symbol__('OriginalDelegate')];
        if (unpatchedCancelAnimationFrame) {
            nativeCancelAnimationFrame = unpatchedCancelAnimationFrame;
        }
    }
    return { nativeRequestAnimationFrame, nativeCancelAnimationFrame };
}
//# sourceMappingURL=data:application/json;base64,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