/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.hampelratte.svdrp.Command;
import org.hampelratte.svdrp.Connection;
import org.hampelratte.svdrp.Response;
import org.hampelratte.svdrp.commands.DELR;
import org.hampelratte.svdrp.commands.DELT;
import org.hampelratte.svdrp.commands.LSTC;
import org.hampelratte.svdrp.commands.LSTE;
import org.hampelratte.svdrp.commands.LSTR;
import org.hampelratte.svdrp.commands.LSTT;
import org.hampelratte.svdrp.commands.MODT;
import org.hampelratte.svdrp.commands.NEWT;
import org.hampelratte.svdrp.commands.STAT;
import org.hampelratte.svdrp.parsers.ChannelParser;
import org.hampelratte.svdrp.parsers.EPGParser;
import org.hampelratte.svdrp.parsers.RecordingListParser;
import org.hampelratte.svdrp.parsers.RecordingParser;
import org.hampelratte.svdrp.parsers.TimerParser;
import org.hampelratte.svdrp.responses.highlevel.Channel;
import org.hampelratte.svdrp.responses.highlevel.EPGEntry;
import org.hampelratte.svdrp.responses.highlevel.Recording;
import org.hampelratte.svdrp.responses.highlevel.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDR {
    private static transient Logger logger = LoggerFactory.getLogger(VDR.class);
    private final String host;
    private final int port;
    private final int connectTimeout;
    private Connection connection = null;
    private boolean vdrAvailable = false;
    public static boolean persistentConnection;
    private static java.util.Timer timer;
    private static long lastTransmissionTime;
    private static final int CONNECTION_KEEP_ALIVE = 15000;

    public VDR(String host, int port, int connectTimeout) {
        this.host = host;
        this.port = port;
        this.connectTimeout = connectTimeout;
    }

    public List<Timer> getTimers() throws UnknownHostException, IOException {
        return this.getTimers(new LSTT());
    }

    public Timer getTimer(int number) throws UnknownHostException, IOException {
        List<Timer> timers = this.getTimers(new LSTT(number));
        if (timers.size() > 0) {
            return timers.get(0);
        }
        throw new RuntimeException("Timer " + number + " is not defined");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Timer> getTimers(LSTT lstt) throws UnknownHostException, IOException {
        List<Timer> timers = null;
        Response res = this.send(lstt);
        if (res == null) throw new RuntimeException("Response object is null");
        if (res.getCode() == 250) {
            return TimerParser.parse(res.getMessage());
        }
        if (res == null) throw new RuntimeException(res.getMessage());
        if (res.getCode() == 550) return new ArrayList<Timer>();
        if (res.getCode() != 501) throw new RuntimeException(res.getMessage());
        return new ArrayList<Timer>();
    }

    public Response modifyTimer(int number, Timer timer) throws UnknownHostException, IOException {
        return this.send(new MODT(number, timer));
    }

    public Response deleteTimer(int number) throws UnknownHostException, IOException {
        return this.send(new DELT(number));
    }

    public Response newTimer(Timer timer) throws UnknownHostException, IOException {
        return this.send(new NEWT(timer));
    }

    public List<Channel> getChannels() throws UnknownHostException, IOException, ParseException {
        List<Channel> channels = null;
        Response res = this.send(new LSTC());
        if (res != null) {
            if (res.getCode() != 250) {
                throw new RuntimeException(res.getMessage());
            }
        } else {
            throw new RuntimeException("Response object is null");
        }
        channels = ChannelParser.parse(res.getMessage(), true);
        return channels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Recording> getRecordings() throws UnknownHostException, IOException {
        List<Recording> recordings = null;
        Response res = this.send(new LSTR());
        if (res == null) throw new RuntimeException("Response object is null");
        if (res.getCode() == 250) {
            return RecordingListParser.parse(res.getMessage());
        }
        if (res.getCode() != 550) throw new RuntimeException(res.getMessage());
        return new ArrayList<Recording>();
    }

    public Recording getRecordingDetails(Recording rec) throws UnknownHostException, IOException, ParseException {
        Response res = this.send(new LSTR(rec.getNumber()));
        if (res != null) {
            if (res.getCode() != 215) {
                throw new RuntimeException(res.getMessage());
            }
        } else {
            throw new RuntimeException("Response object is null");
        }
        new RecordingParser().parseRecording(rec, res.getMessage());
        return rec;
    }

    public Response deleteRecording(Recording rec) throws UnknownHostException, IOException {
        return this.send(new DELR(rec.getNumber()));
    }

    public List<EPGEntry> getEpg() throws UnknownHostException, IOException {
        return this.getEpg(new LSTE());
    }

    public List<EPGEntry> getEpg(int channelNumber) throws UnknownHostException, IOException {
        return this.getEpg(new LSTE(channelNumber));
    }

    private List<EPGEntry> getEpg(LSTE lste) throws UnknownHostException, IOException {
        List<EPGEntry> epg = null;
        Response res = this.send(lste);
        if (res != null) {
            if (res.getCode() != 215) {
                throw new RuntimeException(res.getMessage());
            }
        } else {
            throw new RuntimeException("Response object is null");
        }
        epg = new EPGParser().parse(res.getMessage());
        return epg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response send(Command cmd) throws UnknownHostException, IOException {
        Response res = null;
        if (this.connection == null) {
            logger.trace("New connection");
            this.connection = new Connection(this.host, this.port, this.connectTimeout);
        } else {
            logger.trace("old connection");
        }
        try {
            res = this.connection.send(cmd);
        }
        finally {
            lastTransmissionTime = System.currentTimeMillis();
            if (!persistentConnection) {
                this.connection.close();
                this.connection = null;
            } else if (timer == null) {
                logger.debug("Starting connection closer");
                timer = new java.util.Timer("SVDRP connection closer");
                timer.schedule((TimerTask)new ConnectionCloser(), 0L, 100L);
            }
        }
        return res;
    }

    public static void main(String[] args) throws UnknownHostException, IOException, ParseException {
        persistentConnection = true;
        VDR vdr = new VDR("localhost", 2001, 5000);
        Timer timer = new Timer();
        timer.setTitle("Testimer");
        Calendar startTime = Calendar.getInstance();
        startTime.set(2011, 10, 30, 20, 15);
        Calendar endTime = (Calendar)startTime.clone();
        endTime.add(12, 90);
        timer.setStartTime(startTime);
        timer.setEndTime(endTime);
        timer.setChannelNumber(2);
        vdr.newTimer(timer);
        VDR.timer.cancel();
        vdr.connection.close();
    }

    public boolean isAvailable() {
        return this.vdrAvailable;
    }

    static {
        lastTransmissionTime = 0L;
    }

    public class ConnectionTester
    extends Thread {
        private boolean running = false;

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    VDR.this.send(new STAT());
                    VDR.this.vdrAvailable = true;
                }
                catch (UnknownHostException e1) {
                    VDR.this.vdrAvailable = false;
                }
                catch (IOException e1) {
                    VDR.this.vdrAvailable = false;
                }
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                }
                catch (InterruptedException e) {
                    logger.warn("ConnectionTester interrupted while sleeping. Will stop now!");
                    this.running = false;
                }
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public void stopNow() {
            this.running = false;
            this.interrupt();
        }
    }

    class ConnectionCloser
    extends TimerTask {
        ConnectionCloser() {
        }

        @Override
        public void run() {
            if (VDR.this.connection != null && System.currentTimeMillis() - lastTransmissionTime > 15000L) {
                logger.debug("Closing connection");
                try {
                    VDR.this.connection.close();
                    VDR.this.connection = null;
                    timer.cancel();
                    timer = null;
                }
                catch (IOException e) {
                    logger.error("Couldn't close connection", (Throwable)e);
                }
            }
        }
    }
}

