#!/bin/ksh -p
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or https://opensource.org/licenses/CDDL-1.0.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#

#
# Copyright (c) 2023, Klara Inc.
#

. $STF_SUITE/include/libtest.shlib
. $STF_SUITE/tests/functional/block_cloning/block_cloning.kshlib

if ! command -v clonefile > /dev/null ; then
  log_unsupported "clonefile program required to test block cloning"
fi
if ! command -v clone_mmap_cached > /dev/null ; then
  log_unsupported "clone_mmap_cached program required to test block cloning"
fi

verify_runnable "global"

if tunable_exists BCLONE_ENABLED ; then
    log_must save_tunable BCLONE_ENABLED
    log_must set_tunable32 BCLONE_ENABLED 1
fi

log_pass
