/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.jobs.DefaultInvalidationFeedbackHandler;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;

class KeepAlivePingJob
extends AbstractJob {
    private static final Log log = Log.getLog(KeepAlivePingJob.class);
    private static final Map<String, Integer> failedAttempts = new HashMap<String, Integer>();
    private final DBPDataSource dataSource;
    private final boolean disconnectOnError;

    KeepAlivePingJob(DBPDataSource dataSource, boolean disconnectOnError) {
        super("Connection ping (" + dataSource.getContainer().getName() + ")");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
        this.disconnectOnError = disconnectOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        boolean hasDeadContexts = false;
        block5: for (DBSInstance dBSInstance : this.dataSource.getAvailableInstances()) {
            DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
            int n = dBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBCExecutionContext context = dBCExecutionContextArray[n2];
                try {
                    context.checkContextAlive(monitor);
                }
                catch (Exception e) {
                    log.debug("Context [" + this.dataSource.getName() + "::" + context.getContextName() + "] check failed: " + e.getMessage());
                    hasDeadContexts = true;
                    continue block5;
                }
                ++n2;
            }
        }
        if (hasDeadContexts) {
            List<InvalidateJob.ContextInvalidateResult> list = InvalidateJob.invalidateDataSource(monitor, this.dataSource, this.disconnectOnError, false, new DefaultInvalidationFeedbackHandler());
            Map<String, Integer> map = failedAttempts;
            synchronized (map) {
                String dsId = this.dataSource.getContainer().getId();
                if (InvalidateJob.anySucceeded(list) || this.disconnectOnError) {
                    log.debug("Datasource " + this.dataSource.getName() + " invalidated: " + String.valueOf(list));
                    failedAttempts.remove(dsId);
                } else {
                    log.debug("Datasource " + this.dataSource.getName() + " invalidate failed: " + String.valueOf(list));
                    Integer curAttempts = failedAttempts.get(dsId);
                    curAttempts = curAttempts == null ? Integer.valueOf(1) : Integer.valueOf(curAttempts + 1);
                    failedAttempts.put(dsId, curAttempts);
                }
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFailedAttemptCount(DBPDataSource dataSource) {
        Map<String, Integer> map = failedAttempts;
        synchronized (map) {
            Integer attempts = failedAttempts.get(dataSource.getContainer().getId());
            return attempts == null ? 0 : attempts;
        }
    }
}

