/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// Assertion struct for Assertion
type Assertion struct {
	TupleKey         AssertionTupleKey `json:"tuple_key" yaml:"tuple_key"`
	Expectation      bool              `json:"expectation" yaml:"expectation"`
	ContextualTuples *[]TupleKey       `json:"contextual_tuples,omitempty" yaml:"contextual_tuples,omitempty"`
	// Additional request context that will be used to evaluate any ABAC conditions encountered in the query evaluation.
	Context *map[string]interface{} `json:"context,omitempty" yaml:"context,omitempty"`
}

// NewAssertion instantiates a new Assertion object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAssertion(tupleKey AssertionTupleKey, expectation bool) *Assertion {
	this := Assertion{}
	this.TupleKey = tupleKey
	this.Expectation = expectation
	return &this
}

// NewAssertionWithDefaults instantiates a new Assertion object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAssertionWithDefaults() *Assertion {
	this := Assertion{}
	return &this
}

// GetTupleKey returns the TupleKey field value
func (o *Assertion) GetTupleKey() AssertionTupleKey {
	if o == nil {
		var ret AssertionTupleKey
		return ret
	}

	return o.TupleKey
}

// GetTupleKeyOk returns a tuple with the TupleKey field value
// and a boolean to check if the value has been set.
func (o *Assertion) GetTupleKeyOk() (*AssertionTupleKey, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TupleKey, true
}

// SetTupleKey sets field value
func (o *Assertion) SetTupleKey(v AssertionTupleKey) {
	o.TupleKey = v
}

// GetExpectation returns the Expectation field value
func (o *Assertion) GetExpectation() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Expectation
}

// GetExpectationOk returns a tuple with the Expectation field value
// and a boolean to check if the value has been set.
func (o *Assertion) GetExpectationOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Expectation, true
}

// SetExpectation sets field value
func (o *Assertion) SetExpectation(v bool) {
	o.Expectation = v
}

// GetContextualTuples returns the ContextualTuples field value if set, zero value otherwise.
func (o *Assertion) GetContextualTuples() []TupleKey {
	if o == nil || o.ContextualTuples == nil {
		var ret []TupleKey
		return ret
	}
	return *o.ContextualTuples
}

// GetContextualTuplesOk returns a tuple with the ContextualTuples field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Assertion) GetContextualTuplesOk() (*[]TupleKey, bool) {
	if o == nil || o.ContextualTuples == nil {
		return nil, false
	}
	return o.ContextualTuples, true
}

// HasContextualTuples returns a boolean if a field has been set.
func (o *Assertion) HasContextualTuples() bool {
	if o != nil && o.ContextualTuples != nil {
		return true
	}

	return false
}

// SetContextualTuples gets a reference to the given []TupleKey and assigns it to the ContextualTuples field.
func (o *Assertion) SetContextualTuples(v []TupleKey) {
	o.ContextualTuples = &v
}

// GetContext returns the Context field value if set, zero value otherwise.
func (o *Assertion) GetContext() map[string]interface{} {
	if o == nil || o.Context == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.Context
}

// GetContextOk returns a tuple with the Context field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Assertion) GetContextOk() (*map[string]interface{}, bool) {
	if o == nil || o.Context == nil {
		return nil, false
	}
	return o.Context, true
}

// HasContext returns a boolean if a field has been set.
func (o *Assertion) HasContext() bool {
	if o != nil && o.Context != nil {
		return true
	}

	return false
}

// SetContext gets a reference to the given map[string]interface{} and assigns it to the Context field.
func (o *Assertion) SetContext(v map[string]interface{}) {
	o.Context = &v
}

func (o Assertion) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_key"] = o.TupleKey
	toSerialize["expectation"] = o.Expectation
	if o.ContextualTuples != nil {
		toSerialize["contextual_tuples"] = o.ContextualTuples
	}
	if o.Context != nil {
		toSerialize["context"] = o.Context
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableAssertion struct {
	value *Assertion
	isSet bool
}

func (v NullableAssertion) Get() *Assertion {
	return v.value
}

func (v *NullableAssertion) Set(val *Assertion) {
	v.value = val
	v.isSet = true
}

func (v NullableAssertion) IsSet() bool {
	return v.isSet
}

func (v *NullableAssertion) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAssertion(val *Assertion) *NullableAssertion {
	return &NullableAssertion{value: val, isSet: true}
}

func (v NullableAssertion) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAssertion) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
